/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class PermissionsOraclev9i
extends PermissionsOracle {
    protected String hierarchyOption = "NO";
    private static final String[] TABLE_PRIVILEGES = new String[]{"ALL PRIVILEGES", "ALTER", "DELETE", "INDEX", "INSERT", "REFERENCES", "SELECT", "UPDATE", "DEBUG", "FLASHBACK", "ON COMMIT REFRESH", "QUERY REWRITE"};
    private static final String[] VIEW_PRIVILEGES = new String[]{"ALL PRIVILEGES", "DELETE", "INSERT", "SELECT", "UPDATE", "REFERENCES", "DEBUG", "FLASHBACK", "UNDER"};
    private static final String[] SNAPSHOT_PRIVILEGES = new String[]{"DELETE", "INSERT", "SELECT", "UPDATE", "FLASHBACK"};
    private static final String[] PROCEDURE_PRIVILEGES = new String[]{"EXECUTE", "DEBUG"};

    @Override
    public void showPropertyDialog() {
    }

    public String getHierarchyOption() {
        return this.hierarchyOption;
    }

    public void setHierarchyOption(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.hierarchyOption = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getTablePrivilegesValues() {
        return TABLE_PRIVILEGES;
    }

    public static String[] getViewPrivilegesValues() {
        return VIEW_PRIVILEGES;
    }

    public static String[] getSnapshotPrivilegesValues() {
        return SNAPSHOT_PRIVILEGES;
    }

    public static String[] getProcedurePrivilegesValues() {
        return PROCEDURE_PRIVILEGES;
    }

    @Override
    public void setPrivileges(String string) {
        if (((StorageDesignOracle)this.getStorageDesign()).isLoading()) {
            this.recreatePrivilegesSet(string);
        } else {
            this.addPrivilege(string);
        }
        this.privileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }
}

