/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.TablePropertyDialogOraclev11g;

public class TableProxyOraclev11g
extends TableProxyOraclev10g {
    public static final String BINARY_XML = "BINARY XML";
    public static final String SECUREFILE = "SECUREFILE";
    public static final String BASICFILE = "BASICFILE";
    public static final String FILESYSTEM_LIKE_LOGGING = "FILESYSTEM_LIKE_LOGGING";
    private static final String[] STORE_AS_CHOICES = new String[]{"BINARY XML", "CLOB", "OBJECT RELATIONAL"};
    private static Set storeAsSet = null;
    private static final String[] LOB_STORAGE_CHOICES = new String[]{"", "SECUREFILE", "BASICFILE"};
    private static Set lobStorageTypeSet = null;
    private static final String[] XMLTYPE_LOGGING_CHOICES = new String[]{"", "YES", "NO", "FILESYSTEM_LIKE_LOGGING"};
    private String lobStorageType = "";
    private String allowAnySchema = "";
    private String allowNonSchema = "";

    public TableProxyOraclev11g(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public TableProxyOraclev11g(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.storeAs = BINARY_XML;
    }

    public static String[] getStoreAsValues11g() {
        return STORE_AS_CHOICES;
    }

    @Override
    protected boolean checkStoreAs(String string) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(TableProxyOraclev11g.getStoreAsValues11g()));
        }
        return storeAsSet.contains(string);
    }

    public String getLobStorageType() {
        return this.lobStorageType;
    }

    public void setLobStorageType(String string) {
        if (!this.lobStorageType.equals(string) && this.checkLobStorageType(string)) {
            this.lobStorageType = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkLobStorageType(String string) {
        if (lobStorageTypeSet == null) {
            lobStorageTypeSet = new HashSet();
            lobStorageTypeSet.addAll(Arrays.asList(TableProxyOraclev11g.getLobStorageTypeValues()));
        }
        return lobStorageTypeSet.contains(string);
    }

    public static String[] getLobStorageTypeValues() {
        return LOB_STORAGE_CHOICES;
    }

    public String getAllowAnySchema() {
        return this.allowAnySchema;
    }

    public void setAllowAnySchema(String string) {
        if (!this.allowAnySchema.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.allowAnySchema = string;
            this.fireDataFieldChange();
        }
    }

    public String getAllowNonSchema() {
        return this.allowNonSchema;
    }

    public void setAllowNonSchema(String string) {
        if (!this.allowNonSchema.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.allowNonSchema = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getXmlTypeLoggingChoices11g() {
        return XMLTYPE_LOGGING_CHOICES;
    }

    @Override
    public void setXmlTypeLogging(String string) {
        super.setXmlTypeLogging(string);
        if (!this.xmlTypeLogging.equals(string) && FILESYSTEM_LIKE_LOGGING.equals(string)) {
            this.xmlTypeLogging = FILESYSTEM_LIKE_LOGGING;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)objectChangeEvent.getAffected();
            if (partitionOraclev11g.getPartOfStorageTable() == this) {
                partitionOraclev11g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(partitionOraclev11g);
                if (partitionOraclev11g.getPosition() == 0) {
                    partitionOraclev11g.removeObjectListener(this);
                    partitionOraclev11g.setPosition(this.listStorageTemplates.size());
                    partitionOraclev11g.addObjectListener(this);
                }
                return;
            }
            if (partitionOraclev11g.getSubPartitionOf() != null) {
                if (partitionOraclev11g.getPartitionList() == this.partitionList && this.partitionList != null && partitionOraclev11g.getPosition() == 0) {
                    int n = 0;
                    AbstractStorageObjectOracle abstractStorageObjectOracle = partitionOraclev11g.getSubPartitionOf();
                    if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                        PartitionOraclev11g partitionOraclev11g2 = (PartitionOraclev11g)abstractStorageObjectOracle;
                        partitionOraclev11g2.getRangeSubpartitions().add(partitionOraclev11g);
                        n = partitionOraclev11g2.getRangeSubpartitions().size();
                    } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                        ListPartitionOraclev11g listPartitionOraclev11g = (ListPartitionOraclev11g)abstractStorageObjectOracle;
                        listPartitionOraclev11g.getRangeSubpartitions().add(partitionOraclev11g);
                        n = listPartitionOraclev11g.getRangeSubpartitions().size();
                    }
                    if (n > 0) {
                        partitionOraclev11g.removeObjectListener(this);
                        partitionOraclev11g.setPosition(n);
                        partitionOraclev11g.addObjectListener(this);
                    }
                }
                return;
            }
        }
        super.changed(storageObject, objectChangeEvent);
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        PartitionOraclev11g partitionOraclev11g;
        if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof PartitionOraclev11g && (partitionOraclev11g = (PartitionOraclev11g)modelObjectSetEvent.getAffected()).getPartOfStorageTable() == this) {
            this.listStorageTemplates.remove(partitionOraclev11g);
            for (int i = 0; i < this.listStorageTemplates.size(); ++i) {
                ModelObject modelObject = this.listStorageTemplates.getElement(i);
                if (!(modelObject instanceof PartitionOracle)) continue;
                ((PartitionOracle)modelObject).setPosition(i + 1);
            }
            partitionOraclev11g.removeObjectListener(this);
            return;
        }
        super.changed(modelObjectSet, modelObjectSetEvent);
    }

    @Override
    protected void addPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
            if (partitionOraclev11g.getPartitionList() == this.partitionList && this.partitionList != null && partitionOraclev11g.getPartOfStorageTable() == null && partitionOraclev11g.getSubPartitionOf() == null) {
                partitionOraclev11g.addObjectListener(this);
                partitionOraclev11g.setParent(this.partitions);
                this.partitions.add(partitionOraclev11g);
                continue;
            }
            this.partitions.remove(partitionOraclev11g);
        }
    }

    @Override
    protected void addRangePartFromDesignToTemplates(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
            if (partitionOraclev11g.getPartOfStorageTable() == this) {
                partitionOraclev11g.addObjectListener(this);
                partitionOraclev11g.setParent(this.listStorageTemplates);
                this.listStorageTemplates.add(partitionOraclev11g);
                continue;
            }
            this.listStorageTemplates.remove(partitionOraclev11g);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogOraclev11g tablePropertyDialogOraclev11g = new TablePropertyDialogOraclev11g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogOraclev11g.show();
        }
    }
}

