/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxySetOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class PartitionOraclev11g
extends PartitionOraclev10g {
    private int numberOfChildren = 4;
    private TableProxyOracle partOfStorageTable;
    private AbstractStorageObjectOracle subPartitionOf;
    private StorageObjectCollection rangeSubpartitions;

    public PartitionOraclev11g(StorageDesign storageDesign) {
        super(storageDesign);
        PartitionSetOracle partitionSetOracle = ((StorageDesignOracle)storageDesign).getPartitionSet();
        this.rangeSubpartitions = new StorageObjectCollection(partitionSetOracle);
        this.rangeSubpartitions.setParent(this);
        this.rangeSubpartitions.setName(Messages.getString("PartitionOraclev11g.RangeSubpartitions"));
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.rangeSubpartitions.setSetMethod("setSubPartitionOf");
        this.rangeSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        partitionSetOracle.addSetListener(this);
        this.addRangeSubpartitionsFromDesign(partitionSetOracle);
    }

    protected void addRangeSubpartitionsFromDesign(PartitionSetOracle partitionSetOracle) {
        Iterator iterator = partitionSetOracle.iterator();
        while (iterator.hasNext()) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
            if (partitionOraclev11g.getSubPartitionOf() == this) {
                partitionOraclev11g.addObjectListener(this);
                partitionOraclev11g.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(partitionOraclev11g);
                continue;
            }
            this.rangeSubpartitions.remove(partitionOraclev11g);
        }
    }

    public StorageObjectCollection getRangeSubpartitions() {
        return this.rangeSubpartitions;
    }

    public void setPartOfStorageTable(TableProxyOracle tableProxyOracle) {
        if (this.partOfStorageTable != tableProxyOracle) {
            this.partOfStorageTable = tableProxyOracle;
            if (tableProxyOracle != null) {
                this.numberOfChildren = 1;
                this.useLobItems();
            }
        }
    }

    public TableProxyOracle getPartOfStorageTable() {
        return this.partOfStorageTable;
    }

    public void setSubPartitionOf(AbstractStorageObjectOracle abstractStorageObjectOracle) {
        if (this.subPartitionOf != abstractStorageObjectOracle) {
            this.subPartitionOf = abstractStorageObjectOracle;
            if (abstractStorageObjectOracle != null) {
                this.numberOfChildren = 1;
                this.useLobItems();
            }
        }
    }

    public AbstractStorageObjectOracle getSubPartitionOf() {
        return this.subPartitionOf;
    }

    private void useLobItems() {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
        storageDesignOracle.getLobStorageSet().removeSetListener(this);
        this.lobs = new StorageObjectCollection(storageDesignOracle.getHashPartitionLobItemSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("PartitionOracle.LobStorages"));
        this.lobs.setClassForParent(PartitionOracle.class);
        this.lobs.setSetMethod("setRangePartition");
        storageDesignOracle.getHashPartitionLobItemSet().addSetListener(this);
    }

    @Override
    public boolean hasSubPartitions() {
        return this.partitions.size() > 0 || this.listPartitions.size() > 0 || this.rangeSubpartitions.size() > 0;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)objectChangeEvent.getAffected();
            if (partitionOraclev11g.getSubPartitionOf() == this) {
                partitionOraclev11g.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(partitionOraclev11g);
                partitionOraclev11g.removeObjectListener(this);
                partitionOraclev11g.setPosition(this.rangeSubpartitions.size());
                partitionOraclev11g.addObjectListener(this);
            } else {
                this.rangeSubpartitions.remove(partitionOraclev11g);
            }
        } else {
            super.changed(storageObject, objectChangeEvent);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)modelObjectSetEvent.getAffected();
                partitionOraclev11g.addObjectListener(this);
                if (partitionOraclev11g.getSubPartitionOf() == this) {
                    partitionOraclev11g.setParent(this.rangeSubpartitions);
                    this.rangeSubpartitions.add(partitionOraclev11g);
                } else {
                    this.rangeSubpartitions.remove(partitionOraclev11g);
                }
            } else {
                super.changed(modelObjectSet, modelObjectSetEvent);
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)modelObjectSetEvent.getAffected();
                if (partitionOraclev11g.getSubPartitionOf() == this) {
                    this.rangeSubpartitions.remove(partitionOraclev11g);
                    for (int i = 0; i < this.rangeSubpartitions.size(); ++i) {
                        ((PartitionOracle)this.rangeSubpartitions.getElement(i)).setPosition(i + 1);
                    }
                }
                partitionOraclev11g.removeObjectListener(this);
            } else {
                super.changed(modelObjectSet, modelObjectSetEvent);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numberOfChildren;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.partitions;
            }
            case 2: {
                return this.listPartitions;
            }
            case 3: {
                return this.rangeSubpartitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobs) {
            return 0;
        }
        if (modelObject == this.partitions) {
            return 1;
        }
        if (modelObject == this.listPartitions) {
            return 2;
        }
        if (modelObject == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobs) {
            return 0;
        }
        if (object == this.partitions) {
            return 1;
        }
        if (object == this.listPartitions) {
            return 2;
        }
        if (object == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listPartitions.removeAll();
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionListOracle) {
        if (this.partitionList != partitionListOracle) {
            if (this.partitionList != null) {
                this.partitionList.removeObjectListener(this);
            }
            this.partitionList = partitionListOracle;
            this.fireDataFieldChange();
            if (partitionListOracle != null) {
                partitionListOracle.addObjectListener(this);
            }
        }
        if (partitionListOracle != null) {
            if ("HASH".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByHash();
            } else if ("LIST".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByList();
            } else if ("RANGE".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByRange();
            } else {
                this.disableSubPartitions();
            }
        }
    }

    @Override
    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitions.setForbiddenCreateElement(false);
        }
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void enableSubPartitionsByList() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(false);
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByRange() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(false);
    }

    @Override
    public void disableSubPartitions() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        PartitionOraclev11g partitionOraclev11g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev11g)storageDesign).getPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                partitionOraclev11g = (PartitionOraclev11g)storageObject;
            }
        } else {
            partitionOraclev11g = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().createPartition();
        }
        if (partitionOraclev11g != null) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            StorageObject storageObject2;
            StorageObject storageObject3;
            Object object;
            partitionOraclev11g.setName(this.getName());
            if (this.getPartitionList() != null) {
                object = (PartitionListOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (object == null) {
                    storageObject3 = (PartitionListOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionListSet().createPartitionList();
                    storageObject3.setName(this.getPartitionList().getName());
                    storageObject3.setRawObject(true);
                    partitionOraclev11g.setPartitionList((PartitionListOracle)storageObject3);
                } else {
                    partitionOraclev11g.setPartitionList((PartitionListOracle)object);
                }
            }
            if (this.getPartOfStorageTable() != null) {
                object = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getPartOfStorageTable().getObject().getName());
                storageObject3 = (TableProxyOraclev11g)storageDesign.getTableProxySet().getProxy(((ModelIDObject)object).getObjectID());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyOraclev11g)((TableProxySetOraclev11g)storageDesign.getTableProxySet()).createProxy((DesignObject)object);
                    ((RelationalObjectProxy)storageObject2).setName(this.getPartOfStorageTable().getName());
                    storageObject2.setRawObject(true);
                    partitionOraclev11g.setPartOfStorageTable((TableProxyOracle)storageObject2);
                } else {
                    partitionOraclev11g.setPartOfStorageTable((TableProxyOracle)storageObject3);
                }
            }
            if (this.getSubPartitionOf() != null) {
                object = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().getByName(this.getSubPartitionOf().getName());
                if (object == null) {
                    storageObject3 = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().createPartition();
                    storageObject3.setName(this.getSubPartitionOf().getName());
                    storageObject3.setRawObject(true);
                    partitionOraclev11g.setSubPartitionOf((AbstractStorageObjectOracle)storageObject3);
                } else {
                    partitionOraclev11g.setSubPartitionOf((AbstractStorageObjectOracle)object);
                }
            }
            object = this.getPartitions().iterator();
            while (object.hasNext()) {
                storageObject3 = (HashPartitionOraclev10g)object.next();
                storageObject2 = (HashPartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getHashPartitionSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    abstractStorageObjectOracle = (HashPartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getHashPartitionSet().createHashPartition();
                    abstractStorageObjectOracle.setName(storageObject3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((HashPartitionOracle)abstractStorageObjectOracle).setSubPartitionOf(partitionOraclev11g);
                    partitionOraclev11g.getPartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((HashPartitionOracle)storageObject2).setSubPartitionOf(partitionOraclev11g);
                partitionOraclev11g.getPartitions().add(storageObject2);
            }
            object = this.getLobs().iterator();
            while (object.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                storageObject3 = object.next();
                if (storageObject3 instanceof LobStorageOraclev10g) {
                    storageObject2 = (LobStorageOraclev10g)storageObject3;
                    abstractStorageObjectOracle = (LobStorageOraclev10g)((StorageDesignOraclev11g)storageDesign).getLobStorageSet().getByName(storageObject2.getName());
                    if (abstractStorageObjectOracle == null) {
                        abstractStorageObjectOracle2 = (LobStorageOraclev10g)((StorageDesignOraclev11g)storageDesign).getLobStorageSet().createLobStorage();
                        abstractStorageObjectOracle2.setName(storageObject2.getName());
                        abstractStorageObjectOracle2.setRawObject(true);
                        ((LobStorageOracle)abstractStorageObjectOracle2).setPartition(partitionOraclev11g);
                        partitionOraclev11g.getLobs().add(abstractStorageObjectOracle2);
                        continue;
                    }
                    ((LobStorageOracle)abstractStorageObjectOracle).setPartition(partitionOraclev11g);
                    partitionOraclev11g.getLobs().add(abstractStorageObjectOracle);
                    continue;
                }
                if (!(storageObject3 instanceof HashPartitionLobItemOracle)) continue;
                storageObject2 = (HashPartitionLobItemOracle)storageObject3;
                abstractStorageObjectOracle = (HashPartitionLobItemOracle)((StorageDesignOraclev11g)storageDesign).getLobStorageSet().getByName(storageObject2.getName());
                if (abstractStorageObjectOracle == null) {
                    abstractStorageObjectOracle2 = ((StorageDesignOraclev11g)storageDesign).getHashPartitionLobItemSet().createHashPartitionLobItem();
                    abstractStorageObjectOracle2.setName(storageObject2.getName());
                    abstractStorageObjectOracle2.setRawObject(true);
                    ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).setRangePartition(partitionOraclev11g);
                    partitionOraclev11g.getLobs().add(abstractStorageObjectOracle2);
                    continue;
                }
                ((HashPartitionLobItemOracle)abstractStorageObjectOracle).setRangePartition(partitionOraclev11g);
                partitionOraclev11g.getLobs().add(abstractStorageObjectOracle);
            }
            object = this.getListPartitions().iterator();
            while (object.hasNext()) {
                storageObject3 = (ListStorageTemplatePartitionOraclev10g)object.next();
                storageObject2 = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getListStorageTemplatePartitionSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    abstractStorageObjectOracle = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    abstractStorageObjectOracle.setName(storageObject3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle).setSubPartitionOf(partitionOraclev11g);
                    partitionOraclev11g.getListPartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((ListStorageTemplatePartitionOracle)storageObject2).setSubPartitionOf(partitionOraclev11g);
                partitionOraclev11g.getListPartitions().add(storageObject2);
            }
            object = this.getRangeSubpartitions().iterator();
            while (object.hasNext()) {
                storageObject3 = (PartitionOraclev11g)object.next();
                storageObject2 = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().getByName(storageObject3.getName());
                if (storageObject2 == null) {
                    abstractStorageObjectOracle = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().createPartition();
                    abstractStorageObjectOracle.setName(storageObject3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((PartitionOraclev11g)abstractStorageObjectOracle).setSubPartitionOf(partitionOraclev11g);
                    partitionOraclev11g.getRangeSubpartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((PartitionOraclev11g)storageObject2).setSubPartitionOf(partitionOraclev11g);
                partitionOraclev11g.getRangeSubpartitions().add(storageObject2);
            }
            partitionOraclev11g.setValueList(this.getValueList());
            partitionOraclev11g.setPosition(this.getPosition());
            if (this.getTableSpace() != null) {
                storageObject3 = (TableSpaceOraclev10g)((StorageDesignOraclev11g)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableSpaceOraclev10g)((StorageDesignOraclev11g)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject2).setName(this.getTableSpace().getName());
                    storageObject2.setRawObject(true);
                    partitionOraclev11g.setTableSpace((TableSpaceOracle)storageObject2);
                } else {
                    partitionOraclev11g.setTableSpace((TableSpaceOracle)storageObject3);
                }
            }
            partitionOraclev11g.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                storageObject3 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().createSegment();
                    storageObject2.setName(this.getSegment().getName());
                    storageObject2.setRawObject(true);
                    partitionOraclev11g.setSegment((SegmentOracle)storageObject2);
                } else {
                    partitionOraclev11g.setSegment((SegmentOracle)storageObject3);
                }
            }
            partitionOraclev11g.setDataSegmentCompression(this.getDataSegmentCompression());
            partitionOraclev11g.setIOTCompress(this.getIOTCompress());
            if (this.getIOTOverflowSegment() != null) {
                storageObject3 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().getByName(this.getIOTOverflowSegment().getName());
                if (storageObject3 == null) {
                    storageObject2 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().createSegment();
                    storageObject2.setName(this.getIOTOverflowSegment().getName());
                    storageObject2.setRawObject(true);
                    partitionOraclev11g.setIOTOverflowSegment((SegmentOracle)storageObject2);
                } else {
                    partitionOraclev11g.setIOTOverflowSegment((SegmentOracle)storageObject3);
                }
            }
            partitionOraclev11g.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            partitionOraclev11g.recreateSubPartitionsTSSet(this.getSubPartTSSet().toString());
            partitionOraclev11g.setComment(this.getComment());
            partitionOraclev11g.setRawObject(false);
        }
    }

    public PartitionOracle createRangeSubpartition() {
        if (this.rangeSubpartitions.getStorageObjectSet() != null) {
            return (PartitionOracle)this.rangeSubpartitions.createElement(null);
        }
        return null;
    }
}

