/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v11g;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.LobStorageOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ListPartitionPropertyDialogOraclev11g;

public class ListPartitionOraclev11g
extends ListPartitionOraclev10g
implements ModelObjectSetListener,
StorageObjectListener {
    private InlineList subPartitionsTableSpacesSet = null;
    private int subPartitionsQuantity = 0;
    private String subPartitionsTableSpaces = "";
    private StorageObjectCollection hashSubpartitions;
    private StorageObjectCollection listSubpartitions;
    private StorageObjectCollection rangeSubpartitions;

    public ListPartitionOraclev11g(StorageDesign storageDesign) {
        super(storageDesign);
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
        this.setStorageDesign(storageDesignOracle);
        this.hashSubpartitions = new StorageObjectCollection(storageDesignOracle.getHashPartitionSet());
        this.hashSubpartitions.setParent(this);
        this.hashSubpartitions.setName(Messages.getString("PartitionOracle.HashSubpartitions"));
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.hashSubpartitions.setSetMethod("setSubPartitionOf");
        this.hashSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getHashPartitionSet().addSetListener(this);
        this.listSubpartitions = new StorageObjectCollection(storageDesignOracle.getListStorageTemplatePartitionSet());
        this.listSubpartitions.setParent(this);
        this.listSubpartitions.setName(Messages.getString("PartitionOracle.ListSubpartitions"));
        this.listSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.listSubpartitions.setSetMethod("setSubPartitionOf");
        this.listSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getListStorageTemplatePartitionSet().addSetListener(this);
        this.addListSubpartitionsFromDesign(storageDesignOracle.getListStorageTemplatePartitionSet());
        PartitionSetOracle partitionSetOracle = storageDesignOracle.getPartitionSet();
        this.rangeSubpartitions = new StorageObjectCollection(partitionSetOracle);
        this.rangeSubpartitions.setParent(this);
        this.rangeSubpartitions.setName(Messages.getString("PartitionOraclev11g.RangeSubpartitions"));
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.rangeSubpartitions.setSetMethod("setSubPartitionOf");
        this.rangeSubpartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        partitionSetOracle.addSetListener(this);
        this.addRangeSubpartitionsFromDesign(partitionSetOracle);
    }

    protected void addListSubpartitionsFromDesign(ListStorageTemplatePartitionSetOracle listStorageTemplatePartitionSetOracle) {
        Iterator iterator = listStorageTemplatePartitionSetOracle.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)iterator.next();
            if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                listStorageTemplatePartitionOracle.addObjectListener(this);
                listStorageTemplatePartitionOracle.setParent(this.listSubpartitions);
                this.listSubpartitions.add(listStorageTemplatePartitionOracle);
                continue;
            }
            this.listSubpartitions.remove(listStorageTemplatePartitionOracle);
        }
    }

    protected void addRangeSubpartitionsFromDesign(PartitionSetOracle partitionSetOracle) {
        Iterator iterator = partitionSetOracle.iterator();
        while (iterator.hasNext()) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
            if (partitionOraclev11g.getSubPartitionOf() == this) {
                partitionOraclev11g.addObjectListener(this);
                partitionOraclev11g.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(partitionOraclev11g);
                continue;
            }
            this.rangeSubpartitions.remove(partitionOraclev11g);
        }
    }

    public StorageObjectCollection getHashSubpartitions() {
        return this.hashSubpartitions;
    }

    public StorageObjectCollection getListSubpartitions() {
        return this.listSubpartitions;
    }

    public StorageObjectCollection getRangeSubpartitions() {
        return this.rangeSubpartitions;
    }

    public boolean hasSubPartitions() {
        return this.hashSubpartitions.size() > 0 || this.listSubpartitions.size() > 0 || this.rangeSubpartitions.size() > 0;
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int n) {
        if (this.subPartitionsQuantity != n) {
            this.subPartitionsQuantity = n;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.subPartitionsTableSpaces, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string.trim());
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(string);
        } else {
            this.addSubPartitionsTS(string);
        }
        String string2 = this.getSubPartTSSet().toString();
        if (!this.subPartitionsTableSpaces.equals(string2)) {
            this.subPartitionsTableSpaces = string2;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionsTS(String string) {
        if (!this.getSubPartTSSet().contains(string)) {
            this.getSubPartTSSet().add(string);
        }
    }

    public void recreateSubPartitionsTSSet(String string) {
        this.getSubPartTSSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            this.getSubPartTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getSubPartTSSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)objectChangeEvent.getAffected();
            if (hashPartitionOracle.getSubPartitionOf() == this) {
                hashPartitionOracle.setParent(this.hashSubpartitions);
                this.hashSubpartitions.add(hashPartitionOracle);
            } else {
                this.hashSubpartitions.remove(hashPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)objectChangeEvent.getAffected();
            if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                listStorageTemplatePartitionOracle.setParent(this.listSubpartitions);
                this.listSubpartitions.add(listStorageTemplatePartitionOracle);
            } else {
                this.listSubpartitions.remove(listStorageTemplatePartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof PartitionOraclev11g) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)objectChangeEvent.getAffected();
            if (partitionOraclev11g.getSubPartitionOf() == this) {
                partitionOraclev11g.setParent(this.rangeSubpartitions);
                this.rangeSubpartitions.add(partitionOraclev11g);
            } else {
                this.rangeSubpartitions.remove(partitionOraclev11g);
            }
        } else {
            super.changed(storageObject, objectChangeEvent);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                hashPartitionOracle.addObjectListener(this);
                if (hashPartitionOracle.getSubPartitionOf() == this) {
                    hashPartitionOracle.setParent(this.hashSubpartitions);
                    this.hashSubpartitions.add(hashPartitionOracle);
                } else {
                    this.hashSubpartitions.remove(hashPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)modelObjectSetEvent.getAffected();
                listStorageTemplatePartitionOracle.addObjectListener(this);
                if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                    listStorageTemplatePartitionOracle.setParent(this.listSubpartitions);
                    this.listSubpartitions.add(listStorageTemplatePartitionOracle);
                } else {
                    this.listSubpartitions.remove(listStorageTemplatePartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)modelObjectSetEvent.getAffected();
                partitionOraclev11g.addObjectListener(this);
                if (partitionOraclev11g.getSubPartitionOf() == this) {
                    partitionOraclev11g.setParent(this.rangeSubpartitions);
                    this.rangeSubpartitions.add(partitionOraclev11g);
                } else {
                    this.rangeSubpartitions.remove(partitionOraclev11g);
                }
            } else {
                super.changed(modelObjectSet, modelObjectSetEvent);
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                this.hashSubpartitions.remove(hashPartitionOracle);
                hashPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)modelObjectSetEvent.getAffected();
                this.listSubpartitions.remove(listStorageTemplatePartitionOracle);
                listStorageTemplatePartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)modelObjectSetEvent.getAffected();
                if (partitionOraclev11g.getSubPartitionOf() == this) {
                    this.rangeSubpartitions.remove(partitionOraclev11g);
                    for (int i = 0; i < this.rangeSubpartitions.size(); ++i) {
                        ((PartitionOracle)this.rangeSubpartitions.getElement(i)).setPosition(i + 1);
                    }
                }
                partitionOraclev11g.removeObjectListener(this);
            } else {
                super.changed(modelObjectSet, modelObjectSetEvent);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 4;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.hashSubpartitions;
            }
            case 2: {
                return this.listSubpartitions;
            }
            case 3: {
                return this.rangeSubpartitions;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobs) {
            return 0;
        }
        if (modelObject == this.hashSubpartitions) {
            return 1;
        }
        if (modelObject == this.listSubpartitions) {
            return 2;
        }
        if (modelObject == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobs) {
            return 0;
        }
        if (object == this.hashSubpartitions) {
            return 1;
        }
        if (object == this.listSubpartitions) {
            return 2;
        }
        if (object == this.rangeSubpartitions) {
            return 3;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ListPartitionPropertyDialogOraclev11g listPartitionPropertyDialogOraclev11g = new ListPartitionPropertyDialogOraclev11g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            listPartitionPropertyDialogOraclev11g.show();
        }
    }

    @Override
    public void setPartitionList(PartitionListOracle partitionListOracle) {
        if (this.partitionList != partitionListOracle) {
            if (this.partitionList != null) {
                this.partitionList.removeObjectListener(this);
            }
            this.partitionList = partitionListOracle;
            this.fireDataFieldChange();
            if (partitionListOracle != null) {
                partitionListOracle.addObjectListener(this);
            }
        }
        if (partitionListOracle != null) {
            if ("HASH".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByHash();
            } else if ("LIST".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByList();
            } else if ("RANGE".equalsIgnoreCase(partitionListOracle.getSubpartitionType())) {
                this.enableSubPartitionsByRange();
            } else {
                this.disableSubPartitions();
            }
        }
    }

    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.hashSubpartitions.setForbiddenCreateElement(true);
        } else {
            this.hashSubpartitions.setForbiddenCreateElement(false);
        }
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByList() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(false);
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    public void enableSubPartitionsByRange() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(false);
    }

    public void disableSubPartitions() {
        this.hashSubpartitions.setForbiddenCreateElement(true);
        this.hashSubpartitions.removeAll();
        this.listSubpartitions.setForbiddenCreateElement(true);
        this.listSubpartitions.removeAll();
        this.rangeSubpartitions.setForbiddenCreateElement(true);
        this.rangeSubpartitions.removeAll();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ListPartitionOraclev11g listPartitionOraclev11g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev11g)storageDesign).getListPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                listPartitionOraclev11g = (ListPartitionOraclev11g)storageObject;
            }
        } else {
            listPartitionOraclev11g = (ListPartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getListPartitionSet().createListPartition();
        }
        if (listPartitionOraclev11g != null) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            AbstractStorageObjectOracle abstractStorageObjectOracle2;
            AbstractStorageObjectOracle abstractStorageObjectOracle3;
            Object object;
            listPartitionOraclev11g.setName(this.getName());
            if (this.getPartitionList() != null) {
                object = (PartitionListOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (object == null) {
                    abstractStorageObjectOracle3 = (PartitionListOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionListSet().createPartitionList();
                    abstractStorageObjectOracle3.setName(this.getPartitionList().getName());
                    abstractStorageObjectOracle3.setRawObject(true);
                    listPartitionOraclev11g.setPartitionList((PartitionListOracle)abstractStorageObjectOracle3);
                } else {
                    listPartitionOraclev11g.setPartitionList((PartitionListOracle)object);
                }
            }
            object = this.lobs.iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle3 = (LobStorageOraclev10g)object.next();
                abstractStorageObjectOracle2 = (LobStorageOraclev10g)((StorageDesignOraclev11g)storageDesign).getLobStorageSet().getByName(abstractStorageObjectOracle3.getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (LobStorageOraclev10g)((StorageDesignOraclev11g)storageDesign).getLobStorageSet().createLobStorage();
                    abstractStorageObjectOracle.setName(abstractStorageObjectOracle3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((LobStorageOracle)abstractStorageObjectOracle).setListPartition(listPartitionOraclev11g);
                    continue;
                }
                ((LobStorageOracle)abstractStorageObjectOracle2).setListPartition(listPartitionOraclev11g);
            }
            object = this.getHashSubpartitions().iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle3 = (HashPartitionOraclev10g)object.next();
                abstractStorageObjectOracle2 = (HashPartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getHashPartitionSet().getByName(abstractStorageObjectOracle3.getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (HashPartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getHashPartitionSet().createHashPartition();
                    abstractStorageObjectOracle.setName(abstractStorageObjectOracle3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((HashPartitionOracle)abstractStorageObjectOracle).setSubPartitionOf(listPartitionOraclev11g);
                    listPartitionOraclev11g.getHashSubpartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((HashPartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(listPartitionOraclev11g);
                listPartitionOraclev11g.getHashSubpartitions().add(abstractStorageObjectOracle2);
            }
            object = this.getListSubpartitions().iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle3 = (ListStorageTemplatePartitionOraclev10g)object.next();
                abstractStorageObjectOracle2 = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getListStorageTemplatePartitionSet().getByName(abstractStorageObjectOracle3.getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (ListStorageTemplatePartitionOraclev10g)((StorageDesignOraclev11g)storageDesign).getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    abstractStorageObjectOracle.setName(abstractStorageObjectOracle3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle).setSubPartitionOf(listPartitionOraclev11g);
                    listPartitionOraclev11g.getListSubpartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((ListStorageTemplatePartitionOracle)abstractStorageObjectOracle2).setSubPartitionOf(listPartitionOraclev11g);
                listPartitionOraclev11g.getListSubpartitions().add(abstractStorageObjectOracle2);
            }
            object = this.getRangeSubpartitions().iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle3 = (PartitionOraclev11g)object.next();
                abstractStorageObjectOracle2 = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().getByName(abstractStorageObjectOracle3.getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (PartitionOraclev11g)((StorageDesignOraclev11g)storageDesign).getPartitionSet().createPartition();
                    abstractStorageObjectOracle.setName(abstractStorageObjectOracle3.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    ((PartitionOraclev11g)abstractStorageObjectOracle).setSubPartitionOf(listPartitionOraclev11g);
                    listPartitionOraclev11g.getRangeSubpartitions().add(abstractStorageObjectOracle);
                    continue;
                }
                ((PartitionOraclev11g)abstractStorageObjectOracle2).setSubPartitionOf(listPartitionOraclev11g);
                listPartitionOraclev11g.getRangeSubpartitions().add(abstractStorageObjectOracle2);
            }
            listPartitionOraclev11g.setColumns(this.getColumns());
            listPartitionOraclev11g.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getTablespace() != null) {
                abstractStorageObjectOracle3 = (TableSpaceOraclev10g)((StorageDesignOraclev11g)storageDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (abstractStorageObjectOracle3 == null) {
                    abstractStorageObjectOracle2 = (TableSpaceOraclev10g)((StorageDesignOraclev11g)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)abstractStorageObjectOracle2).setName(this.getTablespace().getName());
                    abstractStorageObjectOracle2.setRawObject(true);
                    listPartitionOraclev11g.setTablespace((TableSpaceOracle)abstractStorageObjectOracle2);
                } else {
                    listPartitionOraclev11g.setTablespace((TableSpaceOracle)abstractStorageObjectOracle3);
                }
            }
            listPartitionOraclev11g.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                abstractStorageObjectOracle3 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (abstractStorageObjectOracle3 == null) {
                    abstractStorageObjectOracle2 = (SegmentOraclev10g)((StorageDesignOraclev11g)storageDesign).getSegmentSet().createSegment();
                    abstractStorageObjectOracle2.setName(this.getSegment().getName());
                    abstractStorageObjectOracle2.setRawObject(true);
                    listPartitionOraclev11g.setSegment((SegmentOracle)abstractStorageObjectOracle2);
                } else {
                    listPartitionOraclev11g.setSegment((SegmentOracle)abstractStorageObjectOracle3);
                }
            }
            listPartitionOraclev11g.setSubPartitionsQuantity(this.getSubPartitionsQuantity());
            listPartitionOraclev11g.recreateSubPartitionsTSSet(this.getSubPartTSSet().toString());
            listPartitionOraclev11g.setComment(this.getComment());
            listPartitionOraclev11g.setRawObject(false);
        }
    }

    public HashPartitionOracle createHashSubpartition() {
        if (this.hashSubpartitions.getStorageObjectSet() != null) {
            return (HashPartitionOracle)this.hashSubpartitions.createElement(null);
        }
        return null;
    }

    public ListStorageTemplatePartitionOracle createListSubpartition() {
        if (this.listSubpartitions.getStorageObjectSet() != null) {
            return (ListStorageTemplatePartitionOracle)this.listSubpartitions.createElement(null);
        }
        return null;
    }

    public PartitionOracle createRangeSubpartition() {
        if (this.rangeSubpartitions.getStorageObjectSet() != null) {
            return (PartitionOracle)this.rangeSubpartitions.createElement(null);
        }
        return null;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append("| ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

