/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.UniqueConstraintPropertyDialogOraclev10g;

public class UniqueOraclev10g
extends UniqueOracle {
    public static final String LOCAL = "LOCAL";
    public static final String GLOBAL_BY_RANGE = "GLOBAL BY RANGE";
    public static final String GLOBAL_HASH_PARTITIONED_BY_QUANTITY = "GLOBAL HASH PARTITIONED BY QUANTITY";
    public static final String GLOBAL_HASH_PARTITIONED_BY_LIST = "GLOBAL HASH PARTITIONED BY LIST";
    public static final String BY_INDEX_NAME = "BY INDEX NAME";
    public static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    private static final String[] USING_INDEX = new String[]{"NO", "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static Set usingIndexSet = null;
    private String usingIndex = "NO";
    private String createIndexStatement = "";
    private static final String[] INDEX_SORT = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set indexSortSet = null;
    private String indexSort = "SORTED";
    private String computeStatistics = "NO";

    public UniqueOraclev10g(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public UniqueOraclev10g(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    protected void initPartitions(StorageDesignOracle storageDesignOracle) {
        super.initPartitions(storageDesignOracle);
        ((StorageDesignOraclev10g)storageDesignOracle).getIndexHashPartitionSet().addSetListener(this);
    }

    public static String[] getUsingIndexChoices() {
        return USING_INDEX;
    }

    private boolean checkUsingIndex(String string) {
        if (usingIndexSet == null) {
            usingIndexSet = new HashSet();
            usingIndexSet.addAll(Arrays.asList(UniqueOraclev10g.getUsingIndexChoices()));
        }
        return usingIndexSet.contains(string);
    }

    @Override
    public void setUsingIndex(String string) {
        if (this.checkUsingIndex(string)) {
            if (!this.usingIndex.equalsIgnoreCase(string)) {
                this.partitions.removeAll();
            }
            this.usingIndex = string;
            if (this.usingIndex.equalsIgnoreCase(GLOBAL_BY_RANGE)) {
                this.enableSubPartitionsByRange();
            } else if (this.usingIndex.equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                this.enableSubPartitionsByHash();
            } else {
                this.partitions.setForbiddenCreateElement(true);
                this.partitions.removeAll();
            }
            this.fireDataFieldChange();
        }
    }

    private void enableSubPartitionsByRange() {
        Iterator iterator = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet().iterator();
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev10g indexGlobalPartitionOraclev10g = (IndexGlobalPartitionOraclev10g)iterator.next();
            if (indexGlobalPartitionOraclev10g.getIndexGlobalPartList() == null || indexGlobalPartitionOraclev10g.getIndexGlobalPartList() != this.getUsingIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    private void enableSubPartitionsByHash() {
        Iterator iterator = ((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet().iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() == null || indexHashPartitionOraclev10g.getIndexGlobalPartList() != this.getUsingIndexGlobalPL()) continue;
            this.partitions.setForbiddenCreateElement(true);
        }
    }

    @Override
    public String getUsingIndex() {
        return this.usingIndex;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UniqueConstraintPropertyDialogOraclev10g uniqueConstraintPropertyDialogOraclev10g = new UniqueConstraintPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            uniqueConstraintPropertyDialogOraclev10g.show();
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)objectChangeEvent.getAffected();
            if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                indexGlobalPartitionOracle.setParent(this.partitions);
                this.partitions.add(indexGlobalPartitionOracle);
            } else {
                this.partitions.remove(indexGlobalPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)objectChangeEvent.getAffected();
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                indexHashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(indexHashPartitionOraclev10g);
            } else {
                this.partitions.remove(indexHashPartitionOraclev10g);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                indexGlobalPartitionOracle.addObjectListener(this);
                if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getUsingIndexGlobalPL() && !this.partitions.contains(indexGlobalPartitionOracle)) {
                    indexGlobalPartitionOracle.setParent(this.partitions);
                    this.partitions.add(indexGlobalPartitionOracle);
                } else {
                    this.partitions.remove(indexGlobalPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)modelObjectSetEvent.getAffected();
                indexHashPartitionOraclev10g.addObjectListener(this);
                if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getUsingIndexGlobalPL() && !this.partitions.contains(indexHashPartitionOraclev10g)) {
                    indexHashPartitionOraclev10g.setParent(this.partitions);
                    this.partitions.add(indexHashPartitionOraclev10g);
                } else {
                    this.partitions.remove(indexHashPartitionOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(indexGlobalPartitionOracle);
                indexGlobalPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof IndexHashPartitionOraclev10g) {
                IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)modelObjectSetEvent.getAffected();
                this.partitions.remove(indexHashPartitionOraclev10g);
                indexHashPartitionOraclev10g.removeObjectListener(this);
            }
        }
    }

    @Override
    public void setUsingIndexGlobalPL(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        if (this.indexGlobalPartitionList != null && this.indexGlobalPartitionList != indexGlobalPartitionsListOracle) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        if (indexGlobalPartitionsListOracle != null) {
            this.indexGlobalPartitionList = indexGlobalPartitionsListOracle;
            this.indexGlobalPartitionList.setIndex(this);
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionsListOracle);
            if (((UniqueOracle)indexGlobalPartitionsListOracle.getIndex()).getUsingIndex().equalsIgnoreCase(USING_INDEX[2])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
                this.addIGPFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexGlobalPartitionSet());
            } else if (((UniqueOracle)indexGlobalPartitionsListOracle.getIndex()).getUsingIndex().equalsIgnoreCase(USING_INDEX[4])) {
                this.partitions.setStorageObjectSet(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
                this.addIndexHashPartitionFromDesign(((StorageDesignOraclev10g)this.getStorageDesign()).getIndexHashPartitionSet());
            } else {
                this.partitions.removeAll();
                this.partitions.setForbiddenCreateElement(true);
            }
        }
        this.fireDataFieldChange();
    }

    protected void addIndexHashPartitionFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            IndexHashPartitionOraclev10g indexHashPartitionOraclev10g = (IndexHashPartitionOraclev10g)iterator.next();
            indexHashPartitionOraclev10g.addObjectListener(this);
            if (indexHashPartitionOraclev10g.getIndexGlobalPartList() != null && indexHashPartitionOraclev10g.getIndexGlobalPartList() == this.getUsingIndexGlobalPL()) {
                indexHashPartitionOraclev10g.setParent(this.partitions);
                this.partitions.add(indexHashPartitionOraclev10g);
                continue;
            }
            this.partitions.remove(indexHashPartitionOraclev10g);
        }
    }

    public static String[] getIndexSortChoices() {
        return INDEX_SORT;
    }

    private boolean checkIndexSort(String string) {
        if (indexSortSet == null) {
            indexSortSet = new HashSet();
            indexSortSet.addAll(Arrays.asList(UniqueOraclev10g.getIndexSortChoices()));
        }
        return indexSortSet.contains(string);
    }

    @Override
    public void setIndexSort(String string) {
        if (this.checkIndexSort(string)) {
            this.indexSort = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getIndexSort() {
        return this.indexSort;
    }

    public String getCreateIndexStatement() {
        return this.createIndexStatement;
    }

    public void setCreateIndexStatement(String string) {
        this.createIndexStatement = string;
        this.fireDataFieldChange();
    }

    @Override
    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    @Override
    public void setComputeStatistics(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.computeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Index index = (Index)storageDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        UniqueOraclev10g uniqueOraclev10g = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignOraclev10g)storageDesign).getUniqueSet().getProxy(index.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            uniqueOraclev10g = (UniqueOraclev10g)relationalObjectProxy;
        }
        if (uniqueOraclev10g != null) {
            StorageObject storageObject;
            ModelIDObject modelIDObject;
            uniqueOraclev10g.setName(this.getName());
            uniqueOraclev10g.setDeferrable(this.getDeferrable());
            uniqueOraclev10g.setInitially(this.getInitially());
            uniqueOraclev10g.setEnable(this.getEnable());
            uniqueOraclev10g.setValidate(this.getValidate());
            uniqueOraclev10g.setUsingIndex(this.getUsingIndex());
            if (this.getExceptionsTable() != null) {
                modelIDObject = (Table)storageDesign.getPhysicalDesign().getTableSet().getByName(this.getExceptionsTable().getObject().getName());
                storageObject = (TableProxyOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableProxySet().getProxy(modelIDObject.getObjectID());
                if (storageObject == null) {
                    TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableProxySet()).createProxy((DesignObject)modelIDObject);
                    tableProxyOraclev10g.setName(this.getExceptionsTable().getName());
                    tableProxyOraclev10g.setRawObject(true);
                    uniqueOraclev10g.setExceptionsTable(tableProxyOraclev10g);
                } else {
                    uniqueOraclev10g.setExceptionsTable((TableProxyOracle)storageObject);
                }
            }
            if (this.getUsingIndexGlobalPL() != null) {
                modelIDObject = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().getByName(this.getUsingIndexGlobalPL().getName());
                if (modelIDObject == null) {
                    storageObject = (IndexGlobalPartitionsListOraclev10g)((StorageDesignOraclev10g)storageDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    storageObject.setName(this.getName());
                    storageObject.setRawObject(true);
                    uniqueOraclev10g.setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)storageObject);
                } else {
                    uniqueOraclev10g.setUsingIndexGlobalPL((IndexGlobalPartitionsListOracle)modelIDObject);
                }
            }
            uniqueOraclev10g.setIndexSort(this.getIndexSort());
            if (this.getTableSpace() != null) {
                modelIDObject = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (modelIDObject == null) {
                    storageObject = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)storageObject).setName(this.getTableSpace().getName());
                    storageObject.setRawObject(true);
                    uniqueOraclev10g.setTableSpace((TableSpaceOracle)storageObject);
                } else {
                    uniqueOraclev10g.setTableSpace((TableSpaceOracle)modelIDObject);
                }
            }
            uniqueOraclev10g.setLogging(this.getLogging());
            if (this.getIndexSegment() != null) {
                modelIDObject = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().getByName(this.getIndexSegment().getName());
                if (modelIDObject == null) {
                    storageObject = (SegmentOraclev10g)((StorageDesignOraclev10g)storageDesign).getSegmentSet().createSegment();
                    storageObject.setName(this.getIndexSegment().getName());
                    storageObject.setRawObject(true);
                    uniqueOraclev10g.setIndexSegment((SegmentOracle)storageObject);
                } else {
                    uniqueOraclev10g.setIndexSegment((SegmentOracle)modelIDObject);
                }
            }
            uniqueOraclev10g.setComment(this.getComment());
            uniqueOraclev10g.setCommentInRDBMS(this.getCommentInRDBMS());
            uniqueOraclev10g.setRawObject(false);
        }
    }
}

