/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TemporaryTablespacePropertyDialogOraclev10g;

public class TemporaryTablespaceOraclev10g
extends TemporaryTablespaceOraclev9i
implements ModelObjectSetListener,
StorageObjectListener {
    private static Set fileTypeSet = null;
    private String fileType = FILE_TYPES[0];
    public static String BIGFILE = "BIGFILE";
    public static String SMALLFILE = "SMALLFILE";
    private static final String[] FILE_TYPES = new String[]{"", BIGFILE, SMALLFILE};
    private String tableSpaceGroup = "";
    private StorageObjectCollection dfiles;
    private String oracleManagedFiles = "NO";

    public TemporaryTablespaceOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.setParent(((StorageDesignOraclev10g)storageDesign).getTableSpaceSet());
        this.dfiles = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setTemporaryTablespace");
        this.dfiles.setClassForParent(TemporaryTablespaceOraclev10g.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOraclev10g)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TemporaryTablespacePropertyDialogOraclev10g temporaryTablespacePropertyDialogOraclev10g = new TemporaryTablespacePropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            temporaryTablespacePropertyDialogOraclev10g.show();
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        if (this.checkFileTypeState(string)) {
            this.fileType = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkFileTypeState(String string) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(TemporaryTablespaceOraclev10g.getFileTypes()));
        }
        return fileTypeSet.contains(string);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public String getTableSpaceGroup() {
        return this.tableSpaceGroup;
    }

    public void setTableSpaceGroup(String string) {
        this.tableSpaceGroup = string;
    }

    public void setOracleManagedFiles(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.oracleManagedFiles = string;
        }
    }

    public String getOracleManagedFiles() {
        return this.oracleManagedFiles;
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof DataFileOraclev10g) {
                DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)modelObjectSetEvent.getAffected();
                dataFileOraclev10g.addObjectListener(this);
                if (dataFileOraclev10g.getTemporaryTablespace() != null && dataFileOraclev10g.getTemporaryTablespace() == this) {
                    dataFileOraclev10g.setParent(this.dfiles);
                    this.dfiles.add(dataFileOraclev10g);
                } else {
                    this.dfiles.remove(dataFileOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)modelObjectSetEvent.getAffected();
            this.dfiles.remove(dataFileOraclev10g);
            dataFileOraclev10g.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)objectChangeEvent.getAffected();
            if (dataFileOraclev10g.getTemporaryTablespace() != null && dataFileOraclev10g.getTemporaryTablespace() == this) {
                if (this.getOracleManagedFiles().equalsIgnoreCase("YES")) {
                    this.dfiles.setAllowedNumberOfElements(1);
                } else {
                    this.dfiles.setAllowedNumberOfElements(99999);
                }
                dataFileOraclev10g.setParent(this.dfiles);
                this.dfiles.add(dataFileOraclev10g);
            } else {
                this.dfiles.remove(dataFileOraclev10g);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.dfiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.dfiles) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.dfiles.removeAll();
    }

    public StorageObjectCollection getDFiles() {
        return this.dfiles;
    }

    public DataFileOracle createDataFile() {
        if (this.dfiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.dfiles.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TemporaryTablespaceOraclev10g temporaryTablespaceOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getTemporaryTablespaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                temporaryTablespaceOraclev10g = (TemporaryTablespaceOraclev10g)storageObject;
            }
        } else {
            temporaryTablespaceOraclev10g = (TemporaryTablespaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
        }
        if (temporaryTablespaceOraclev10g != null) {
            temporaryTablespaceOraclev10g.setName(this.getName());
            Iterator iterator = this.getDFiles().iterator();
            while (iterator.hasNext()) {
                DataFileOraclev10g dataFileOraclev10g = (DataFileOraclev10g)iterator.next();
                DataFileOraclev10g dataFileOraclev10g2 = (DataFileOraclev10g)((StorageDesignOraclev10g)storageDesign).getDataFileSet().getByName(dataFileOraclev10g.getName());
                if (dataFileOraclev10g2 == null) {
                    DataFileOraclev10g dataFileOraclev10g3 = (DataFileOraclev10g)((StorageDesignOraclev10g)storageDesign).getDataFileSet().createDataFile();
                    dataFileOraclev10g3.setName(dataFileOraclev10g.getName());
                    dataFileOraclev10g3.setRawObject(true);
                    dataFileOraclev10g3.setTemporaryTablespace(temporaryTablespaceOraclev10g);
                    ((StorageDesignOraclev10g)storageDesign).getDataFileSet().add(dataFileOraclev10g3);
                    temporaryTablespaceOraclev10g.getDFiles().add(dataFileOraclev10g3);
                    continue;
                }
                ((StorageDesignOraclev10g)storageDesign).getDataFileSet().add(dataFileOraclev10g2);
                dataFileOraclev10g2.setTemporaryTablespace(temporaryTablespaceOraclev10g);
                temporaryTablespaceOraclev10g.getDFiles().add(dataFileOraclev10g2);
            }
            temporaryTablespaceOraclev10g.setTableSpaceGroup(this.getTableSpaceGroup());
            temporaryTablespaceOraclev10g.setUniformSize(this.getUniformSize());
            temporaryTablespaceOraclev10g.setMeasureUnitUniformSize(this.getMeasureUnitUniformSize());
            temporaryTablespaceOraclev10g.setFileType(this.getFileType());
            temporaryTablespaceOraclev10g.setOracleManagedFiles(this.getOracleManagedFiles());
            temporaryTablespaceOraclev10g.setComment(this.getComment());
            temporaryTablespaceOraclev10g.setRawObject(false);
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        this.dfiles.removeAll();
    }
}

