/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceOraclev10g
extends TableSpaceOraclev9i {
    private static Set fileTypeSet = null;
    public static final String BIGFILE = "BIGFILE";
    public static final String SMALLFILE = "SMALLFILE";
    private String fileType = FILE_TYPES[0];
    private static final String[] FILE_TYPES = new String[]{"", "BIGFILE", "SMALLFILE"};
    private static final String[] FLASHBACK_STATES = new String[]{"ON", "OFF"};
    private static List flashBackList = Arrays.asList(FLASHBACK_STATES);
    private static Set flashBackSet = null;
    private String flashBack = FLASHBACK_STATES[0];
    private static Set dsCompressionSet = null;
    private String dsCompression = DS_COMPRESSION_CHOICES[0];
    private static final String[] DS_COMPRESSION_CHOICES = new String[]{"", "NOCOMPRESS", "COMPRESS"};
    private List propertyWrapperList = null;

    public TableSpaceOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        if (this.checkFileTypeState(string)) {
            this.fileType = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkFileTypeState(String string) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFileTypes()));
        }
        return fileTypeSet.contains(string);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public static String[] getFlashBackChoices() {
        return FLASHBACK_STATES;
    }

    protected boolean checkFlashBack(String string) {
        if (flashBackSet == null) {
            flashBackSet = new HashSet();
            flashBackSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFlashBackChoices()));
        }
        return flashBackSet.contains(string);
    }

    public void setFlashBack(String string) {
        if (this.checkFlashBack(string)) {
            this.flashBack = string;
            this.fireDataFieldChange();
        }
    }

    public String getFlashBack() {
        return this.flashBack;
    }

    public static List getFlashBackValues() {
        return flashBackList;
    }

    public String getDSCompression() {
        return this.dsCompression;
    }

    public void setDSCompression(String string) {
        if (this.checkDSCompressionState(string)) {
            this.dsCompression = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkDSCompressionState(String string) {
        if (dsCompressionSet == null) {
            dsCompressionSet = new HashSet();
            dsCompressionSet.addAll(Arrays.asList(TableSpaceOraclev10g.getDSCompressionStates()));
        }
        return dsCompressionSet.contains(string);
    }

    public static String[] getDSCompressionStates() {
        return DS_COMPRESSION_CHOICES;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = super.getPropertyWrapperList();
            this.propertyWrapperList.add(new PropertyWrapper("File Type", this, "getFileType", "setFileType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Default Compression", this, "getDSCompression", "setDSCompression", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("FlashBack Mode", this, "getFlashBack", "setFlashBack", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        TableSpaceOraclev10g tableSpaceOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                tableSpaceOraclev10g = (TableSpaceOraclev10g)storageObject;
            }
        } else {
            tableSpaceOraclev10g = (TableSpaceOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpaceOraclev10g != null) {
            StorageObject storageObject2;
            StorageObject storageObject3;
            StorageObject storageObject4;
            tableSpaceOraclev10g.setObjectID(this.getObjectID());
            tableSpaceOraclev10g.setName(this.getName());
            Iterator iterator = this.getTabcoll().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (StorageObjectPlaceHolder)iterator.next();
                storageObject3 = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableProxySet()).getByName(((StorageObjectPlaceHolder)storageObject4).getName());
                if (storageObject3 == null) {
                    storageObject2 = (TableProxyOraclev10g)((TableProxySetOraclev10g)((StorageDesignOraclev10g)storageDesign).getTableProxySet()).createProxy(storageObject4.getGenerator());
                    ((RelationalObjectProxy)storageObject2).setName(((StorageObjectPlaceHolder)storageObject4).getName());
                    ((TableProxyOracle)storageObject2).setTableSpace(tableSpaceOraclev10g);
                    storageObject2.setRawObject(true);
                    tableSpaceOraclev10g.registerToTableProxyFromDesign(((StorageDesignOraclev10g)storageDesign).getTableProxySet());
                    continue;
                }
                ((TableProxyOracle)storageObject3).setTableSpace(tableSpaceOraclev10g);
                tableSpaceOraclev10g.registerToTableProxyFromDesign(((StorageDesignOraclev10g)storageDesign).getTableProxySet());
            }
            iterator = this.getDfiles().iterator();
            while (iterator.hasNext()) {
                storageObject4 = (DataFileOraclev10g)iterator.next();
                storageObject3 = (DataFileOraclev10g)((StorageDesignOraclev10g)storageDesign).getDataFileSet().getByName(storageObject4.getName());
                if (storageObject3 == null) {
                    storageObject2 = (DataFileOraclev10g)((StorageDesignOraclev10g)storageDesign).getDataFileSet().createDataFile();
                    storageObject2.setName(storageObject4.getName());
                    ((DataFileOracle)storageObject2).setTableSpace(tableSpaceOraclev10g);
                    storageObject2.setRawObject(true);
                    tableSpaceOraclev10g.getDfiles().add(storageObject2);
                    continue;
                }
                ((DataFileOracle)storageObject3).setTableSpace(tableSpaceOraclev10g);
                tableSpaceOraclev10g.getDfiles().add(storageObject3);
            }
            tableSpaceOraclev10g.setMinExtLen(this.getMinExtLen());
            tableSpaceOraclev10g.setBlockSize(this.getBlockSize());
            tableSpaceOraclev10g.setLogging(this.getLogging());
            tableSpaceOraclev10g.setForceLogging(this.getForceLogging());
            tableSpaceOraclev10g.setStatus(this.getStatus());
            tableSpaceOraclev10g.setContents(this.getContents());
            tableSpaceOraclev10g.setDSInitialExtent(this.getDSInitialExtent());
            tableSpaceOraclev10g.setDSNextExtent(this.getDSNextExtent());
            tableSpaceOraclev10g.setDSMinExtents(this.getDSMinExtents());
            tableSpaceOraclev10g.setDSMaxExtents(this.getDSMaxExtents());
            tableSpaceOraclev10g.setDSPctIncrease(this.getDSPctIncrease());
            tableSpaceOraclev10g.setExtentManagement(this.getExtentManagement());
            tableSpaceOraclev10g.setEMLocalSubtype(this.getEMLocalSubtype());
            tableSpaceOraclev10g.setEMUniformSize(this.getEMUniformSize());
            tableSpaceOraclev10g.setSegmentManagement(this.getSegmentManagement());
            tableSpaceOraclev10g.setFileType(this.getFileType());
            tableSpaceOraclev10g.setFlashBack(this.getFlashBack());
            tableSpaceOraclev10g.setDSCompression(this.getDSCompression());
            tableSpaceOraclev10g.setComment(this.getComment());
            tableSpaceOraclev10g.setRawObject(false);
        }
    }
}

