/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.FailGroupPropertyDialogOraclev10g;

public class FailGroupOraclev10g
extends AbstractStorageObjectOracle
implements StorageObjectListener,
ModelObjectSetListener {
    private DiskGroupOraclev10g diskGroup;
    StorageObjectCollection asmDisks;
    public static final String TYPE_NAME = "FailGroup";

    public FailGroupOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.asmDisks = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getASMDiskSet());
        this.asmDisks.setParent(this);
        this.asmDisks.setName(Messages.getString("FailGroupOraclev10g.ASMDisk"));
        this.asmDisks.setSetMethod("setFailGroup");
        this.asmDisks.setClassForParent(FailGroupOraclev10g.class);
        ((StorageDesignOraclev10g)storageDesign).getASMDiskSet().addSetListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FailGroupPropertyDialogOraclev10g failGroupPropertyDialogOraclev10g = new FailGroupPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            failGroupPropertyDialogOraclev10g.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "FG";
    }

    public DiskGroupOraclev10g getDiskGroup() {
        return this.diskGroup;
    }

    public void setDiskGroup(DiskGroupOraclev10g diskGroupOraclev10g) {
        this.diskGroup = diskGroupOraclev10g;
        this.setPAC_Element(diskGroupOraclev10g);
        this.fireDataFieldChange();
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.asmDisks;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.asmDisks) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.asmDisks) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.asmDisks.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ASMDiskOraclev10g) {
                ASMDiskOraclev10g aSMDiskOraclev10g = (ASMDiskOraclev10g)modelObjectSetEvent.getAffected();
                aSMDiskOraclev10g.addObjectListener(this);
                if (aSMDiskOraclev10g.getFailGroup() != null && aSMDiskOraclev10g.getFailGroup() == this) {
                    aSMDiskOraclev10g.setParent(this.asmDisks);
                    this.asmDisks.add(aSMDiskOraclev10g);
                } else {
                    this.asmDisks.remove(aSMDiskOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof ASMDiskOraclev10g) {
            ASMDiskOraclev10g aSMDiskOraclev10g = (ASMDiskOraclev10g)modelObjectSetEvent.getAffected();
            this.asmDisks.remove(aSMDiskOraclev10g);
            aSMDiskOraclev10g.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof ASMDiskOraclev10g) {
            ASMDiskOraclev10g aSMDiskOraclev10g = (ASMDiskOraclev10g)objectChangeEvent.getAffected();
            if (aSMDiskOraclev10g.getFailGroup() != null && aSMDiskOraclev10g.getFailGroup() == this) {
                aSMDiskOraclev10g.setParent(this.asmDisks);
                this.asmDisks.add(aSMDiskOraclev10g);
            } else {
                this.asmDisks.remove(aSMDiskOraclev10g);
            }
        }
    }

    public List getASMDisks() {
        ArrayList arrayList = new ArrayList();
        this.asmDisks.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getASMDiskCollection() {
        return this.asmDisks;
    }

    public ASMDiskOraclev10g createASMDisk() {
        if (this.asmDisks.getStorageObjectSet() != null) {
            return (ASMDiskOraclev10g)this.asmDisks.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        FailGroupOraclev10g failGroupOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getFailGroupSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                failGroupOraclev10g = (FailGroupOraclev10g)storageObject;
            }
        } else {
            failGroupOraclev10g = ((StorageDesignOraclev10g)storageDesign).getFailGroupSet().createFailGroup();
        }
        if (failGroupOraclev10g != null) {
            failGroupOraclev10g.setName(this.getName());
            for (ASMDiskOraclev10g aSMDiskOraclev10g : this.getASMDisks()) {
                ASMDiskOraclev10g aSMDiskOraclev10g2 = (ASMDiskOraclev10g)((StorageDesignOraclev10g)storageDesign).getASMDiskSet().getByName(aSMDiskOraclev10g.getName());
                if (aSMDiskOraclev10g2 == null) {
                    ASMDiskOraclev10g aSMDiskOraclev10g3 = ((StorageDesignOraclev10g)storageDesign).getASMDiskSet().createASMDisk();
                    aSMDiskOraclev10g3.setName(aSMDiskOraclev10g.getName());
                    aSMDiskOraclev10g3.setFailGroup(failGroupOraclev10g);
                    aSMDiskOraclev10g3.setRawObject(true);
                    failGroupOraclev10g.getASMDisks().add(aSMDiskOraclev10g3);
                    continue;
                }
                aSMDiskOraclev10g2.setFailGroup(failGroupOraclev10g);
                failGroupOraclev10g.getASMDisks().add(aSMDiskOraclev10g2);
            }
            failGroupOraclev10g.setComment(this.getComment());
            failGroupOraclev10g.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.asmDisks.removeAll();
    }
}

