/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DirectoryOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableColumnOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ExternalTableOraclePropertyDialogv10g;

public class ExternalTableOraclev10g
extends ExternalTableOracle
implements ModelObjectSetListener,
StorageObjectListener {
    public ExternalTableOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.cols = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getExternalColumnSet());
        this.cols.setParent(this);
        this.cols.setName(Messages.getString("TableProxy.Columns"));
        this.cols.setClassForParent(ExternalTableOracle.class);
        this.cols.setSetMethod("setExternalTable");
        this.cols.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        ((StorageDesignOraclev10g)storageDesign).getExternalColumnSet().addSetListener(this);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof ExternalTableColumnOraclev10g) {
            ExternalTableColumnOraclev10g externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)objectChangeEvent.getAffected();
            if (externalTableColumnOraclev10g.getExternalTable() != null && externalTableColumnOraclev10g.getExternalTable() == this) {
                externalTableColumnOraclev10g.setParent(this.cols);
                this.cols.add(externalTableColumnOraclev10g);
            } else {
                this.cols.remove(externalTableColumnOraclev10g);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ExternalTableColumnOraclev10g) {
                ExternalTableColumnOraclev10g externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)modelObjectSetEvent.getAffected();
                externalTableColumnOraclev10g.addObjectListener(this);
                if (externalTableColumnOraclev10g.getExternalTable() != null && externalTableColumnOraclev10g.getExternalTable() == this) {
                    externalTableColumnOraclev10g.setParent(this.cols);
                    this.cols.add(externalTableColumnOraclev10g);
                } else {
                    this.cols.remove(externalTableColumnOraclev10g);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof ExternalTableColumnOraclev10g) {
            ExternalTableColumnOraclev10g externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)modelObjectSetEvent.getAffected();
            this.cols.remove(externalTableColumnOraclev10g);
            externalTableColumnOraclev10g.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.cols;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.cols.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ExternalTableOraclePropertyDialogv10g externalTableOraclePropertyDialogv10g = new ExternalTableOraclePropertyDialogv10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            externalTableOraclePropertyDialogv10g.show();
        }
    }

    public StorageObjectCollection getColumns() {
        return this.cols;
    }

    public ExternalTableColumnOracle createColumn() {
        if (this.cols.getStorageObjectSet() != null) {
            return (ExternalTableColumnOracle)this.cols.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ExternalTableOraclev10g externalTableOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getExternalTableSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                externalTableOraclev10g = (ExternalTableOraclev10g)storageObject;
            }
        } else {
            externalTableOraclev10g = (ExternalTableOraclev10g)((StorageDesignOraclev10g)storageDesign).getExternalTableSet().createExternalTable();
        }
        if (externalTableOraclev10g != null) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            AbstractStorageObjectOracle abstractStorageObjectOracle2;
            externalTableOraclev10g.setName(this.getName());
            Iterator iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                abstractStorageObjectOracle2 = (ExternalTableColumnOraclev10g)iterator.next();
                abstractStorageObjectOracle = (ExternalTableColumnOraclev10g)((StorageDesignOraclev10g)storageDesign).getExternalColumnSet().getByName(abstractStorageObjectOracle2.getName());
                if (abstractStorageObjectOracle == null) {
                    ExternalTableColumnOraclev10g externalTableColumnOraclev10g = (ExternalTableColumnOraclev10g)((StorageDesignOraclev10g)storageDesign).getExternalColumnSet().createExternalColumn();
                    externalTableColumnOraclev10g.setName(abstractStorageObjectOracle2.getName());
                    externalTableColumnOraclev10g.setExternalTable(externalTableOraclev10g);
                    externalTableColumnOraclev10g.setRawObject(true);
                    externalTableOraclev10g.getColumns().add(externalTableColumnOraclev10g);
                    continue;
                }
                ((ExternalTableColumnOracle)abstractStorageObjectOracle).setExternalTable(externalTableOraclev10g);
                externalTableOraclev10g.getColumns().add(abstractStorageObjectOracle);
            }
            if (this.getOwner() != null) {
                abstractStorageObjectOracle2 = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().getByName(this.getOwner().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (UserOraclev10g)((StorageDesignOraclev10g)storageDesign).getUserSet().createUser();
                    ((UserOracle)abstractStorageObjectOracle).setName(this.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    externalTableOraclev10g.setOwner((UserOracle)abstractStorageObjectOracle);
                } else {
                    externalTableOraclev10g.setOwner((UserOracle)abstractStorageObjectOracle2);
                }
            }
            externalTableOraclev10g.setAccessDriverType(this.getAccessDriverType());
            if (this.getDefaultDir() != null) {
                abstractStorageObjectOracle2 = (DirectoryOraclev10g)((StorageDesignOraclev10g)storageDesign).getDirectorySet().getByName(this.getDefaultDir().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = (DirectoryOraclev10g)((StorageDesignOraclev10g)storageDesign).getDirectorySet().createDirectory();
                    abstractStorageObjectOracle.setName(this.getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    externalTableOraclev10g.setDefaultDir((DirectoryOracle)abstractStorageObjectOracle);
                } else {
                    externalTableOraclev10g.setDefaultDir((DirectoryOracle)abstractStorageObjectOracle2);
                }
            }
            externalTableOraclev10g.setAccessParametersType(this.getAccessParametersType());
            externalTableOraclev10g.setLocation(this.getLocation());
            externalTableOraclev10g.setParallel(this.getParallel());
            externalTableOraclev10g.setParallelNum(this.getParallelNum());
            externalTableOraclev10g.setRejectLimit(this.getRejectLimit());
            externalTableOraclev10g.setComment(this.getComment());
            externalTableOraclev10g.setRawObject(false);
        }
    }
}

