/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FailGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ASMDiskPropertyDialogOraclev10g;

public class ASMDiskOraclev10g
extends AbstractStorageObjectOracle {
    private FailGroupOraclev10g failGroup;
    private String searchString = "";
    private int size = 0;
    private static Set sizeMeasurementUnitSet = null;
    private String sizeMeasurementUnit = SIZE_MEASUREMENT_UNITS[1];
    private static final String[] SIZE_MEASUREMENT_UNITS = new String[]{"K", "M", "G", "T"};
    private String force = "NO";
    public static final String TYPE_NAME = "ASMDisk";

    public void setForce(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.force = string;
            this.fireDataFieldChange();
        }
    }

    public String getForce() {
        return this.force;
    }

    public String getSizeMeasurementUnit() {
        return this.sizeMeasurementUnit;
    }

    public void setSizeMeasurementUnit(String string) {
        if (this.checkSizeMeasurementUnits(string)) {
            this.sizeMeasurementUnit = string;
            this.fireDataFieldChange();
        }
    }

    private boolean checkSizeMeasurementUnits(String string) {
        if (sizeMeasurementUnitSet == null) {
            sizeMeasurementUnitSet = new HashSet();
            sizeMeasurementUnitSet.addAll(Arrays.asList(ASMDiskOraclev10g.getSizeMeasurementUnitStates()));
        }
        return sizeMeasurementUnitSet.contains(string);
    }

    public static String[] getSizeMeasurementUnitStates() {
        return SIZE_MEASUREMENT_UNITS;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ASMDiskPropertyDialogOraclev10g aSMDiskPropertyDialogOraclev10g = new ASMDiskPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            aSMDiskPropertyDialogOraclev10g.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ASM";
    }

    public FailGroupOraclev10g getFailGroup() {
        return this.failGroup;
    }

    public void setFailGroup(FailGroupOraclev10g failGroupOraclev10g) {
        this.failGroup = failGroupOraclev10g;
        if (failGroupOraclev10g != null) {
            this.setPAC_Element(failGroupOraclev10g.getPAC_Element());
        }
        this.fireDataFieldChange();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.fireDataFieldChange();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        this.fireDataFieldChange();
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ASMDiskOraclev10g aSMDiskOraclev10g = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)storageDesign).getASMDiskSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                aSMDiskOraclev10g = (ASMDiskOraclev10g)storageObject;
            }
        } else {
            aSMDiskOraclev10g = ((StorageDesignOraclev10g)storageDesign).getASMDiskSet().createASMDisk();
        }
        if (aSMDiskOraclev10g != null) {
            aSMDiskOraclev10g.setName(this.getName());
            aSMDiskOraclev10g.setSearchString(this.getSearchString());
            aSMDiskOraclev10g.setSize(this.getSize());
            aSMDiskOraclev10g.setSizeMeasurementUnit(this.getSizeMeasurementUnit());
            aSMDiskOraclev10g.setForce(this.getForce());
            aSMDiskOraclev10g.setComment(this.getComment());
            aSMDiskOraclev10g.setRawObject(false);
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

