/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public abstract class TriggerOracle
extends Trigger {
    protected TableProxyOracle table;
    protected TableViewProxyOracle view;
    protected UserOracle owner;
    private String columns = "";
    private ArraySet columnSet = null;
    protected String scope = SCOPE_TYPES[0];
    protected String state = "";
    protected String ref_OLD_AS = "";
    protected String ref_NEW_AS = "";
    protected String ref_PARENT_AS = "";
    protected String condition = "";
    public static final String BEFORE = "BEFORE";
    public static final String AFTER = "AFTER";
    public static final String INSTEAD_OF = "INSTEAD OF";
    public static final String[] TRIGGER_TIMES_TABLE = new String[]{"BEFORE", "AFTER"};
    public static final String[] TRIGGER_TIMES = new String[]{"BEFORE", "AFTER", "INSTEAD OF"};
    private static List triggerTimeList = Arrays.asList(TRIGGER_TIMES);
    private static Set triggerTimeSet = null;
    public static final String[] SCOPE_TYPES = new String[]{"FOR EACH ROW", "FOR EACH STATEMENT"};
    private static List scopeList = Arrays.asList(SCOPE_TYPES);
    private static Set scopeSet = null;
    public static final String[] STATE_TYPES = new String[]{"ENABLE", "DISABLE"};
    private static List stateList = Arrays.asList(STATE_TYPES);

    public TriggerOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime(BEFORE);
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        this.table = tableProxyOracle;
        if (tableProxyOracle != null) {
            tableProxyOracle.addObject(this);
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyOracle getView() {
        return this.view;
    }

    public void setView(TableViewProxyOracle tableViewProxyOracle) {
        this.view = tableViewProxyOracle;
        if (tableViewProxyOracle != null) {
            this.setTriggerTime(INSTEAD_OF);
        }
        this.fireDataFieldChange();
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    public static List getTriggerValues() {
        return triggerTimeList;
    }

    @Override
    protected boolean checkTriggerTime(String string) {
        if (triggerTimeSet == null) {
            triggerTimeSet = new HashSet();
            triggerTimeSet.addAll(Arrays.asList(TriggerOracle.getTriggerTimes()));
        }
        return triggerTimeSet.contains(string);
    }

    public static String[] getScopeTypes() {
        return SCOPE_TYPES;
    }

    public static List getScopeValues() {
        return scopeList;
    }

    protected boolean checkScope(String string) {
        if (scopeSet == null) {
            scopeSet = new HashSet();
            scopeSet.addAll(Arrays.asList(TriggerOracle.getScopeTypes()));
        }
        return scopeSet.contains(string);
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (!this.getColumnSet().contains(string2)) {
            this.getColumnSet().add(string2);
        }
    }

    private void recreateColumnSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(string);
        } else {
            this.addColumn(string);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ArraySet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ArraySet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
        this.fireDataFieldChange();
    }

    public String getRef_PARENT_AS() {
        return this.ref_PARENT_AS;
    }

    public void setRef_PARENT_AS(String string) {
        this.ref_PARENT_AS = string;
        this.fireDataFieldChange();
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle userOracle) {
        this.owner = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getRef_NEW_AS() {
        return this.ref_NEW_AS;
    }

    public void setRef_NEW_AS(String string) {
        this.ref_NEW_AS = string;
        this.fireDataFieldChange();
    }

    public String getRef_OLD_AS() {
        return this.ref_OLD_AS;
    }

    public void setRef_OLD_AS(String string) {
        this.ref_OLD_AS = string;
        this.fireDataFieldChange();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        if (this.checkScope(string)) {
            this.scope = string;
            this.fireDataFieldChange();
        }
    }

    public boolean isScopeForEachRow() {
        return this.getScope().equalsIgnoreCase(SCOPE_TYPES[0]);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        if ("".equals(string) || stateList.contains(string)) {
            this.state = string;
        }
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeObject(this);
        }
        super.remove();
    }

    public String getColumnsNames() {
        String string = "";
        if (this.getTable() != null) {
            boolean bl = true;
            ColumnProxy[] columnProxyArray = this.getTable().getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                ColumnProxy columnProxy = columnProxyArray[i];
                if (!this.getColumnSet().contains(columnProxy.getObjectID())) continue;
                if (bl) {
                    string = columnProxy.getName();
                    bl = false;
                    continue;
                }
                string = string + "," + columnProxy.getName();
            }
        }
        return string;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getOwner() != null) {
            string = this.getOwner().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public class ArraySet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

