/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;

public abstract class TableProxySetOracle
extends TableProxySet {
    public TableProxySetOracle(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected abstract RelationalObjectProxy createProxy(DesignObject var1);

    @Override
    protected abstract RelationalObjectProxy createProxy(Design var1, String var2, String var3);

    @Override
    public void doAfterAdd(RelationalObjectProxy relationalObjectProxy) {
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            this.add(relationalObjectProxy);
            if (!this.getStorageDesign().isLoading()) {
                TableSpaceOracle tableSpaceOracle;
                TableProxyOracle tableProxyOracle = (TableProxyOracle)relationalObjectProxy;
                this.applyTemplate(tableProxyOracle);
                StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.getStorageDesign();
                UserOracle userOracle = storageDesignOracle.getDefaultUser();
                if (userOracle != null) {
                    tableProxyOracle.setUser(userOracle);
                }
                if (tableProxyOracle.getTableSpace() == null && (tableSpaceOracle = storageDesignOracle.getDefaultTableSpace()) != null) {
                    tableProxyOracle.setTableSpace(tableSpaceOracle);
                }
            }
            this.fireUpdate();
        }
    }

    protected void applyTemplate(TableProxyOracle tableProxyOracle) {
        if (this.getDesign().getAppView().getSettings().useOracleTableTemplate()) {
            Object object;
            OracleTableTemplate oracleTableTemplate = this.getDesign().getAppView().getSettings().getOracleTableTemplate();
            tableProxyOracle.setTemporary(oracleTableTemplate.getTemporary());
            tableProxyOracle.setTempPreserveRows(oracleTableTemplate.getPreserveRows());
            String string = oracleTableTemplate.getTableSpace().trim();
            if (!"".equalsIgnoreCase(string)) {
                object = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string);
                if (object == null) {
                    object = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)object).setName(string);
                }
                tableProxyOracle.setTableSpace((TableSpaceOracle)object);
            }
            tableProxyOracle.setOrganization(oracleTableTemplate.getOrganization());
            tableProxyOracle.setLogging(oracleTableTemplate.getLogging());
            object = oracleTableTemplate.getSegment().trim();
            if (!"".equalsIgnoreCase((String)object)) {
                SegmentOracle segmentOracle = (SegmentOracle)((StorageDesignOracle)this.getStorageDesign()).getSegmentSet().getByName((String)object);
                if (segmentOracle == null) {
                    segmentOracle = ((StorageDesignOracle)this.getStorageDesign()).getSegmentSet().createSegment();
                    segmentOracle.setName((String)object);
                }
                tableProxyOracle.setSegment(segmentOracle);
            }
            tableProxyOracle.setCache(oracleTableTemplate.getCache());
            tableProxyOracle.setMonitoring(oracleTableTemplate.getMonitoring());
            tableProxyOracle.setParallel(oracleTableTemplate.getParallel());
            tableProxyOracle.setDegree(oracleTableTemplate.getDegree());
            tableProxyOracle.setPartitioned(oracleTableTemplate.getPartitioned());
            tableProxyOracle.setParttitionedRowMovement(oracleTableTemplate.getRowMovement());
            tableProxyOracle.setDataSegmentCompression(oracleTableTemplate.getDataCompression());
        }
    }

    protected SnapshotOracle createSnapshot(String string) {
        return ((StorageDesignOracle)this.getStorageDesign()).getSnapshotSet().createSnapshot(string);
    }

    @Override
    public TableProxyOracle getByName(String string) {
        string = string.startsWith("\"") ? string.replaceAll("\"", "") : string.toUpperCase();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            String string2 = tableProxyOracle.getName();
            if (!tableProxyOracle.getNameHasQuotes()) {
                string2 = string2.toUpperCase();
            }
            if (!string.equals(string2)) continue;
            return tableProxyOracle;
        }
        return null;
    }

    public TableProxyOracle getByLongName(String string, String string2) {
        if (string2 == null) {
            return this.getByName(string);
        }
        if (string2.startsWith("\"")) {
            string2 = string2.replaceAll("\"", "");
        }
        string = string.startsWith("\"") ? string.replaceAll("\"", "") : string.toUpperCase();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Table table;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            String string3 = tableProxyOracle.getName();
            if (!string.equalsIgnoreCase(string3) || tableProxyOracle.getNameHasQuotes() && !string.equals(string3)) continue;
            UserOracle userOracle = tableProxyOracle.getUser();
            if (userOracle != null && userOracle.getName().equalsIgnoreCase(string2)) {
                return tableProxyOracle;
            }
            if (userOracle != null || !(table = (Table)tableProxyOracle.getObject()).getSchema().equalsIgnoreCase(string2)) continue;
            return tableProxyOracle;
        }
        return null;
    }
}

