/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;

public abstract class TableProxyOracle
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    public static final String CLOB = "CLOB";
    public static final String OBJECT_RELATIONAL = "OBJECT RELATIONAL";
    public static final String ENABLE = "ENABLE";
    public static final String DISABLE = "DISABLE";
    public static final String RETENTION = "RETENTION";
    public static final String PCT_VERSION = "PCT_VERSION";
    private static final String[] STORE_AS_CHOICES = new String[]{"CLOB", "OBJECT RELATIONAL"};
    public static final String[] ORGANIZATION = new String[]{"HEAP", "INDEX"};
    public static final String[] PARTITIONED_ROW_MOVEMENT = new String[]{"ENABLE", "DISABLE"};
    private static List organizationList = Arrays.asList(ORGANIZATION);
    private static List partRowMovementList = Arrays.asList(PARTITIONED_ROW_MOVEMENT);
    private static Set organizationSet = null;
    private static Set partitionedRowMovementSet = null;
    private static Set storeAsSet = null;
    private static final String[] STORAGE_IN_ROW_CHOICES = new String[]{"ENABLE", "DISABLE"};
    private static final String[] XMLTYPE_CACHE_CHOICES = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    private static Set xmlTypeCacheSet = null;
    private static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    private static Set oldVersionSet = null;
    private InlineList clusterColumnsSet = null;
    private UserOracle user = null;
    private String temporary = "NO";
    private String tempPreserveRows = "YES";
    private TableSpaceOracle tableSpace = null;
    private String organization = ORGANIZATION[0];
    private ClusterOracle cluster = null;
    private String clusterColumns = "";
    private String logging = "YES";
    private SegmentOracle segment = null;
    private String cache = "NO";
    private String monitoring = "NO";
    private String parallel = "NO";
    private String degree = "";
    private String rowDependency = "NO";
    protected PartitionListOracle partitionList = null;
    private String partitionedRowMovement = "ENABLE";
    private int iotCompress = 0;
    private int iotPctThreshold = 0;
    private ColumnProxy iotIncluding = null;
    private SegmentOracle iotOverflowSegment = null;
    private String dataSegmentCompression = "NO";
    protected String storeAs = STORE_AS_CHOICES[0];
    private String xmlSchemaUrl = "";
    private String xmlSchemaElement = "";
    private String lobSegmentName = "";
    private TableSpaceOracle xmlTypeTableSpace = null;
    private String storageInRow = "ENABLE";
    protected String xmlTypeLogging = "";
    private String xmlTypeCache = XMLTYPE_CACHE_CHOICES[1];
    private int chunk = 0;
    private String oldVersions = "RETENTION";
    private int pctVersion = 0;
    private int freepools = 0;
    protected StorageObjectCollection fkeys;
    protected StorageObjectCollection pkeys;
    protected StorageObjectCollection ukeys;
    protected StorageObjectCollection tableCheckConstraints;
    protected StorageObjectCollection triggers;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection lobs;
    protected StorageObjectCollection listStorageTemplates;
    protected StorageObjectCollection bjIndexes;
    private SnapshotOracle snapshot = null;
    private String oidIndexName = "";
    private SegmentOracle oidIndexSegment;
    public static final String NAME_SUBSTITUTION_TYPE = "Table";
    final int numbChildren = 11;

    public TableProxyOracle(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    public TableProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.initStorageObjects((StorageDesignOracle)storageDesign);
    }

    private void initStorageObjects(StorageDesignOracle storageDesignOracle) {
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(storageDesignOracle.getFKProxySet());
        storageDesignOracle.getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(storageDesignOracle.getPKProxySet());
        storageDesignOracle.getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(storageDesignOracle.getUniqueSet());
        storageDesignOracle.getUniqueSet().addSetListener(this);
        this.triggers = new StorageObjectCollection(storageDesignOracle.getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxyOracle.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        this.addTriggersFromDesign(storageDesignOracle.getTriggerSet());
        this.bjIndexes = new StorageObjectCollection(storageDesignOracle.getBitmapJoinIndexSet());
        this.bjIndexes.setParent(this);
        this.bjIndexes.setName(Messages.getString("TableProxyOracle.BitmapJoinIndexes"));
        this.bjIndexes.setClassForParent(TableProxyOracle.class);
        this.bjIndexes.setSetMethod("setTable");
        this.bjIndexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        storageDesignOracle.getBitmapJoinIndexSet().addSetListener(this);
        this.addBJIFromDesign(storageDesignOracle.getBitmapJoinIndexSet());
        this.partitions = new StorageObjectCollection(storageDesignOracle.getPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("TableProxyOracle.Partitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(PartitionListOracle.class);
        this.partitions.setSetMethod("setPartitionList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getPartitionSet().addSetListener(this);
        storageDesignOracle.getHashPartitionSet().addSetListener(this);
        storageDesignOracle.getListPartitionSet().addSetListener(this);
        this.listStorageTemplates = new StorageObjectCollection(storageDesignOracle.getListStorageTemplatePartitionSet());
        this.listStorageTemplates.setParent(this);
        this.listStorageTemplates.setName(Messages.getString("TableProxyOracle.SubpartitionTemplates"));
        this.listStorageTemplates.setForbiddenCreateElement(true);
        this.listStorageTemplates.setClassForParent(TableProxyOracle.class);
        this.listStorageTemplates.setSetMethod("setPartOfStorageTable");
        this.listStorageTemplates.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getListStorageTemplatePartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection(storageDesignOracle.getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("TableProxyOracle.LobStorages"));
        this.lobs.setClassForParent(TableProxyOracle.class);
        this.lobs.setSetMethod("setTable");
        storageDesignOracle.getLobStorageSet().addSetListener(this);
        this.tableCheckConstraints = new StorageObjectCollection();
        this.tableCheckConstraints.setParent(this);
        this.tableCheckConstraints.setName(Messages.getString("TableProxyOracle.TableCheckConstraints"));
        this.tableCheckConstraints.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON", 16));
        this.addTableCheckConstraintFromDesign(storageDesignOracle.getTableCheckConstraintSet());
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.tableSpace = tableSpaceOracle;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public void setTemporary(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.temporary = string;
            this.fireDataFieldChange();
        }
    }

    public String getTemporary() {
        return this.temporary;
    }

    public void setTempPreserveRows(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.tempPreserveRows = string;
            this.fireDataFieldChange();
        }
    }

    public String getTempPreserveRows() {
        return this.tempPreserveRows;
    }

    public static String[] getOrganizationChoices() {
        return ORGANIZATION;
    }

    protected boolean checkOrganization(String string) {
        if (organizationSet == null) {
            organizationSet = new HashSet();
            organizationSet.addAll(Arrays.asList(TableProxyOracle.getOrganizationChoices()));
        }
        return organizationSet.contains(string);
    }

    public void setOrganization(String string) {
        if (this.checkOrganization(string)) {
            this.organization = string;
            this.fireDataFieldChange();
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setCluster(ClusterOracle clusterOracle) {
        this.cluster = clusterOracle;
        this.fireDataFieldChange();
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public InlineList getClusterColumnsSet() {
        if (this.clusterColumnsSet == null) {
            this.clusterColumnsSet = new InlineList();
        }
        return this.clusterColumnsSet;
    }

    private void addColumn(String string) {
        if (!this.getClusterColumnsSet().contains(string)) {
            this.getClusterColumnsSet().add(string);
        }
    }

    private boolean isTableColumn(String string) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (!string.equalsIgnoreCase(columnProxyArray[i].getObjectID())) continue;
            return true;
        }
        return false;
    }

    protected void recreateColumnsSet(String string) {
        this.getClusterColumnsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getClusterColumnsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setClusterColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(string);
        } else if (this.isTableColumn(string)) {
            this.addColumn(string);
        }
        this.clusterColumns = this.getClusterColumnsSet().toString();
        this.fireDataFieldChange();
    }

    public String getClusterColumns() {
        return this.clusterColumns;
    }

    public String getAllClusterColumns() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.clusterColumns, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            ColumnProxy columnProxy = this.getColumnProxy(string);
            if (columnProxy == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnProxy.getName());
        }
        return stringBuffer.toString();
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setDataSegmentCompression(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.dataSegmentCompression = string;
            this.fireDataFieldChange();
        }
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public static String[] getStoreAsValues() {
        return STORE_AS_CHOICES;
    }

    protected boolean checkStoreAs(String string) {
        if (storeAsSet == null) {
            storeAsSet = new HashSet();
            storeAsSet.addAll(Arrays.asList(TableProxyOracle.getStoreAsValues()));
        }
        return storeAsSet.contains(string);
    }

    public String getStoreAs() {
        return this.storeAs;
    }

    public void setStoreAs(String string) {
        if (this.checkStoreAs(string)) {
            this.storeAs = string;
            this.fireDataFieldChange();
        }
    }

    public String getXmlSchemaElement() {
        return this.xmlSchemaElement;
    }

    public void setXmlSchemaElement(String string) {
        this.xmlSchemaElement = string;
        this.fireDataFieldChange();
    }

    public String getXmlSchemaUrl() {
        return this.xmlSchemaUrl;
    }

    public void setXmlSchemaUrl(String string) {
        this.xmlSchemaUrl = string;
        this.fireDataFieldChange();
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String string) {
        this.lobSegmentName = string;
    }

    public void setXmlTypeTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.xmlTypeTableSpace = tableSpaceOracle;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getXmlTypeTableSpace() {
        return this.xmlTypeTableSpace;
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setStorageInRow(String string) {
        if (this.checkStorageInRow(string)) {
            this.storageInRow = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getStorageInRowValues() {
        return STORAGE_IN_ROW_CHOICES;
    }

    private boolean checkStorageInRow(String string) {
        return this.checkParttitionedRowMovement(string);
    }

    public void setXmlTypeLogging(String string) {
        if (!this.xmlTypeLogging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.xmlTypeLogging = string;
            this.fireDataFieldChange();
        }
    }

    public String getXmlTypeLogging() {
        return this.xmlTypeLogging;
    }

    public String getXmlTypeCache() {
        return this.xmlTypeCache;
    }

    public void setXmlTypeCache(String string) {
        if (this.checkXmlTypeCache(string)) {
            this.xmlTypeCache = string;
            this.fireDataFieldChange();
        }
    }

    public static String[] getXmlTypeCacheValues() {
        return XMLTYPE_CACHE_CHOICES;
    }

    protected boolean checkXmlTypeCache(String string) {
        if (xmlTypeCacheSet == null) {
            xmlTypeCacheSet = new HashSet();
            xmlTypeCacheSet.addAll(Arrays.asList(TableProxyOracle.getXmlTypeCacheValues()));
        }
        return xmlTypeCacheSet.contains(string);
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int n) {
        this.chunk = n;
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    private boolean checkOldVersion(String string) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(TableProxyOracle.getOldVersionChoices()));
        }
        return oldVersionSet.contains(string);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String string) {
        if (this.checkOldVersion(string)) {
            this.oldVersions = string;
            this.fireDataFieldChange();
        }
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int n) {
        this.pctVersion = n;
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int n) {
        this.freepools = n;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setCache(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.cache = string;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setMonitoring(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.monitoring = string;
            this.fireDataFieldChange();
        }
    }

    public String getMonitoring() {
        return this.monitoring;
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String string) {
        if (!"".equalsIgnoreCase(string)) {
            try {
                Integer.parseInt(string);
                this.degree = string;
            }
            catch (NumberFormatException numberFormatException) {
                this.degree = "";
            }
        } else {
            this.degree = "";
        }
        this.fireDataFieldChange();
    }

    public void setRowDependency(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.rowDependency = string;
            this.fireDataFieldChange();
        }
    }

    public String getRowDependency() {
        return this.rowDependency;
    }

    public abstract void setPartitioned(String var1);

    public abstract String getPartitioned();

    public void disableListStorageTemplates() {
        this.listStorageTemplates.setForbiddenCreateElement(true);
        this.listStorageTemplates.removeAll();
    }

    public void enableListStorageTemplates() {
        this.listStorageTemplates.setForbiddenCreateElement(false);
    }

    public abstract void setPartitionList(PartitionListOracle var1);

    public abstract PartitionListOracle getPartitionList();

    public static String[] getParttitionedRowMovementChoices() {
        return PARTITIONED_ROW_MOVEMENT;
    }

    protected boolean checkParttitionedRowMovement(String string) {
        if (partitionedRowMovementSet == null) {
            partitionedRowMovementSet = new HashSet();
            partitionedRowMovementSet.addAll(Arrays.asList(TableProxyOracle.getParttitionedRowMovementChoices()));
        }
        return partitionedRowMovementSet.contains(string);
    }

    public void setParttitionedRowMovement(String string) {
        if (this.checkParttitionedRowMovement(string)) {
            this.partitionedRowMovement = string;
            this.fireDataFieldChange();
        }
    }

    public String getParttitionedRowMovement() {
        return this.partitionedRowMovement;
    }

    public void setIotCompress(int n) {
        this.iotCompress = n;
        this.fireDataFieldChange();
    }

    public int getIotCompress() {
        return this.iotCompress;
    }

    public void setIotPctThreshold(int n) {
        if (n >= 0 && n <= 50) {
            this.iotPctThreshold = n;
            this.fireDataFieldChange();
        }
    }

    public int getIotPctThreshold() {
        return this.iotPctThreshold;
    }

    public void setIotIncluding(ColumnProxy columnProxy) {
        this.iotIncluding = columnProxy;
        this.fireDataFieldChange();
    }

    public ColumnProxy getIotIncluding() {
        return this.iotIncluding;
    }

    public void setIotOverflowSegment(SegmentOracle segmentOracle) {
        this.iotOverflowSegment = segmentOracle;
        this.fireDataFieldChange();
    }

    public SegmentOracle getIotOverflowSegment() {
        return this.iotOverflowSegment;
    }

    public static List getOrganizationValues() {
        return organizationList;
    }

    public static List getPartitionedRowMovementsValues() {
        return partRowMovementList;
    }

    @Override
    public String getLongName() {
        UserOracle userOracle = this.getUser();
        if (userOracle != null) {
            return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject schemaObject = table.getSchemaObject();
        if (schemaObject != null) {
            userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getOwnerName() {
        UserOracle userOracle = this.getUser();
        if (userOracle != null) {
            return userOracle.getLongName();
        }
        Table table = (Table)this.getObject();
        SchemaObject schemaObject = table.getSchemaObject();
        if (schemaObject != null) {
            userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                return userOracle.getLongName();
            }
            if (!this.getStorageDesign().isOpen()) {
                return schemaObject.getLongName();
            }
        }
        return " ";
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 11;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == 10) {
            return this.partitions;
        }
        if (n == 9) {
            return this.listStorageTemplates;
        }
        if (n == 8) {
            return this.lobs;
        }
        if (n == 7) {
            return this.fkeys;
        }
        if (n == 6) {
            return this.ukeys;
        }
        if (n == 5) {
            return this.pkeys;
        }
        if (n == 4) {
            return this.triggers;
        }
        if (n == 3) {
            return this.bjIndexes;
        }
        if (n == 2) {
            return this.tableCheckConstraints;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitions) {
            return 10;
        }
        if (modelObject == this.listStorageTemplates) {
            return 9;
        }
        if (modelObject == this.lobs) {
            return 8;
        }
        if (modelObject == this.fkeys) {
            return 7;
        }
        if (modelObject == this.ukeys) {
            return 6;
        }
        if (modelObject == this.pkeys) {
            return 5;
        }
        if (modelObject == this.triggers) {
            return 4;
        }
        if (modelObject == this.bjIndexes) {
            return 3;
        }
        if (modelObject == this.tableCheckConstraints) {
            return 2;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitions) {
            return 10;
        }
        if (object == this.listStorageTemplates) {
            return 9;
        }
        if (object == this.lobs) {
            return 8;
        }
        if (object == this.fkeys) {
            return 7;
        }
        if (object == this.ukeys) {
            return 6;
        }
        if (object == this.pkeys) {
            return 5;
        }
        if (object == this.triggers) {
            return 4;
        }
        if (object == this.bjIndexes) {
            return 3;
        }
        if (object == this.tableCheckConstraints) {
            return 2;
        }
        return super.getIndexForChild(object);
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                Index index = (Index)indexProxy.getObject();
                if (this.getObject() == index.getContainerWithKeyObject()) {
                    if (index.isFK() && !this.fkeys.contains(indexProxy)) {
                        indexProxy.setParent(this.fkeys);
                        this.fkeys.add(indexProxy);
                    } else if (index.isPK() && !this.pkeys.contains(indexProxy)) {
                        indexProxy.setParent(this.pkeys);
                        this.pkeys.add(indexProxy);
                    } else if (index.isUnique() && !this.ukeys.contains(indexProxy)) {
                        indexProxy.setParent(this.ukeys);
                        this.ukeys.add(indexProxy);
                    } else if (!this.indexes.contains(indexProxy)) {
                        indexProxy.setParent(this.indexes);
                        this.indexes.add(modelObjectSetEvent.getAffected());
                    }
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof IndexProxy) {
            Index index;
            IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
            if (this.indexes.contains(indexProxy)) {
                this.indexes.remove(modelObjectSetEvent.getAffected());
            }
            if (this.fkeys.contains(indexProxy)) {
                this.fkeys.remove(modelObjectSetEvent.getAffected());
            }
            if ((index = (Index)indexProxy.getObject()).isPK()) {
                this.pkeys.remove(modelObjectSetEvent.getAffected());
            }
            if (index.isUnique()) {
                this.ukeys.remove(modelObjectSetEvent.getAffected());
            }
        }
    }

    public void addIndProxiesFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            Index index = (Index)indexProxy.getObject();
            if (this.getObject() != index.getContainerWithKeyObject()) continue;
            if (index.isFK()) {
                indexProxy.setParent(this.fkeys);
                this.fkeys.add(indexProxy);
                continue;
            }
            if (index.isPK()) {
                indexProxy.setParent(this.pkeys);
                this.pkeys.add(indexProxy);
                continue;
            }
            if (!index.isUnique()) continue;
            indexProxy.setParent(this.ukeys);
            this.ukeys.add(indexProxy);
        }
    }

    protected void addBJIFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            BitmapJoinIndexOracle bitmapJoinIndexOracle = (BitmapJoinIndexOracle)iterator.next();
            if (bitmapJoinIndexOracle.getTable() == this) {
                bitmapJoinIndexOracle.addObjectListener(this);
                bitmapJoinIndexOracle.setParent(this.bjIndexes);
                this.bjIndexes.add(bitmapJoinIndexOracle);
                continue;
            }
            this.bjIndexes.remove(bitmapJoinIndexOracle);
        }
    }

    protected abstract void addTableCheckConstraintFromDesign(TableCheckConstraintSetOracle var1);

    protected void addPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            if (partitionOracle.getPartitionList() == this.partitionList && this.partitionList != null) {
                partitionOracle.addObjectListener(this);
                partitionOracle.setParent(this.partitions);
                this.partitions.add(partitionOracle);
                continue;
            }
            this.partitions.remove(partitionOracle);
        }
    }

    public void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerOracle triggerOracle = (TriggerOracle)iterator.next();
            if (triggerOracle.getTable() == this) {
                triggerOracle.setParent(this.triggers);
                this.triggers.add(triggerOracle);
                continue;
            }
            this.triggers.remove(triggerOracle);
        }
    }

    public void clear() {
        this.getClusterColumnsSet().clear();
        this.clusterColumns = "";
    }

    public StorageObjectCollection getPrimaryKeys() {
        return this.pkeys;
    }

    public StorageObjectCollection getUniqueKeys() {
        return this.ukeys;
    }

    public StorageObjectCollection getLobStorages() {
        return this.lobs;
    }

    public StorageObjectCollection getPartitions() {
        return this.partitions;
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshotOracle) {
        this.snapshot = snapshotOracle;
        this.fireDataFieldChange();
    }

    public SegmentOracle getOidIndexSegment() {
        return this.oidIndexSegment;
    }

    public void setOidIndexSegment(SegmentOracle segmentOracle) {
        this.oidIndexSegment = segmentOracle;
        this.fireDataFieldChange();
    }

    public String getOidType() {
        Table table = (Table)this.getObject();
        if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
            return Messages.getString("TableProxyOracle.BasedOnPK");
        }
        return Messages.getString("TableProxyOracle.SystemGenerated");
    }

    public String getOidIndexName() {
        return this.oidIndexName;
    }

    public void setOidIndexName(String string) {
        this.oidIndexName = string;
        this.fireDataFieldChange();
    }

    public String getBasedOnStructuredType() {
        if (((Table)this.getObject()).getBasedOnStructuredType() == null) {
            return "";
        }
        return ((Table)this.getObject()).getBasedOnStructuredType().getName();
    }

    public TableCheckConstraintOracle getTableConstraint(TableLevelConstraint tableLevelConstraint) {
        Iterator iterator = this.tableCheckConstraints.iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            if (tableCheckConstraintOracle.getTableConstraint() != tableLevelConstraint) continue;
            return tableCheckConstraintOracle;
        }
        return null;
    }

    @Override
    public void setUserSchema(String string) {
        if (string != null) {
            UserOracle userOracle = (UserOracle)((StorageDesignOracle)this.getStorageDesign()).getUserSet().getByName(string);
            if (userOracle == null) {
                userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().createUser();
                userOracle.setName(string);
            }
            if (userOracle != null) {
                this.setUser(userOracle);
            }
        }
    }

    public StorageObjectCollection getFKeys() {
        return this.fkeys;
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    @Override
    public boolean isUnload() {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Datatype datatype = columnProxy.getDataType();
            if (datatype instanceof StructuredType || datatype instanceof CollectionType) {
                return false;
            }
            String string = datatype.getName();
            if (string.equalsIgnoreCase("LONG") || string.equalsIgnoreCase("LONG RAW")) {
                return false;
            }
            if (!(this instanceof TableProxyOraclev9i) || !string.equalsIgnoreCase("BLOB") && !string.equalsIgnoreCase(CLOB) && !string.equalsIgnoreCase("NCLOB") && !string.equalsIgnoreCase("XMLTYPE")) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnloadPerPartition() {
        return this.getPartitioned().equals("YES");
    }

    @Override
    public void addObject(StorageObject storageObject) {
        StorageObject storageObject2;
        if (storageObject instanceof TableCheckConstraintOracle && ((TableCheckConstraintOracle)(storageObject2 = (TableCheckConstraintOracle)storageObject)).getTable() != null && ((TableCheckConstraintOracle)storageObject2).getTable() == this) {
            storageObject2.setParent(this.tableCheckConstraints);
            this.removeExisting((TableCheckConstraintOracle)storageObject2);
            this.tableCheckConstraints.add(storageObject2);
        }
        if (storageObject instanceof TriggerOracle && ((TriggerOracle)(storageObject2 = (TriggerOracle)storageObject)).getTable() != null && ((TriggerOracle)storageObject2).getTable() == this) {
            storageObject2.setParent(this.triggers);
            this.triggers.add(storageObject2);
        }
        super.addObject(storageObject);
    }

    @Override
    public void removeObject(StorageObject storageObject) {
        StorageObject storageObject2;
        if (storageObject instanceof TableCheckConstraintOracle) {
            storageObject2 = (TableCheckConstraintOracle)storageObject;
            this.tableCheckConstraints.remove(storageObject2);
        }
        if (storageObject instanceof TriggerOracle) {
            storageObject2 = (TriggerOracle)storageObject;
            this.triggers.justRemove(storageObject2);
        }
        super.removeObject(storageObject);
    }

    private void removeExisting(TableCheckConstraintOracle tableCheckConstraintOracle) {
        for (int i = this.tableCheckConstraints.size() - 1; i >= 0; --i) {
            TableCheckConstraintOracle tableCheckConstraintOracle2 = (TableCheckConstraintOracle)this.tableCheckConstraints.getElement(i);
            if (tableCheckConstraintOracle2 == tableCheckConstraintOracle || !tableCheckConstraintOracle2.getObjectID().equals(tableCheckConstraintOracle.getObjectID())) continue;
            String string = tableCheckConstraintOracle2.getName();
            tableCheckConstraintOracle2.remove();
            this.tableCheckConstraints.remove(tableCheckConstraintOracle2);
            if (!this.getStorageDesign().isLoading() || !this.getDesign().isOldRepositoryType()) continue;
            tableCheckConstraintOracle.setObjectID(tableCheckConstraintOracle.getObjectID());
            if (tableCheckConstraintOracle.isNameChanged()) continue;
            tableCheckConstraintOracle.setName(string);
        }
    }

    public static boolean containsTCCWithID(StorageObjectCollection storageObjectCollection, String string) {
        if (string != null && !"".equals(string)) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
                if (!string.equals(tableCheckConstraintOracle.getObjectID())) continue;
                return true;
            }
        }
        return false;
    }

    public StorageObjectCollection getListStorageTemplates() {
        return this.listStorageTemplates;
    }

    public StorageObjectCollection getTableCheckConstraints() {
        return this.tableCheckConstraints;
    }

    public StorageObjectCollection getBjIndexes() {
        return this.bjIndexes;
    }

    @Override
    public List getSAC_StorageObjects() {
        ArrayList arrayList = new ArrayList();
        this.getTableCheckConstraints().addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public void remove() {
        Object[] objectArray = this.triggers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TriggerOracle triggerOracle = (TriggerOracle)objectArray[i];
            triggerOracle.remove();
            triggerOracle.setTable(null);
            this.triggers.remove(triggerOracle);
        }
        Object[] objectArray2 = this.bjIndexes.toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            BitmapJoinIndexOracle bitmapJoinIndexOracle = (BitmapJoinIndexOracle)objectArray2[i];
            bitmapJoinIndexOracle.remove();
            bitmapJoinIndexOracle.setTable(null);
            this.bjIndexes.remove(bitmapJoinIndexOracle);
        }
        Object[] objectArray3 = this.lobs.toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectArray3[i];
            lobStorageOracle.remove();
            lobStorageOracle.setTable(null);
            this.lobs.remove(lobStorageOracle);
        }
        Object[] objectArray4 = this.partitions.toArray();
        for (int i = 0; i < objectArray4.length; ++i) {
            StorageObject storageObject = (StorageObject)objectArray4[i];
            storageObject.remove();
            if (storageObject instanceof PartitionOracle) {
                ((PartitionOracle)storageObject).setPartitionList(null);
            } else if (storageObject instanceof ListPartitionOracle) {
                ((ListPartitionOracle)storageObject).setPartitionList(null);
            } else if (storageObject instanceof HashPartitionOracle) {
                ((HashPartitionOracle)storageObject).setPartitionList(null);
            }
            this.partitions.remove(storageObject);
        }
        Object[] objectArray5 = this.listStorageTemplates.toArray();
        for (int i = 0; i < objectArray5.length; ++i) {
            StorageObject storageObject = (StorageObject)objectArray5[i];
            storageObject.remove();
            if (storageObject instanceof ListStorageTemplatePartitionOracle) {
                ((ListStorageTemplatePartitionOracle)storageObject).setPartOfStorageTable(null);
            } else if (storageObject instanceof HashPartitionOracle) {
                ((HashPartitionOracle)storageObject).setPartOfStorageTable(null);
            } else if (storageObject instanceof PartitionOraclev11g) {
                ((PartitionOraclev11g)storageObject).setPartOfStorageTable(null);
            }
            this.listStorageTemplates.remove(storageObject);
        }
        super.remove();
    }

    @Override
    public void clearNoneMergableStructure() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listStorageTemplates.removeAll();
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            if (this.bjIndexes != null) {
                this.bjIndexes.addAllElementsTo(arrayList);
            }
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public PartitionListOracle createPartitionList() {
        PartitionListOracle partitionListOracle = (PartitionListOracle)((StorageDesignOracle)this.getStorageDesign()).getPartitionListSet().createElement(null);
        partitionListOracle.setTable(this);
        return partitionListOracle;
    }

    public StorageObject createPartitionOracle() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public StorageObject createListStorageTemplate() {
        if (this.listStorageTemplates.getStorageObjectSet() != null) {
            return (StorageObject)this.listStorageTemplates.createElement(null);
        }
        return null;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public BitmapJoinIndexOracle createBjIndex() {
        if (this.bjIndexes.getStorageObjectSet() != null) {
            return (BitmapJoinIndexOracle)this.bjIndexes.createElement(null);
        }
        return null;
    }

    public void clearPartitionList() {
        PartitionListOracle partitionListOracle = this.partitionList;
        if (partitionListOracle != null) {
            this.setPartitionList(null);
            partitionListOracle.remove();
        }
    }

    @Override
    public Icon getIcon() {
        String string = this.getTemporary().equalsIgnoreCase("YES") ? "TEMPORARY_TABLE_ICON" : (this.getPartitioned().equalsIgnoreCase("YES") ? "PARTITIONED_TABLE_ICON" : "TABLE_ICON");
        return GUIConfiguration.getInstance().getIcon(string, 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

