/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.StructuredTypePropertyDialogOraclev9i;

public class StructuredTypeProxyOracle
extends StructuredTypeProxy {
    public static final String CURRENT_USER = "CURRENT_USER";
    public static final String DEFINER = "DEFINER";
    public static final String MAP = "MAP";
    public static final String ORDER = "ORDER";
    private UserOracle owner;
    private String invokerRights = "";
    private MethodProxyOracle mapOrderFunction = null;
    private String mapOrderType = "MAP";
    public static final String[] INVOKER_RIGHTS = new String[]{"", "CURRENT_USER", "DEFINER"};
    private static Set invokerRightSet = null;
    public static final String[] MAP_ORDER_RIGHTS = new String[]{"MAP", "ORDER"};
    private static Set mapOrderSet = null;

    public StructuredTypeProxyOracle(StructuredType structuredType, StorageDesign storageDesign) {
        super(structuredType, storageDesign);
    }

    public StructuredTypeProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getInvokerRights() {
        return this.invokerRights;
    }

    public void setInvokerRights(String string) {
        if (this.checkInvokerRight(string)) {
            this.invokerRights = string;
            this.fireDataFieldChange();
        }
    }

    public MethodProxyOracle getMapOrderFunction() {
        return this.mapOrderFunction;
    }

    public void setMapOrderFunction(MethodProxyOracle methodProxyOracle) {
        if (this.mapOrderFunction != methodProxyOracle && ((StructuredType)this.getObject()).getParentType() == null) {
            this.mapOrderFunction = methodProxyOracle;
            this.fireDataFieldChange();
        }
    }

    public String getMapOrderType() {
        return this.mapOrderType;
    }

    public void setMapOrderType(String string) {
        if (this.checkMapOrder(string)) {
            this.mapOrderType = string;
            this.fireDataFieldChange();
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle userOracle) {
        if (this.owner != userOracle) {
            this.owner = userOracle;
            if (userOracle != null) {
                boolean bl = userOracle.getName().equalsIgnoreCase("MDSYS") || userOracle.getName().equalsIgnoreCase("SYS") || userOracle.getName().equalsIgnoreCase("ORDSYS");
                this.getStructuredType().setPredefined(bl);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public static String[] getInvokerRightChoices() {
        return INVOKER_RIGHTS;
    }

    protected boolean checkInvokerRight(String string) {
        if (invokerRightSet == null) {
            invokerRightSet = new HashSet();
            invokerRightSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getInvokerRightChoices()));
        }
        return invokerRightSet.contains(string);
    }

    public static String[] getMapOrderChoices() {
        return MAP_ORDER_RIGHTS;
    }

    protected boolean checkMapOrder(String string) {
        if (mapOrderSet == null) {
            mapOrderSet = new HashSet();
            mapOrderSet.addAll(Arrays.asList(StructuredTypeProxyOracle.getMapOrderChoices()));
        }
        return mapOrderSet.contains(string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertyDialogOraclev9i structuredTypePropertyDialogOraclev9i = new StructuredTypePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            structuredTypePropertyDialogOraclev9i.show();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrUser() {
        return this.getOwner();
    }
}

