/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBFunctionOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBNoneTransferableFKOracle;
import oracle.dbtools.crest.exports.ddl.oracle.SSBPackageOracle;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ContextOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ContextSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectorySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexPropertiesSet;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ReservedWordsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;

public abstract class StorageDesignOracle
extends StorageDesign {
    private PropertyHolder propertyholder = null;
    private ReservedWordsOracle reserved = new ReservedWordsOracle();
    private LocalIndexPropertiesSet lipSet;
    private PackageSetOracle packagesSet = null;
    private FunctionSetOracle functionsSet = null;
    protected static final String PACKAGES = Messages.getString("StorageDesignOracle.Packages");
    protected static final String FUNCTIONS = Messages.getString("StorageDesignOracle.Functions");
    static String AQ_ADMINISTRATOR_ROLE = "AQ_ADMINISTRATOR_ROLE";
    static String AQ_USER_ROLE = "AQ_USER_ROLE";
    static String AUTHENTICATEDUSER = "AUTHENTICATEDUSER";
    static String CONNECT = "CONNECT";
    static String CTXAPP = "CTXAPP";
    static String DBA = "DBA";
    static String DELETE_CATALOG_ROLE = "DELETE_CATALOG_ROLE";
    static String EJBCLIENT = "EJBCLIENT";
    static String EXECUTE_CATALOG_ROLE = "EXECUTE_CATALOG_ROLE";
    static String EXP_FULL_DATABASE = "EXP_FULL_DATABASE";
    static String GATHER_SYSTEM_STATISTICS = "GATHER_SYSTEM_STATISTICS";
    static String GLOBAL_AQ_USER_ROLE = "GLOBAL_AQ_USER_ROLE";
    static String HS_ADMIN_ROLE = "HS_ADMIN_ROLE";
    static String IMP_FULL_DATABASE = "IMP_FULL_DATABASE";
    static String JAVADEBUGPRIV = "JAVADEBUGPRIV";
    static String JAVAIDPRIV = "JAVAIDPRIV";
    static String JAVASYSPRIV = "JAVASYSPRIV";
    static String JAVAUSERPRIV = "JAVAUSERPRIV";
    static String JAVA_ADMIN = "JAVA_ADMIN";
    static String JAVA_DEPLOY = "JAVA_DEPLOY";
    static String LOGSTDBY_ADMINISTRATOR = "LOGSTDBY_ADMINISTRATOR";
    static String MGMT_USER = "MGMT_USER";
    static String OEM_ADVISOR = "OEM_ADVISOR";
    static String OEM_MONITOR = "OEM_MONITOR";
    static String OLAP_DBA = "OLAP_DBA";
    static String OLAP_USER = "OLAP_USER";
    static String OWBR_OWB = "OWBR_OWB";
    static String OWB_A_OWB = "OWB_A_OWB";
    static String OWB_D_OWB = "OWB_D_OWB";
    static String OWB_OWB = "OWB_OWB";
    static String OWB_O_OWB = "OWB_O_OWB";
    static String RECOVERY_CATALOG_OWNER = "RECOVERY_CATALOG_OWNER";
    static String RESOURCE = "RESOURCE";
    static String SCHEDULER_ADMIN = "SCHEDULER_ADMIN";
    static String SELECT_CATALOG_ROLE = "SELECT_CATALOG_ROLE";
    static String WM_ADMIN_ROLE = "WM_ADMIN_ROLE";
    static String XDBADMIN = "XDBADMIN";
    static String XDBWEBSERVICES = "XDBWEBSERVICES";
    private static String[] SEEDED_ROLES = new String[]{AQ_ADMINISTRATOR_ROLE, AQ_USER_ROLE, AUTHENTICATEDUSER, CONNECT, CTXAPP, DBA, DELETE_CATALOG_ROLE, EJBCLIENT, EXECUTE_CATALOG_ROLE, EXP_FULL_DATABASE, GATHER_SYSTEM_STATISTICS, GLOBAL_AQ_USER_ROLE, HS_ADMIN_ROLE, IMP_FULL_DATABASE, JAVADEBUGPRIV, JAVAIDPRIV, JAVASYSPRIV, JAVAUSERPRIV, JAVA_ADMIN, JAVA_DEPLOY, LOGSTDBY_ADMINISTRATOR, MGMT_USER, OEM_ADVISOR, OEM_MONITOR, OLAP_DBA, OLAP_USER, OWBR_OWB, OWB_A_OWB, OWB_D_OWB, OWB_OWB, OWB_O_OWB, RECOVERY_CATALOG_OWNER, RESOURCE, SCHEDULER_ADMIN, SELECT_CATALOG_ROLE, WM_ADMIN_ROLE, XDBADMIN, XDBWEBSERVICES};
    public Map substitutionMap = new TreeMap();

    public StorageDesignOracle(RelationalDesign relationalDesign, RDBMSSite rDBMSSite, Design design) {
        super(relationalDesign, rDBMSSite, design);
    }

    @Override
    public abstract String getName();

    @Override
    public PropertyHolder getPropertyHolder() {
        return this.propertyholder;
    }

    public abstract DataFileSetOracle getDataFileSet();

    public abstract RedoLogGroupSetOracle getRedoLogGroupSet();

    public abstract DataBaseSetOracle getDataBaseSet();

    public abstract UserSetOracle getUserSet();

    public abstract QuotaItemSetOracle getQuotaItemSet();

    public abstract TableSpaceSetOracle getTableSpaceSet();

    public abstract ClusterSetOracle getClusterSet();

    public abstract SegmentSetOracle getSegmentSet();

    public abstract PartitionListSetOracle getPartitionListSet();

    public abstract PartitionSetOracle getPartitionSet();

    public abstract LobStorageSetOracle getLobStorageSet();

    public abstract HashPartitionSetOracle getHashPartitionSet();

    public abstract HashPartitionLobItemSetOracle getHashPartitionLobItemSet();

    public abstract RoleSetOracle getRoleSet();

    public abstract PermissionsSetOracle getPermissionsSet();

    public abstract SequenceSetOracle getSequenceSet();

    public abstract ClusterIndexSetOracle getClusterIndexSet();

    public abstract IndexGlobalPartitionsListSetOracle getIndexGlobalPartitionsListSet();

    public abstract IndexGlobalPartitionSetOracle getIndexGlobalPartitionSet();

    public abstract ListPartitionSetOracle getListPartitionSet();

    public abstract ListStorageTemplatePartitionSetOracle getListStorageTemplatePartitionSet();

    public abstract ClusterColumnSetOracle getClusterColumnSet();

    public abstract SynonymSetOracle getSynonymSet();

    public abstract PKProxySetOracle getPKProxySet();

    public abstract FKProxySetOracle getFKProxySet();

    public abstract TableCheckConstraintSetOracle getTableCheckConstraintSet();

    public abstract TriggerSetOracle getTriggerSet();

    public abstract StoredProcedureSetOracle getStoredProcedureSet();

    public abstract DimensionSetOracle getDimensionSet();

    public abstract LevelSetOracle getLevelSet();

    public abstract HierarchySetOracle getHierarchySet();

    public abstract DimensionAttributeSetOracle getDimensionAttributeSet();

    public abstract SnapshotSetOracle getSnapshotSet();

    public abstract BitmapJoinIndexSetOracle getBitmapJoinIndexSet();

    public abstract ContextSetOracle getContextSet();

    public abstract DirectorySetOracle getDirectorySet();

    public abstract TemporaryTablespaceSetOracle getTemporaryTablespaceSet();

    public abstract RollbackSegmentSetOracle getRollbackSegmentSet();

    public abstract UndoTablespaceSetOracle getUndoTablespaceSet();

    public abstract ExternalTableSetOracle getExternalTableSet();

    public abstract void updateGeneralRule();

    public UniqueSetOracle getUniqueSet() {
        return null;
    }

    public NotNullConstraintSetOracle getNotNullConstraintSet() {
        return null;
    }

    @Override
    public void doAfterLoad() {
        super.doAfterLoad();
        Iterator iterator = this.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
            int n = tableProxyOracle.getPartitions().size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(tableProxyOracle.getPartitions().getElement(0));
                tableProxyOracle.getPartitions().justRemove(tableProxyOracle.getPartitions().getElement(0));
            }
            Collections.sort(arrayList, new PartitionComparator());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) instanceof PartitionOracle) {
                    PartitionOracle partitionOracle = (PartitionOracle)arrayList.get(i);
                    partitionOracle.addObjectListener(tableProxyOracle);
                    partitionOracle.setParent(tableProxyOracle.getPartitions());
                    tableProxyOracle.getPartitions().add(partitionOracle);
                    continue;
                }
                if (arrayList.get(i) instanceof HashPartitionOracle) {
                    HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)arrayList.get(i);
                    hashPartitionOracle.addObjectListener(tableProxyOracle);
                    hashPartitionOracle.setParent(tableProxyOracle.getPartitions());
                    tableProxyOracle.getPartitions().add(hashPartitionOracle);
                    continue;
                }
                if (!(arrayList.get(i) instanceof ListPartitionOracle)) continue;
                ListPartitionOracle listPartitionOracle = (ListPartitionOracle)arrayList.get(i);
                listPartitionOracle.addObjectListener(tableProxyOracle);
                listPartitionOracle.setParent(tableProxyOracle.getPartitions());
                tableProxyOracle.getPartitions().add(listPartitionOracle);
            }
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    @Override
    public void load() {
        super.load();
        Iterator iterator = this.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
            int n = tableProxyOracle.getPartitions().size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(tableProxyOracle.getPartitions().getElement(0));
                tableProxyOracle.getPartitions().justRemove(tableProxyOracle.getPartitions().getElement(0));
            }
            Collections.sort(arrayList, new PartitionComparator());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) instanceof PartitionOracle) {
                    PartitionOracle partitionOracle = (PartitionOracle)arrayList.get(i);
                    partitionOracle.addObjectListener(tableProxyOracle);
                    partitionOracle.setParent(tableProxyOracle.getPartitions());
                    tableProxyOracle.getPartitions().add(partitionOracle);
                    continue;
                }
                if (arrayList.get(i) instanceof HashPartitionOracle) {
                    HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)arrayList.get(i);
                    hashPartitionOracle.addObjectListener(tableProxyOracle);
                    hashPartitionOracle.setParent(tableProxyOracle.getPartitions());
                    tableProxyOracle.getPartitions().add(hashPartitionOracle);
                    continue;
                }
                if (!(arrayList.get(i) instanceof ListPartitionOracle)) continue;
                ListPartitionOracle listPartitionOracle = (ListPartitionOracle)arrayList.get(i);
                listPartitionOracle.addObjectListener(tableProxyOracle);
                listPartitionOracle.setParent(tableProxyOracle.getPartitions());
                tableProxyOracle.getPartitions().add(listPartitionOracle);
            }
        }
        this.setDirty(false);
        this.setAllStorableObjectsDirty(false);
    }

    @Override
    public List getStorableSetsList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @Override
    public Iterator ddlObjects() {
        ArrayList arrayList = new ArrayList();
        this.addDDLStorageObjects(arrayList, this.getPackageSet());
        this.addDDLStorageObjects(arrayList, this.getFunctionSet());
        return arrayList.iterator();
    }

    @Override
    protected final DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        this.appendAll(dDLGeneratorSpecific);
        this.appendDefault(dDLGeneratorSpecific);
        dDLGeneratorSpecific.setLabel("Oracle Generic");
        return dDLGeneratorSpecific;
    }

    protected void appendDefault(DDLGenerator dDLGenerator) {
        dDLGenerator.append(new SSBPackageOracle());
        dDLGenerator.append(new SSBFunctionOracle());
    }

    protected abstract void appendAll(DDLGenerator var1);

    @Override
    public List getAllSetsList() {
        ArrayList<StorageObjectSet> arrayList = new ArrayList<StorageObjectSet>();
        arrayList.add(this.getPackageSet());
        arrayList.add(this.getFunctionSet());
        return arrayList;
    }

    public String getFormattedNameList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getFormatedName(stringTokenizer.nextToken().trim()));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getFormatedName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = "";
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = bl ? this.getFormatedSubname(stringTokenizer.nextToken()) : string2 + "." + this.getFormatedSubname(stringTokenizer.nextToken());
            bl = false;
        }
        return string2;
    }

    public String getFormatedSubname(String string) {
        if (this.startsWithNumber(string) || StorageDesignOracle.hasForbiddenCharsOracle(string) || string.indexOf(95) == 0 || string.indexOf(36) == 0 || string.indexOf(35) == 0 || string.indexOf(64) > -1 || this.reserved.isReservedWord(string) || this.getDesign().getAppView().getSettings().isUseQuotedIdentifiers()) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public LocalIndexPropertiesSet getLocalIndexPropertiesSet() {
        if (this.lipSet == null) {
            this.lipSet = new LocalIndexPropertiesSet();
            this.lipSet.setDesign(this.getDesign());
            this.lipSet.setStorageDesign(this);
        }
        return this.lipSet;
    }

    @Override
    public Map getNameSubstituionTypes() {
        if (this.substitutionMap.isEmpty()) {
            this.substitutionMap.put("Table", new StorageDesign.ObjectType("Table"));
            this.substitutionMap.put("Tablespace", new StorageDesign.ObjectType("Tablespace"));
            this.substitutionMap.put("User", new StorageDesign.ObjectType("User"));
            this.substitutionMap.put("Index", new StorageDesign.ObjectType("Index"));
        }
        return this.substitutionMap;
    }

    public List getNNC_ColumnsWithExceptionsTableForDDL() {
        ArrayList<ColumnProxyOracle> arrayList = new ArrayList<ColumnProxyOracle>();
        Iterator iterator = this.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxy tableProxy = (TableProxy)iterator.next();
            if (!tableProxy.isMarkedGenerate()) continue;
            ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
            for (int i = 0; i < columnProxyArray.length; ++i) {
                String string;
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
                String string2 = string = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
                if (columnProxyOracle.getColumn().getNullsAllowed() || string == null || "".equals(string) || columnProxyOracle.getNncExceptionsTable() == null) continue;
                arrayList.add(columnProxyOracle);
            }
        }
        return arrayList;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        arrayList.add(this.getTableProxySet());
        arrayList.add(this.getIndexProxySet());
        arrayList.add(this.getFKProxySet());
        arrayList.add(this.getTableViewProxySet());
        arrayList.add(this.getTableSpaceSet());
        return arrayList;
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBNoneTransferableFKOracle(this));
        return dDLGeneratorSpecific;
    }

    @Override
    protected DDLGenerator createDDLAutoIncrementColumnGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new SSBAutoIncrementColumnOracle(this));
        return dDLGeneratorSpecific;
    }

    @Override
    public List getUniqueList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getUniqueSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getFKProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    @Override
    public List getPKProxyList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.getPKProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public boolean isSeededRole(String string) {
        if (string != null && !"".equals(string)) {
            for (int i = 0; i < SEEDED_ROLES.length; ++i) {
                if (!SEEDED_ROLES[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public UserOracle getDefaultUser() {
        UserOracle userOracle = null;
        String string = this.getDesign().getAppView().getSettings().getDefaultOracleUser();
        if (string != null && !"".equalsIgnoreCase(string) && (userOracle = (UserOracle)this.getUserSet().getByName(string)) == null) {
            userOracle = (UserOracle)this.getUserSet().createElement(null);
            userOracle.setName(string);
        }
        return userOracle;
    }

    public TableSpaceOracle getDefaultTableSpace() {
        TableSpaceOracle tableSpaceOracle = null;
        String string = this.getDesign().getAppView().getSettings().getDefaultOracleTablespace();
        if (string != null && !"".equalsIgnoreCase(string) && (tableSpaceOracle = (TableSpaceOracle)this.getTableSpaceSet().getByName(string)) == null) {
            tableSpaceOracle = this.getTableSpaceSet().createTableSpace(string);
            tableSpaceOracle.setName(string);
        }
        return tableSpaceOracle;
    }

    public PackageSetOracle getPackageSet() {
        if (this.packagesSet == null) {
            this.packagesSet = new PackageSetOracle();
            this.packagesSet.setDesign(this.getDesign());
            this.packagesSet.setStorageDesign(this);
        }
        return this.packagesSet;
    }

    public FunctionSetOracle getFunctionSet() {
        if (this.functionsSet == null) {
            this.functionsSet = new FunctionSetOracle();
            this.functionsSet.setDesign(this.getDesign());
            this.functionsSet.setStorageDesign(this);
        }
        return this.functionsSet;
    }

    public PackageOracle createPackageOracle() {
        return (PackageOracle)this.getPackageSet().createElement(null);
    }

    public FunctionOracle createFunctionOracle() {
        return (FunctionOracle)this.getFunctionSet().createElement(null);
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getPKProxySet().setDesign(this.getDesign());
        this.getUniqueSet().setDesign(this.getDesign());
        this.getFKProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> list = super.createDDLSelectionSetsList();
        list.add(this.getContextSet());
        list.add(this.getDirectorySet());
        list.add(this.getRoleSet());
        list.add(this.getRollbackSegmentSet());
        list.add(this.getTableSpaceSet());
        list.add(this.getTemporaryTablespaceSet());
        list.add(this.getUserSet());
        list.add(this.getClusterSet());
        list.add(this.getDimensionSet());
        list.add(this.getSequenceSet());
        list.add(this.getSnapshotSet());
        list.add(this.getPackageSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getFunctionSet());
        list.add(this.getSynonymSet());
        list.add(this.getStructuredTypeProxySet());
        this.addDDLSelectionTableSetsList(list);
        this.addDDLSelectionViewSetsList(list);
        return list;
    }

    protected void addDDLSelectionTableSetsList(List<ElementSet> list) {
        TableProxySet tableProxySet = this.getTableProxySet();
        Iterator iterator = tableProxySet.iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            list.add(tableProxyOracle.getPrimaryKeys());
            list.add(tableProxyOracle.getUniqueKeys());
            list.add(tableProxyOracle.getIndexes());
            list.add(tableProxyOracle.getFKeys());
            list.add(tableProxyOracle.getTriggers());
        }
        list.add(tableProxySet);
    }

    protected void addDDLSelectionViewSetsList(List<ElementSet> list) {
        TableViewProxySet tableViewProxySet = this.getTableViewProxySet();
        Iterator iterator = tableViewProxySet.iterator();
        while (iterator.hasNext()) {
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)iterator.next();
            list.add(tableViewProxyOracle.getTriggers());
        }
        list.add(tableViewProxySet);
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getIndexGlobalPartitionsListSet().sort();
        this.getIndexGlobalPartitionSet().sort();
        this.getSnapshotSet().sort();
        this.getDataFileSet().sort();
        this.getRedoLogGroupSet().sort();
        this.getDataBaseSet().sort();
        this.getUserSet().sort();
        this.getQuotaItemSet().sort();
        this.getTableSpaceSet().sort();
        this.getClusterSet().sort();
        this.getSegmentSet().sort();
        this.getPartitionListSet().sort();
        this.getPartitionSet().sort();
        this.getListPartitionSet().sort();
        this.getLobStorageSet().sort();
        this.getHashPartitionSet().sort();
        this.getHashPartitionLobItemSet().sort();
        this.getRoleSet().sort();
        this.getPermissionsSet().sort();
        this.getSequenceSet().sort();
        this.getClusterIndexSet().sort();
        this.getBitmapJoinIndexSet().sort();
        this.getClusterColumnSet().sort();
        this.getSynonymSet().sort();
        this.getTableCheckConstraintSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getLevelSet().sort();
        this.getHierarchySet().sort();
        this.getDimensionSet().sort();
        this.getDimensionAttributeSet().sort();
        this.getContextSet().sort();
        this.getDirectorySet().sort();
        this.getTemporaryTablespaceSet().sort();
        this.getRollbackSegmentSet().sort();
        this.getListStorageTemplatePartitionSet().sort();
        this.getLocalIndexPropertiesSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getUserSet();
    }

    public DataBaseOracle createDataBaseOracle() {
        return this.getDataBaseSet().createDataBase();
    }

    public TableSpaceOracle createTableSpaceOracle() {
        return this.getTableSpaceSet().createTableSpace();
    }

    public TemporaryTablespaceOracle createTemporaryTablespaceOracle() {
        return this.getTemporaryTablespaceSet().createTemporaryTablespace();
    }

    public UserOracle createUserOracle() {
        return this.getUserSet().createUser();
    }

    public ClusterOracle createClusterOracle() {
        return this.getClusterSet().createCluster();
    }

    public SegmentOracle createSegmentOracle() {
        return this.getSegmentSet().createSegment();
    }

    public SnapshotOracle createSnapshotOracle() {
        return this.getSnapshotSet().createSnapshot();
    }

    public RoleOracle createRoleOracle() {
        return this.getRoleSet().createRole();
    }

    public SequenceOracle createSequenceOracle() {
        return this.getSequenceSet().createSequence();
    }

    public SynonymOracle createSynonymOracle() {
        return this.getSynonymSet().createSynonym();
    }

    public DirectoryOracle createDirectoryOracle() {
        return this.getDirectorySet().createDirectory();
    }

    public TriggerOracle createTriggerOracle() {
        return this.getTriggerSet().createTrigger();
    }

    public StoredProcedureOracle createStoredProcedureOracle() {
        return this.getStoredProcedureSet().createStoredProcedure();
    }

    public DimensionOracle createDimensionOracle() {
        return this.getDimensionSet().createDimension();
    }

    public ContextOracle createContextOracle() {
        return this.getContextSet().createContext();
    }

    public UndoTablespaceOracle createUndoTablespaceOracle() {
        return this.getUndoTablespaceSet().createTablespace();
    }

    public ExternalTableOracle createExternalTableOracle() {
        return this.getExternalTableSet().createExternalTable();
    }

    @Override
    public List getMatchByNameSets() {
        ArrayList<StorageObjectSet> arrayList = new ArrayList<StorageObjectSet>();
        arrayList.add(this.getTriggerSet());
        arrayList.add(this.getBitmapJoinIndexSet());
        arrayList.add(this.getClusterIndexSet());
        return arrayList;
    }

    @Override
    public String[] getFKDeleteRules() {
        return FKIndexAssociation.DELETE_RULES_ORACLE;
    }

    @Override
    public String[] getFKDeleteRulesMandatory() {
        return FKIndexAssociation.DELETE_RULES_WITHOUT_NULL_ORACLE;
    }

    @Override
    public String[] getFKDeleteRulesNonTransferable() {
        return FKIndexAssociation.DELETE_RULES_NOACTION_CASCADE;
    }

    @Override
    public String getValidFKRule(String string) {
        if ("RESTRICT".equals(string)) {
            return "NO ACTION";
        }
        if ("SET DEFAULT".equals(string)) {
            return "NO ACTION";
        }
        return string;
    }

    static class PartitionComparator
    implements Comparator {
        PartitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof PartitionOracle && object2 instanceof PartitionOracle) {
                if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                    return 1;
                }
                if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

