/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public abstract class SnapshotOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    private DesignObject object = null;
    private UserOracle user = null;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection lobs;
    private PartitionListOracle partitionList = null;
    private String partType = "";
    private String subpartType = "";
    private SegmentOracle segment;
    private LobStorageOracle lobStorage;
    private ClusterOracle cluster;
    private String partitioned = "NO";
    private String paralelClause = "NO";
    private int degree = 0;
    private String build = "IMMEDIATE";
    private String reducedPrecision = "YES";
    private TableProxyOracle onPrebuildTable;
    private String useIndex = "NONE";
    private SegmentOracle indexSegment;
    private String forUpdate = "NO";
    private String queryRewrite = "DISABLE";
    private String refresh = "NONE";
    private String refreshType = "FAST";
    private String action = "";
    private String startDate = "";
    private String nextDate = "";
    private String with = "PRIMARY KEY";
    private String defaultSegment = "NO";
    private String segmentType = "LOCAL";
    private RollbackSegmentOracle rollbackSegment;
    public static final String IMMEDIATE = "IMMEDIATE";
    public static final String DEFERRED = "DEFERRED";
    public static final String[] BUILD_STATES = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set buildSet = null;
    public static final String DISABLE = "DISABLE";
    public static final String ENABLE = "ENABLE";
    public static final String[] QUERY_REWRITE_STATES = new String[]{"DISABLE", "ENABLE"};
    private static Set queryRewriteSet = null;
    public static final String NEVER = "NEVER";
    public static final String[] REFRESH_STATES = new String[]{"NONE", "YES", "NEVER"};
    private static Set refreshSet = null;
    public static final String FAST = "FAST";
    public static final String COMPLETE = "COMPLETE";
    public static final String FORCE = "FORCE";
    public static final String[] REFRESH_TYPE_STATES = new String[]{"FAST", "COMPLETE", "FORCE"};
    private static Set refreshTypeSet = null;
    public static final String ON_DEMAND = "ON DEMAND";
    public static final String ON_COMMIT = "ON COMMIT";
    public static final String[] ACTION_STATES = new String[]{"", "ON DEMAND", "ON COMMIT"};
    private static Set actionSet = null;
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String ROWID = "ROWID";
    public static final String[] WITH_STATES = new String[]{"PRIMARY KEY", "ROWID"};
    private static Set withSet = null;
    public static final String MASTER = "MASTER";
    public static final String LOCAL = "LOCAL";
    public static final String[] SEGMENT_TYPE_STATES = new String[]{"MASTER", "LOCAL"};
    private static Set segmentTypeSet = null;
    private String subquery = "";
    private String columns = "";
    private String subPartColumns = "";
    private TableSpaceOracle tablespace;
    private TableSpaceOracle indexTablespace;
    private String logging = "NONE";
    private String cache = "NONE";
    private String clusterColumns = "";
    protected String commentInRdbms = "";
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Snapshot";

    public SnapshotOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.partitions = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("SnapshotOracle.Partitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(PartitionListOracle.class);
        this.partitions.setSetMethod("setPartitionList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        ((StorageDesignOracle)storageDesign).getPartitionSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getHashPartitionSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getListPartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("SnapshotOracle.LobStorages"));
        this.lobs.setClassForParent(SnapshotOracle.class);
        this.lobs.setSetMethod("setSnapshot");
        ((StorageDesignOracle)storageDesign).getLobStorageSet().addSetListener(this);
    }

    public DesignObject getObject() {
        return this.object;
    }

    public void setObject(DesignObject designObject) {
        this.object = designObject;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public UserOracle getUser() {
        TableProxyOracle tableProxyOracle = this.getOnPrebuildTable();
        if (tableProxyOracle != null) {
            return tableProxyOracle.getUser();
        }
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        TableProxyOracle tableProxyOracle = this.getOnPrebuildTable();
        if (tableProxyOracle != null) {
            return ((RelationalObjectProxy)tableProxyOracle).getLongName();
        }
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        TableProxyOracle tableProxyOracle2 = this.getImplementedTable();
        if (tableProxyOracle2 != null && tableProxyOracle2.getName().equals(this.getName())) {
            return tableProxyOracle2.getLongName();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof PartitionOracle) {
            PartitionOracle partitionOracle = (PartitionOracle)objectChangeEvent.getAffected();
            if (partitionOracle.getPartitionList() != null && partitionOracle.getPartitionList() == this.getPartitionList()) {
                partitionOracle.setParent(this.partitions);
                this.partitions.add(partitionOracle);
            } else {
                this.partitions.remove(partitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)objectChangeEvent.getAffected();
            if (hashPartitionOracle.getPartitionList() != null && hashPartitionOracle.getPartitionList() == this.getPartitionList()) {
                hashPartitionOracle.setParent(this.partitions);
                this.partitions.add(hashPartitionOracle);
            } else {
                this.partitions.remove(hashPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListPartitionOracle) {
            ListPartitionOracle listPartitionOracle = (ListPartitionOracle)objectChangeEvent.getAffected();
            if (listPartitionOracle.getPartitionList() != null && listPartitionOracle.getPartitionList() == this.getPartitionList()) {
                listPartitionOracle.setParent(this.partitions);
                this.partitions.add(listPartitionOracle);
            } else {
                this.partitions.remove(listPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectChangeEvent.getAffected();
            if (lobStorageOracle.getSnapshot() == this) {
                lobStorageOracle.setParent(this.lobs);
                this.lobs.add(lobStorageOracle);
            } else {
                this.lobs.remove(lobStorageOracle);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionOracle) {
                PartitionOracle partitionOracle = (PartitionOracle)modelObjectSetEvent.getAffected();
                partitionOracle.addObjectListener(this);
                if (partitionOracle.getPartitionList() != null && partitionOracle.getPartitionList() == this.getPartitionList()) {
                    partitionOracle.setParent(this.partitions);
                    this.partitions.add(partitionOracle);
                } else {
                    this.partitions.remove(partitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                hashPartitionOracle.addObjectListener(this);
                if (hashPartitionOracle.getPartitionList() != null && hashPartitionOracle.getPartitionList() == this.getPartitionList()) {
                    hashPartitionOracle.setParent(this.partitions);
                    this.partitions.add(hashPartitionOracle);
                } else {
                    this.partitions.remove(hashPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListPartitionOracle) {
                ListPartitionOracle listPartitionOracle = (ListPartitionOracle)modelObjectSetEvent.getAffected();
                listPartitionOracle.addObjectListener(this);
                if (listPartitionOracle.getPartitionList() != null && listPartitionOracle.getPartitionList() == this.getPartitionList()) {
                    listPartitionOracle.setParent(this.partitions);
                    this.partitions.add(listPartitionOracle);
                } else {
                    this.partitions.remove(listPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                lobStorageOracle.addObjectListener(this);
                if (lobStorageOracle.getSnapshot() == this) {
                    lobStorageOracle.setParent(this.lobs);
                    this.lobs.add(lobStorageOracle);
                } else {
                    this.lobs.remove(lobStorageOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof PartitionOracle || modelObjectSetEvent.getAffected() instanceof HashPartitionOracle || modelObjectSetEvent.getAffected() instanceof ListPartitionOracle) {
                AbstractStorageObjectOracle abstractStorageObjectOracle = (AbstractStorageObjectOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(abstractStorageObjectOracle);
                abstractStorageObjectOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                this.lobs.remove(lobStorageOracle);
                lobStorageOracle.removeObjectListener(this);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.partitions;
            }
            case 1: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitions) {
            return 0;
        }
        if (modelObject == this.lobs) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitions) {
            return 0;
        }
        if (object == this.lobs) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.partitions.removeAll();
        this.lobs.removeAll();
        Iterator iterator = this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            if (tableProxyOracle.getSnapshot() != this) continue;
            tableProxyOracle.setSnapshot(null);
        }
    }

    public void addPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            partitionOracle.addObjectListener(this);
            if (partitionOracle.getPartitionList() != null && partitionOracle.getPartitionList() == this.getPartitionList()) {
                partitionOracle.setParent(this.partitions);
                this.partitions.add(partitionOracle);
                continue;
            }
            this.partitions.remove(partitionOracle);
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        if (this.checkAction(string)) {
            this.action = string;
            this.fireDataFieldChange();
        }
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String string) {
        if (this.checkBuild(string)) {
            this.build = string;
            this.fireDataFieldChange();
        } else if (string.equalsIgnoreCase("DEFFERED")) {
            this.build = DEFERRED;
        }
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle clusterOracle) {
        this.cluster = clusterOracle;
        this.fireDataFieldChange();
    }

    public String getDefaultSegment() {
        return this.defaultSegment;
    }

    public void setDefaultSegment(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.defaultSegment = string;
            this.fireDataFieldChange();
        }
    }

    public String getForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.forUpdate = string;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getIndexSegment() {
        return this.indexSegment;
    }

    public void setIndexSegment(SegmentOracle segmentOracle) {
        this.indexSegment = segmentOracle;
        this.fireDataFieldChange();
    }

    public LobStorageOracle getLobStorage() {
        return this.lobStorage;
    }

    public void setLobStorage(LobStorageOracle lobStorageOracle) {
        this.lobStorage = lobStorageOracle;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getOnPrebuildTable() {
        return this.onPrebuildTable;
    }

    public void setOnPrebuildTable(TableProxyOracle tableProxyOracle) {
        this.onPrebuildTable = tableProxyOracle;
        this.fireDataFieldChange();
    }

    public String getParalelClause() {
        return this.paralelClause;
    }

    public void setParalelClause(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.paralelClause = string;
            this.fireDataFieldChange();
        }
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    public String getQueryRewrite() {
        return this.queryRewrite;
    }

    public void setQueryRewrite(String string) {
        if (this.checkQueryRewrite(string)) {
            this.queryRewrite = string;
            this.fireDataFieldChange();
        }
    }

    public String getReducedPrecision() {
        return this.reducedPrecision;
    }

    public void setReducedPrecision(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.reducedPrecision = string;
            this.fireDataFieldChange();
        }
    }

    public String getRefresh() {
        return this.refresh;
    }

    public void setRefresh(String string) {
        if (this.checkRefresh(string)) {
            this.refresh = string;
            this.fireDataFieldChange();
        }
    }

    public String getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshType(String string) {
        if (this.checkRefreshType(string)) {
            this.refreshType = string;
            this.fireDataFieldChange();
        }
    }

    public RollbackSegmentOracle getRollbackSegment() {
        return this.rollbackSegment;
    }

    public void setRollbackSegment(RollbackSegmentOracle rollbackSegmentOracle) {
        this.rollbackSegment = rollbackSegmentOracle;
        this.fireDataFieldChange();
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public String getSegmentType() {
        return this.segmentType;
    }

    public void setSegmentType(String string) {
        if (this.checkSegmentType(string)) {
            this.segmentType = string;
            this.fireDataFieldChange();
        }
    }

    public String getUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(String string) {
        if (ConstantsOracle.checkNoneYesNo(string)) {
            this.useIndex = string;
            this.fireDataFieldChange();
        }
    }

    public String getWith() {
        return this.with;
    }

    public void setWith(String string) {
        if (this.checkWith(string)) {
            this.with = string;
            this.fireDataFieldChange();
        }
    }

    protected boolean checkBuild(String string) {
        if (buildSet == null) {
            buildSet = new HashSet();
            buildSet.addAll(Arrays.asList(BUILD_STATES));
        }
        return buildSet.contains(string);
    }

    protected boolean checkQueryRewrite(String string) {
        if (queryRewriteSet == null) {
            queryRewriteSet = new HashSet();
            queryRewriteSet.addAll(Arrays.asList(QUERY_REWRITE_STATES));
        }
        return queryRewriteSet.contains(string);
    }

    protected boolean checkRefresh(String string) {
        if (refreshSet == null) {
            refreshSet = new HashSet();
            refreshSet.addAll(Arrays.asList(REFRESH_STATES));
        }
        return refreshSet.contains(string);
    }

    protected boolean checkRefreshType(String string) {
        if (refreshTypeSet == null) {
            refreshTypeSet = new HashSet();
            refreshTypeSet.addAll(Arrays.asList(REFRESH_TYPE_STATES));
        }
        return refreshTypeSet.contains(string);
    }

    protected boolean checkAction(String string) {
        if (actionSet == null) {
            actionSet = new HashSet();
            actionSet.addAll(Arrays.asList(ACTION_STATES));
        }
        return actionSet.contains(string);
    }

    protected boolean checkWith(String string) {
        if (withSet == null) {
            withSet = new HashSet();
            withSet.addAll(Arrays.asList(WITH_STATES));
        }
        return withSet.contains(string);
    }

    protected boolean checkSegmentType(String string) {
        if (segmentTypeSet == null) {
            segmentTypeSet = new HashSet();
            segmentTypeSet.addAll(Arrays.asList(SEGMENT_TYPE_STATES));
        }
        return segmentTypeSet.contains(string);
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(PartitionListOracle partitionListOracle) {
        String string = "";
        String string2 = "";
        if (partitionListOracle != null) {
            string = partitionListOracle.getPartitionType();
            if (string.equalsIgnoreCase("COMPOSITE BY HASH") || string.equalsIgnoreCase("COMPOSITE BY LIST")) {
                string = "RANGE";
            }
            string2 = partitionListOracle.getSubpartitionType();
        }
        if (this.partitionList != null && !this.partType.equalsIgnoreCase(string)) {
            this.partitions.removeAll();
        }
        this.partType = string;
        this.subpartType = string2;
        this.partitionList = partitionListOracle;
        if (this.partitionList == null) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitionList.setSnapshot(this);
            this.partitioned = "YES";
            if (this.partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                this.partitions.setForbiddenCreateElement(true);
            } else {
                this.partitions.setForbiddenCreateElement(false);
                this.partitions.setLogicalParent(partitionListOracle);
            }
            StorageDesignOracle storageDesignOracle = this.getStorageDesignOracle();
            if (this.partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS")) {
                this.partitions.setStorageObjectSet(storageDesignOracle.getHashPartitionSet());
                this.addHashPartFromDesign(storageDesignOracle.getHashPartitionSet());
            } else if (this.partType.equalsIgnoreCase("LIST")) {
                this.partitions.setStorageObjectSet(storageDesignOracle.getListPartitionSet());
                this.addListPartFromDesign(storageDesignOracle.getListPartitionSet());
            } else {
                this.partitions.setStorageObjectSet(storageDesignOracle.getPartitionSet());
                this.addPartFromDesign(storageDesignOracle.getPartitionSet());
            }
        }
        this.fireDataFieldChange();
    }

    public void addHashPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)iterator.next();
            hashPartitionOracle.addObjectListener(this);
            if (hashPartitionOracle.getPartitionList() != null && hashPartitionOracle.getPartitionList() == this.getPartitionList()) {
                hashPartitionOracle.setParent(this.partitions);
                this.partitions.add(hashPartitionOracle);
                continue;
            }
            this.partitions.remove(hashPartitionOracle);
        }
        this.fireDataFieldChange();
    }

    private void addListPartFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            ListPartitionOracle listPartitionOracle = (ListPartitionOracle)iterator.next();
            listPartitionOracle.addObjectListener(this);
            if (listPartitionOracle.getPartitionList() != null && listPartitionOracle.getPartitionList() == this.getPartitionList()) {
                listPartitionOracle.setParent(this.partitions);
                this.partitions.add(listPartitionOracle);
                continue;
            }
            this.partitions.remove(listPartitionOracle);
        }
    }

    public String getSubquery() {
        return this.subquery;
    }

    public void setSubquery(String string) {
        this.subquery = string;
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String string) {
        this.columns = string;
        this.fireDataFieldChange();
    }

    public String getSubPartColumns() {
        return this.subPartColumns;
    }

    public void setSubPartColumns(String string) {
        this.subPartColumns = string;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tableSpaceOracle) {
        if (this.tablespace != tableSpaceOracle) {
            this.tablespace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String string) {
        if (ConstantsOracle.checkNoneYesNo(string)) {
            this.cache = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String string) {
        if (ConstantsOracle.checkNoneYesNo(string)) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getClusterColumns() {
        return this.clusterColumns;
    }

    public void setClusterColumns(String string) {
        this.clusterColumns = string;
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getIndexTablespace() {
        return this.indexTablespace;
    }

    public void setIndexTablespace(TableSpaceOracle tableSpaceOracle) {
        this.indexTablespace = tableSpaceOracle;
        this.fireDataFieldChange();
    }

    public String getCommentInRdbms() {
        return this.commentInRdbms;
    }

    public void setCommentInRdbms(String string) {
        this.commentInRdbms = string;
        this.fireDataFieldChange();
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String string) {
        this.startDate = string;
        this.fireDataFieldChange();
    }

    public String getNextDate() {
        return this.nextDate;
    }

    public void setNextDate(String string) {
        this.nextDate = string;
        this.fireDataFieldChange();
    }

    public TableProxyOracle getImplementedTable() {
        Iterator iterator = this.getStorageDesignOracle().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            if (tableProxyOracle.getSnapshot() != this) continue;
            return tableProxyOracle;
        }
        return null;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("User", this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Lob Storage", this, "getLobStorage", "setLobStorage", LobStorageOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", ClusterOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Tablespace", this, "getTablespace", "setTablespace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Logging", this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage", this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Parallel Clause", this, "getParalelClause", "setParalelClause", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Build", this, "getBuild", "setBuild", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("On Prebuilt Table", this, "getOnPrebuildTable", "setOnPrebuildTable", TableProxyOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Reduced Precision", this, "getReducedPrecision", "setReducedPrecision", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("For Update", this, "getForUpdate", "setForUpdate", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Query Rewrite", this, "getQueryRewrite", "setQueryRewrite", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Use Index", this, "getUseIndex", "setUseIndex", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Index Tablespace", this, "getIndexTablespace", "setIndexTablespace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", String.class));
        }
        return this.propertyWrapperList;
    }

    public StorageObjectCollection getPartitionsCollection() {
        return this.partitions;
    }

    public List getPartitions() {
        ArrayList arrayList = new ArrayList();
        this.partitions.addAllElementsTo(arrayList);
        return arrayList;
    }

    public List getLobs() {
        ArrayList arrayList = new ArrayList();
        this.lobs.addAllElementsTo(arrayList);
        return arrayList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.lobs.removeAll();
        this.partitions.removeAll();
    }

    public abstract void copy(SnapshotOracle var1);

    public PartitionListOracle createPartitionList() {
        PartitionListOracle partitionListOracle = (PartitionListOracle)((StorageDesignOracle)this.getStorageDesign()).getPartitionListSet().createElement(null);
        partitionListOracle.setSnapshot(this);
        return partitionListOracle;
    }

    public void clearPartitionList() {
        PartitionListOracle partitionListOracle = this.partitionList;
        if (partitionListOracle != null) {
            this.setPartitionList(null);
            partitionListOracle.remove();
        }
    }

    public StorageObject createPartitionOracle() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public StorageObjectCollection getLobsCollection() {
        return this.lobs;
    }

    @Override
    public String getName() {
        TableProxyOracle tableProxyOracle = this.getOnPrebuildTable();
        if (tableProxyOracle != null) {
            return tableProxyOracle.getName();
        }
        return super.getName();
    }
}

