/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.SegmentPropertyDialogOraclev9i;

public abstract class SegmentOracle
extends AbstractStorageObjectOracle {
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    public static final String UNLIMITED = "UNLIMITED";
    private TableSpaceOracle tableSpace = null;
    private int pctFree = 10;
    private int pctUsed = 40;
    private int initrans = 1;
    private int maxtrans = 1;
    private long scInitialExtent = 0L;
    private long scNextExtent = 0L;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private int scPctIncrease = 0;
    private static Set scBufferPoolSet = null;
    private String scBufferPool = SC_BUFFER_POOL[0];
    private int scFreeLists = 1;
    private int scFreelistGroups = 1;
    public static final String TYPE_NAME = "Segment";

    @Override
    public String getIDPrefix() {
        return "Storage";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public int getPCTFree() {
        return this.pctFree;
    }

    public void setPCTFree(int n) {
        if (n >= 0 && n <= 99) {
            this.pctFree = n;
        }
    }

    public int getPCTUsed() {
        return this.pctUsed;
    }

    public void setPCTUsed(int n) {
        if (n >= 0 && n <= 99) {
            this.pctUsed = n;
        }
    }

    public int getInitrans() {
        return this.initrans;
    }

    public void setInitrans(int n) {
        if (n >= 1 && n <= 255) {
            this.initrans = n;
        }
    }

    public int getMaxTrans() {
        return this.maxtrans;
    }

    public void setMaxTrans(int n) {
        if (n >= 1 && n <= 255) {
            this.maxtrans = n;
        }
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long l) {
        this.scInitialExtent = l;
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long l) {
        this.scNextExtent = l;
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int n) {
        if (n >= 1) {
            this.scMinExtents = n;
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String string) {
        try {
            this.scMaxExtents = Integer.parseInt(string) > 0 ? string : UNLIMITED;
        }
        catch (NumberFormatException numberFormatException) {
            this.scMaxExtents = UNLIMITED;
        }
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int n) {
        this.scPctIncrease = n;
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String string) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(SegmentOracle.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(string);
    }

    public void setSCBufferPool(String string) {
        if (this.checkSCBufferPoolValue(string)) {
            this.scBufferPool = string;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int n) {
        if (n >= 1) {
            this.scFreeLists = n;
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int n) {
        if (n >= 1) {
            this.scFreelistGroups = n;
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SegmentPropertyDialogOraclev9i segmentPropertyDialogOraclev9i = new SegmentPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            segmentPropertyDialogOraclev9i.show();
        }
    }

    private boolean equalStrings(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }

    public boolean isEqualTo(SegmentOracle segmentOracle) {
        if (segmentOracle == null) {
            return false;
        }
        if (segmentOracle.getPCTFree() != this.getPCTFree()) {
            return false;
        }
        if (segmentOracle.getPCTUsed() != this.getPCTUsed()) {
            return false;
        }
        if (segmentOracle.getInitrans() != this.getInitrans()) {
            return false;
        }
        if (segmentOracle.getMaxTrans() != this.getMaxTrans()) {
            return false;
        }
        if (segmentOracle.getSCInitialExtent() != this.getSCInitialExtent()) {
            return false;
        }
        if (segmentOracle.getSCNextExtent() != this.getSCNextExtent()) {
            return false;
        }
        if (segmentOracle.getSCMinExtents() != this.getSCMinExtents()) {
            return false;
        }
        if (!this.equalStrings(segmentOracle.getSCMaxExtents(), this.getSCMaxExtents())) {
            return false;
        }
        if (segmentOracle.getSCPctIncrease() != this.getSCPctIncrease()) {
            return false;
        }
        if (!this.equalStrings(segmentOracle.getSCBufferPool(), this.getSCBufferPool())) {
            return false;
        }
        if (segmentOracle.getSCFreeLists() != this.getSCFreeLists()) {
            return false;
        }
        return segmentOracle.getSCFreelistGroups() == this.getSCFreelistGroups();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEGMENT_ICON", 16);
    }
}

