/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.plSqlSourceEditors.PlSqlNode;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.DefaultPropertyDialogOracle;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public abstract class PlSqlSourceStorageObjectOracle
extends AbstractStorageObjectOracle {
    private static final String SPACE = " ";
    private static final String EMPTY_BODY = " AS \n\nEND;";
    private static final String WORD_SEPARATORS_REGEXP = "[\t\r\n]";
    public static final String CREATE_OR_REPLACE = "CREATE OR REPLACE ";
    protected UserOracle owner;
    protected String source;
    protected List<CodeEditor> codeEditors = new ArrayList<CodeEditor>();
    protected boolean propertiesSet;

    public PlSqlSourceStorageObjectOracle(StorageDesign storageDesign, String string, String string2) {
        this.id = string;
        this.name = string2;
        this.setStorageDesign(storageDesign);
    }

    public void initSource() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CREATE_OR_REPLACE);
        stringBuilder.append(this.getTypeName().toUpperCase());
        stringBuilder.append(SPACE);
        String string = this.owner == null ? this.name : new StringBuffer(this.owner.getLongName()).append('.').append(this.name).toString();
        stringBuilder.append(this.getStorageDesign().getFormatedName(string));
        stringBuilder.append(EMPTY_BODY);
        this.setSource(stringBuilder.toString());
    }

    @Override
    public List<JMenuItem> getAdditionalActions() {
        List<JMenuItem> list = super.getAdditionalActions();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("PlSqlSourceStorageObjectOracle.Edit"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlSourceStorageObjectOracle.this.openEditor();
            }
        });
        list.add(jMenuItem);
        return list;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DefaultPropertyDialogOracle defaultPropertyDialogOracle = this.createPropertyDialog();
            defaultPropertyDialogOracle.show();
            this.propertiesSet = defaultPropertyDialogOracle.isPropertiesSet();
        }
    }

    protected abstract DefaultPropertyDialogOracle createPropertyDialog();

    @Override
    public void showPropertyDialogOnNew() {
        super.showPropertyDialogOnNew();
        if (this.propertiesSet) {
            this.openEditor();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.name).toString();
        }
        return this.name;
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getOwner() != null) {
            string = this.getOwner().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public String getSource() {
        this.updateSource();
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    @Override
    public boolean setName(String string) {
        boolean bl = false;
        if (!this.name.equals(string)) {
            bl = super.setName(string);
            this.updateSource();
        }
        return bl;
    }

    public void updateSource() {
        if (this.source != null && !this.getStorageDesign().isLoading()) {
            String string;
            int n;
            String string2 = this.getTypeName().toUpperCase();
            int n2 = this.source.toUpperCase().indexOf(string2);
            if (n2 > -1 && (n = this.source.indexOf(string = this.extractOwnerAndName(this.source), n2 + string2.length())) > -1) {
                String string3 = this.getLongName();
                if (this instanceof PackageBodyOracle && string3.endsWith(" Body")) {
                    string3 = string3.substring(0, string3.length() - " Body".length());
                }
                this.source = this.source.substring(0, n) + this.getStorageDesign().getFormatedName(string3) + this.source.substring(n + string.length());
            }
        }
    }

    private String extractOwnerAndName(String string) {
        String string2 = this.getTypeName();
        String string3 = Token.getStringAfter(string, string2);
        string3 = string3.replaceAll(WORD_SEPARATORS_REGEXP, SPACE);
        String string4 = Token.getFirstName(string3, '\"', '\"');
        if (string3.startsWith("\"")) {
            string4 = "\"" + string4 + "\"";
        }
        return string4;
    }

    protected void openEditor() {
        this.getDesign().getRelationalDesign().setSelectedRDBMSSite(this.getRDBMSSite());
        PlSqlNode plSqlNode = (PlSqlNode)NodeFactory.findOrCreateOrFail(PlSqlNode.class, (URL)this.getUrl());
        plSqlNode.setSourceObject(this);
        Context context = Context.newIdeContext((Node)plSqlNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
        CodeEditor codeEditor = (CodeEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        if (!this.codeEditors.contains(codeEditor)) {
            this.codeEditors.add(codeEditor);
        }
    }

    protected abstract URL getUrl();

    @Override
    public void remove(boolean bl) {
        EditorManager.getEditorManager().closeEditors(this.codeEditors);
        super.remove(bl);
    }

    @Override
    public void remove() {
        EditorManager.getEditorManager().closeEditors(this.codeEditors);
        super.remove();
    }

    public void setOwner(UserOracle userOracle) {
        if (this.owner != userOracle) {
            this.owner = userOracle;
            this.updateSource();
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public abstract String getTypeName();
}

