/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class PartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    private InlineList subPartitionsTableSpacesSet = null;
    protected PartitionListOracle partitionList = null;
    private String valueList = "";
    private int position = 0;
    private TableSpaceOracle tableSpace = null;
    private String logging = "";
    private String dataSegmentCompression = "";
    private SegmentOracle segment = null;
    private int iotCompress = 0;
    private SegmentOracle iotOverflowSegment = null;
    protected int subPartitionsQuantity = 0;
    private String subPartitionsTableSpaces = "";
    protected StorageObjectCollection lobs;
    protected StorageObjectCollection partitions;
    protected StorageObjectCollection listPartitions;
    public static final String TYPE_NAME = "Partition";

    public PartitionOracle(StorageDesign storageDesign) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
        this.setStorageDesign(storageDesignOracle);
        this.partitions = new StorageObjectCollection(storageDesignOracle.getHashPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("PartitionOracle.HashSubpartitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.partitions.setSetMethod("setSubPartitionOf");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getHashPartitionSet().addSetListener(this);
        this.lobs = new StorageObjectCollection(storageDesignOracle.getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("PartitionOracle.LobStorages"));
        this.lobs.setClassForParent(PartitionOracle.class);
        this.lobs.setSetMethod("setPartition");
        storageDesignOracle.getLobStorageSet().addSetListener(this);
        this.listPartitions = new StorageObjectCollection(storageDesignOracle.getListStorageTemplatePartitionSet());
        this.listPartitions.setParent(this);
        this.listPartitions.setName(Messages.getString("PartitionOracle.ListSubpartitions"));
        this.listPartitions.setClassForParent(AbstractStorageObjectOracle.class);
        this.listPartitions.setSetMethod("setSubPartitionOf");
        this.listPartitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getListStorageTemplatePartitionSet().addSetListener(this);
        this.addListSubpartitionsFromDesign(storageDesignOracle.getListStorageTemplatePartitionSet());
    }

    protected void addListSubpartitionsFromDesign(ListStorageTemplatePartitionSetOracle listStorageTemplatePartitionSetOracle) {
        Iterator iterator = listStorageTemplatePartitionSetOracle.iterator();
        while (iterator.hasNext()) {
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)iterator.next();
            if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                listStorageTemplatePartitionOracle.addObjectListener(this);
                listStorageTemplatePartitionOracle.setParent(this.listPartitions);
                this.listPartitions.add(listStorageTemplatePartitionOracle);
                continue;
            }
            this.listPartitions.remove(listStorageTemplatePartitionOracle);
        }
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public abstract void setPartitionList(PartitionListOracle var1);

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String string) {
        if (!this.valueList.equals(string)) {
            this.valueList = string;
            this.fireDataFieldChange();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        if (this.position != n) {
            this.position = n;
            this.fireDataFieldChange();
        }
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setDataSegmentCompression(String string) {
        if (!this.dataSegmentCompression.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.dataSegmentCompression = string;
            this.fireDataFieldChange();
        }
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        if (this.segment != segmentOracle) {
            this.segment = segmentOracle;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public int getIOTCompress() {
        return this.iotCompress;
    }

    public void setIOTCompress(int n) {
        if (this.iotCompress != n) {
            this.iotCompress = n;
            this.fireDataFieldChange();
        }
    }

    public void setIOTOverflowSegment(SegmentOracle segmentOracle) {
        if (this.iotOverflowSegment != segmentOracle) {
            this.iotOverflowSegment = segmentOracle;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getIOTOverflowSegment() {
        return this.iotOverflowSegment;
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int n) {
        if (this.subPartitionsQuantity != n) {
            this.subPartitionsQuantity = n;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.subPartitionsTableSpaces, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string.trim());
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public String convertTSNamesToIDs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(string2);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getObjectID());
        }
        return stringBuffer.toString();
    }

    public void setSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(string);
        } else {
            this.addSubPartitionsTS(string);
        }
        String string2 = this.getSubPartTSSet().toString();
        if (!this.subPartitionsTableSpaces.equals(string2)) {
            this.subPartitionsTableSpaces = string2;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionsTS(String string) {
        if (!this.getSubPartTSSet().contains(string)) {
            this.getSubPartTSSet().add(string);
        }
    }

    public void recreateSubPartitionsTSSet(String string) {
        this.getSubPartTSSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            this.getSubPartTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getSubPartTSSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getSubPartTSSet().clear();
        this.subPartitionsTableSpaces = "";
        this.clearChildren();
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof HashPartitionOracle) {
            HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)objectChangeEvent.getAffected();
            if (hashPartitionOracle.getSubPartitionOf() == this) {
                hashPartitionOracle.setParent(this.partitions);
                this.partitions.add(hashPartitionOracle);
            } else {
                this.partitions.remove(hashPartitionOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectChangeEvent.getAffected();
            if (lobStorageOracle.getPartition() == this) {
                lobStorageOracle.setParent(this.lobs);
                this.lobs.add(lobStorageOracle);
            } else {
                this.lobs.remove(lobStorageOracle);
            }
        } else if (objectChangeEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)objectChangeEvent.getAffected();
            if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                listStorageTemplatePartitionOracle.setParent(this.listPartitions);
                this.listPartitions.add(listStorageTemplatePartitionOracle);
            } else {
                this.listPartitions.remove(listStorageTemplatePartitionOracle);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                hashPartitionOracle.addObjectListener(this);
                if (hashPartitionOracle.getPartitionList() != null && hashPartitionOracle.getPartitionList() == this.getPartitionList()) {
                    hashPartitionOracle.setParent(this.partitions);
                    this.partitions.add(hashPartitionOracle);
                } else {
                    this.partitions.remove(hashPartitionOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                lobStorageOracle.addObjectListener(this);
                if (lobStorageOracle.getPartition() == this) {
                    lobStorageOracle.setParent(this.lobs);
                    this.lobs.add(lobStorageOracle);
                } else {
                    this.lobs.remove(lobStorageOracle);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)modelObjectSetEvent.getAffected();
                listStorageTemplatePartitionOracle.addObjectListener(this);
                if (listStorageTemplatePartitionOracle.getSubPartitionOf() == this) {
                    listStorageTemplatePartitionOracle.setParent(this.listPartitions);
                    this.listPartitions.add(listStorageTemplatePartitionOracle);
                } else {
                    this.listPartitions.remove(listStorageTemplatePartitionOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof HashPartitionOracle) {
                HashPartitionOracle hashPartitionOracle = (HashPartitionOracle)modelObjectSetEvent.getAffected();
                this.partitions.remove(hashPartitionOracle);
                hashPartitionOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                this.lobs.remove(lobStorageOracle);
                lobStorageOracle.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof ListStorageTemplatePartitionOracle) {
                ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = (ListStorageTemplatePartitionOracle)modelObjectSetEvent.getAffected();
                this.listPartitions.remove(listStorageTemplatePartitionOracle);
                listStorageTemplatePartitionOracle.removeObjectListener(this);
            }
        }
    }

    public void enableSubPartitionsByHash() {
        if (this.getSubPartitionsQuantity() > 0) {
            this.partitions.setForbiddenCreateElement(true);
        } else {
            this.partitions.setForbiddenCreateElement(false);
        }
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
    }

    public void enableSubPartitionsByList() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(false);
    }

    public void disableSubPartitions() {
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.removeAll();
        this.listPartitions.setForbiddenCreateElement(true);
        this.listPartitions.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobs;
            }
            case 1: {
                return this.partitions;
            }
            case 2: {
                return this.listPartitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobs) {
            return 0;
        }
        if (modelObject == this.partitions) {
            return 1;
        }
        if (modelObject == this.listPartitions) {
            return 2;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobs) {
            return 0;
        }
        if (object == this.partitions) {
            return 1;
        }
        if (object == this.listPartitions) {
            return 2;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
        this.partitions.removeAll();
        this.listPartitions.removeAll();
    }

    public StorageObjectCollection getLobs() {
        return this.lobs;
    }

    public StorageObjectCollection getPartitions() {
        return this.partitions;
    }

    public StorageObjectCollection getListPartitions() {
        return this.listPartitions;
    }

    public boolean hasSubPartitions() {
        return this.partitions.size() > 0 || this.listPartitions.size() > 0;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public HashPartitionOracle createHashSubpartition() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (HashPartitionOracle)this.partitions.createElement(null);
        }
        return null;
    }

    public ListStorageTemplatePartitionOracle createListSubpartition() {
        if (this.listPartitions.getStorageObjectSet() != null) {
            return (ListStorageTemplatePartitionOracle)this.listPartitions.createElement(null);
        }
        return null;
    }

    public StorageObject createLob() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (StorageObject)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> arrayList = new ArrayList<LocalIndexProperties>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().iterator();
        while (iterator.hasNext()) {
            LocalIndexProperties localIndexProperties = (LocalIndexProperties)iterator.next();
            if (localIndexProperties.getPartition() != this || localIndexProperties.getIndex() == null) continue;
            arrayList.add(localIndexProperties);
        }
        return arrayList;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties localIndexProperties = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        localIndexProperties.setPartition(this);
        return localIndexProperties;
    }

    @Override
    public void setParent(Object object) {
        RepositoryObject repositoryObject;
        super.setParent(object);
        RepositoryObject repositoryObject2 = null;
        if (object instanceof StorageObjectCollection && (repositoryObject2 = (repositoryObject = (RepositoryObject)((StorageObjectCollection)object).getParent()).getPAC_Element()) == null) {
            repositoryObject2 = repositoryObject;
        }
        this.setPAC_Element(repositoryObject2);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append("| ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

