/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public abstract class PartitionListOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    public static final String PARTITION_TYPE_RANGE = "RANGE";
    public static final String PARTITION_TYPE_HASH_BY_QUANTITY = "HASH BY QUANTITY";
    public static final String PARTITION_TYPE_HASH_BY_LIST_OF_PARTITIONS = "HASH BY LIST OF PARTITIONS";
    private InlineList columnsSet = null;
    private InlineList hashPartitionsTableSpacesSet = null;
    private InlineList subPartitionsColumnsSet = null;
    private InlineList subPartitionsTableSpacesSet = null;
    private TableProxyOracle table = null;
    private SnapshotOracle snapshot = null;
    protected String partitionType = "RANGE";
    protected String subpartitionType = "";
    private String columnList = "";
    private int hashpQuantity = 1;
    private String hashpTableSpaces = "";
    private String subPartitionsColumnList = "";
    private int subPartitionsQuantity = 1;
    private String subPartitionsTableSpaces = "";
    public static final String TYPE_NAME = "PartList";
    public static final String OLD_TYPE_NAME = "PartitionList";

    public PartitionListOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        ((StorageDesignOracle)storageDesign).getPartitionSet().addSetListener(this);
    }

    @Override
    public String getIDPrefix() {
        return "PL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        if (this.table != tableProxyOracle) {
            this.table = tableProxyOracle;
            if (tableProxyOracle != null) {
                this.setPAC_Element(tableProxyOracle);
            }
            if (this.getStorageDesign().isLoading()) {
                String string;
                StringTokenizer stringTokenizer;
                if (this.columnList.length() > 0) {
                    this.getColumnSet().clear();
                    stringTokenizer = new StringTokenizer(this.columnList, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken().trim();
                        if (tableProxyOracle.getColumnProxy(string) != null) {
                            this.getColumnSet().add(string);
                            continue;
                        }
                        this.addColumn(string);
                    }
                    this.columnList = this.getColumnSet().toString();
                }
                if (this.subPartitionsColumnList.length() > 0) {
                    this.getSubPartitionsColumnsSet().clear();
                    stringTokenizer = new StringTokenizer(this.subPartitionsColumnList, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken().trim();
                        if (tableProxyOracle.getColumnProxy(string) != null) {
                            this.getSubPartitionsColumnsSet().add(string);
                            continue;
                        }
                        this.addSubPartitionsColumn(string);
                    }
                    this.subPartitionsColumnList = this.getSubPartitionsColumnsSet().toString();
                }
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setSnapshot(SnapshotOracle snapshotOracle) {
        if (this.snapshot != snapshotOracle) {
            this.snapshot = snapshotOracle;
            if (snapshotOracle != null) {
                this.setPAC_Element(snapshotOracle);
            }
            this.fireDataFieldChange();
        }
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public abstract void setPartitionType(String var1);

    public String getPartitionType() {
        return this.partitionType;
    }

    public abstract void setSubpartitionType(String var1);

    public String getSubpartitionType() {
        return this.subpartitionType;
    }

    public String getColumnIDs() {
        return this.columnList;
    }

    public void setColumnIDs(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(string);
        } else {
            this.addColumnID(string);
        }
        String string2 = this.getColumnSet().toString();
        if (!this.columnList.equals(string2)) {
            this.columnList = string2;
            this.fireDataFieldChange();
        }
    }

    private void addColumnID(String string) {
        if (!this.getColumnSet().contains(string)) {
            this.getColumnSet().add(string);
        }
    }

    public String getColumnList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.table != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.columnList, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                ColumnProxy columnProxy = this.table.getColumnProxy(string);
                if (columnProxy == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(columnProxy.getName());
            }
        }
        return stringBuffer.toString();
    }

    public void setColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(string);
        } else {
            this.addColumn(string);
        }
        String string2 = this.getColumnSet().toString();
        if (!this.columnList.equals(string2)) {
            this.columnList = string2;
            this.fireDataFieldChange();
        }
    }

    public int getHashPQuantity() {
        return this.hashpQuantity;
    }

    public void setHashPQuantity(int n) {
        if (this.hashpQuantity != n) {
            this.hashpQuantity = n;
            this.fireDataFieldChange();
        }
    }

    public String getHashPTableSpaces() {
        return this.hashpTableSpaces;
    }

    public String getAllHashPTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.hashpTableSpaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setHashPTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashPartitionsTSSet(string);
        } else {
            this.addHashPartitionsTS(string);
        }
        String string2 = this.getHashPartitionsTableSpacesSet().toString();
        if (!this.hashpTableSpaces.equals(string2)) {
            this.hashpTableSpaces = string2;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsColumnIDs() {
        return this.subPartitionsColumnList;
    }

    public void setSubPartitionsColumnIDs(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsColumnsSet(string);
        } else {
            this.addSubPartitionColumnID(string);
        }
        String string2 = this.getSubPartitionsColumnsSet().toString();
        if (!this.subPartitionsColumnList.equals(string2)) {
            this.subPartitionsColumnList = string2;
            this.fireDataFieldChange();
        }
    }

    private void addSubPartitionColumnID(String string) {
        if (!this.getSubPartitionsColumnsSet().contains(string)) {
            this.getSubPartitionsColumnsSet().add(string);
        }
    }

    public String getSubPartitionsColumnList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.table != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.subPartitionsColumnList, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                ColumnProxy columnProxy = this.table.getColumnProxy(string);
                if (columnProxy == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(columnProxy.getName());
            }
        }
        return stringBuffer.toString();
    }

    public void setSubPartitionsColumnList(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsColumnsSet(string);
        } else {
            this.addSubPartitionsColumn(string);
        }
        String string2 = this.getSubPartitionsColumnsSet().toString();
        if (!this.subPartitionsColumnList.equals(string2)) {
            this.subPartitionsColumnList = string2;
            this.fireDataFieldChange();
        }
    }

    public int getSubPartitionsQuantity() {
        return this.subPartitionsQuantity;
    }

    public void setSubPartitionsQuantity(int n) {
        if (this.subPartitionsQuantity != n) {
            this.subPartitionsQuantity = n;
            this.fireDataFieldChange();
        }
    }

    public String getSubPartitionsTableSpaces() {
        return this.subPartitionsTableSpaces;
    }

    public String getAllSubPartitionsTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.subPartitionsTableSpaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    public void setSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSubPartitionsTSSet(string);
        } else {
            this.addSubPartitionsTS(string);
        }
        String string2 = this.getSubPartitionsTableSpacesSet().toString();
        if (!this.subPartitionsTableSpaces.equals(string2)) {
            this.subPartitionsTableSpaces = string2;
            this.fireDataFieldChange();
        }
    }

    private void addColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = "";
        if (this.table != null) {
            ColumnProxy columnProxy = this.table.getColumnProxyByName(string2);
            if (columnProxy != null) {
                string3 = columnProxy.getObjectID();
            }
        } else {
            string3 = string2;
        }
        if (!string3.equals("") && !this.getColumnSet().contains(string3)) {
            this.getColumnSet().add(string3);
        }
    }

    private void addHashPartitionsTS(String string) {
        if (!this.getHashPartitionsTableSpacesSet().contains(string)) {
            this.getHashPartitionsTableSpacesSet().add(string);
        }
    }

    private void addSubPartitionsColumn(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = "";
        if (this.table != null) {
            ColumnProxy columnProxy = this.table.getColumnProxyByName(string2);
            if (columnProxy != null) {
                string3 = columnProxy.getObjectID();
            }
        } else {
            string3 = string2;
        }
        if (!string3.equals("") && !this.getSubPartitionsColumnsSet().contains(string3)) {
            this.getSubPartitionsColumnsSet().add(string3);
        }
    }

    private void addSubPartitionsTS(String string) {
        if (!this.getSubPartitionsTableSpacesSet().contains(string)) {
            this.getSubPartitionsTableSpacesSet().add(string);
        }
    }

    public void recreateColumnsSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void recreateHashPartitionsTSSet(String string) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void recreateSubPartitionsColumnsSet(String string) {
        this.getSubPartitionsColumnsSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getSubPartitionsColumnsSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void recreateSubPartitionsTSSet(String string) {
        this.getSubPartitionsTableSpacesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getSubPartitionsTableSpacesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getColumnSet() {
        if (this.columnsSet == null) {
            this.columnsSet = new InlineList();
        }
        return this.columnsSet;
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public InlineList getSubPartitionsColumnsSet() {
        if (this.subPartitionsColumnsSet == null) {
            this.subPartitionsColumnsSet = new InlineList();
        }
        return this.subPartitionsColumnsSet;
    }

    public InlineList getSubPartitionsTableSpacesSet() {
        if (this.subPartitionsTableSpacesSet == null) {
            this.subPartitionsTableSpacesSet = new InlineList();
        }
        return this.subPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getColumnSet().clear();
        this.getHashPartitionsTableSpacesSet().clear();
        this.getSubPartitionsColumnsSet().clear();
        this.getSubPartitionsTableSpacesSet().clear();
        this.columnList = "";
        this.hashpTableSpaces = "";
        this.subPartitionsColumnList = "";
        this.subPartitionsTableSpaces = "";
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        public boolean contains(String string) {
            for (String string2 : this) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }
}

