/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public class LocalIndexProperties
extends AbstractStorageObjectOracle {
    private StorageObject partition;
    private StorageObject index;
    private String partitionName = "";
    private TableSpaceOracle tableSpace;
    private String logging = "";
    private SegmentOracle segment;
    private InlineList indexHSubPartitionsTableSpacesSet = null;
    private String indexHSubPartitionsTableSpaces = "";
    private int keyCompression = 0;
    private String layerType;
    private TableSpaceOracle workTablespace;
    public static final String TYPE_NAME = "LocIndProp";
    public static final String OLD_TYPE_NAME = "LocalIndexProperties";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LIP";
    }

    public InlineList getIndexHashSubPartTSSet() {
        if (this.indexHSubPartitionsTableSpacesSet == null) {
            this.indexHSubPartitionsTableSpacesSet = new InlineList();
        }
        return this.indexHSubPartitionsTableSpacesSet;
    }

    private void recreateLocIndexHashSubPartitionsTSSet(String string) {
        this.getIndexHashSubPartTSSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            this.getIndexHashSubPartTSSet().add(stringTokenizer.nextToken().trim());
        }
    }

    private void addLocIndexHashSubPartitionsTS(String string) {
        if (!this.getIndexHashSubPartTSSet().contains(string)) {
            this.getIndexHashSubPartTSSet().add(string);
        }
    }

    public void setHashSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateLocIndexHashSubPartitionsTSSet(string);
        } else {
            this.addLocIndexHashSubPartitionsTS(string);
        }
        this.indexHSubPartitionsTableSpaces = this.getIndexHashSubPartTSSet().toString();
        this.fireDataFieldChange();
    }

    public void clearHashSubPartTSSet() {
        this.getIndexHashSubPartTSSet().clear();
        this.indexHSubPartitionsTableSpaces = "";
    }

    public StorageObject getIndex() {
        return this.index;
    }

    public void setIndex(StorageObject storageObject) {
        this.index = storageObject;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String string) {
        this.logging = string;
    }

    public StorageObject getPartition() {
        return this.partition;
    }

    public void setPartition(StorageObject storageObject) {
        this.partition = storageObject;
        if (storageObject != null) {
            this.setPAC_Element(storageObject.getPAC_Element());
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String string) {
        this.partitionName = string;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.tableSpace = tableSpaceOracle;
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.indexHSubPartitionsTableSpaces;
    }

    public int getKeyCompression() {
        return this.keyCompression;
    }

    public void setKeyCompression(int n) {
        this.keyCompression = n;
    }

    public boolean isSpatialIndex() {
        if (this.getIndex() instanceof IndexProxy) {
            return ((IndexProxy)this.getIndex()).getIndex().isSpatialIndex();
        }
        return false;
    }

    public TableSpaceOracle getWorkTablespace() {
        return this.workTablespace;
    }

    public void setWorkTablespace(TableSpaceOracle tableSpaceOracle) {
        this.workTablespace = tableSpaceOracle;
    }

    public String getLayerType() {
        return this.layerType;
    }

    public void setLayerType(String string) {
        if (Arrays.asList(Index.getConstrainLayerTypeChoices()).contains(string)) {
            this.layerType = string;
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append("|");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

