/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.LobStoragePropertyDialogOracle;

public abstract class LobStorageOracle
extends AbstractStorageObjectOracle {
    private static final String[] SC_BUFFER_POOL = new String[]{"DEFAULT", "RECYCLE", "KEEP"};
    private static final String[] STORAGE_IN_ROW = new String[]{"ENABLE", "DISABLE"};
    private static final String[] CACHE = new String[]{"CACHE", "NOCACHE", "CACHE READS"};
    public static final String[] OLD_VERSIONS = new String[]{"RETENTION", "PCT_VERSION"};
    public static final String UNLIMITED = "UNLIMITED";
    private TableProxyOracle table;
    private SnapshotOracle snapshot;
    private PartitionOracle partition;
    private ListPartitionOracle listPartition;
    private String column = "";
    private String lobSegmentName = "";
    private TableSpaceOracle tableSpace = null;
    private static Set storageInRowSet = null;
    private String storageInRow = STORAGE_IN_ROW[0];
    protected String logging = "";
    private static Set cacheSet = null;
    private String cache = CACHE[1];
    private int chunk = 0;
    private int pctVersion = 0;
    private long scInitialExtent = 0L;
    private long scNextExtent = 0L;
    private int scMinExtents = 1;
    private String scMaxExtents = "UNLIMITED";
    private int scPctIncrease = 0;
    private static Set scBufferPoolSet = null;
    private String scBufferPool = SC_BUFFER_POOL[0];
    private int scFreeLists = 1;
    private int scFreelistGroups = 1;
    private String oldVersions = OLD_VERSIONS[0];
    private static Set oldVersionSet = null;
    private int freepools;
    public static final String TYPE_NAME = "LobStorage";

    @Override
    public String getIDPrefix() {
        return "LS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String string) {
        if (string != null && string.equals(this.column)) {
            return;
        }
        this.column = string;
        this.fireDataFieldChange();
    }

    public PartitionOracle getPartition() {
        return this.partition;
    }

    public void setPartition(PartitionOracle partitionOracle) {
        if (partitionOracle != this.partition) {
            this.partition = partitionOracle;
            this.table = null;
            this.snapshot = null;
            this.listPartition = null;
            if (partitionOracle != null) {
                this.setPAC_Element(partitionOracle.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public ListPartitionOracle getListPartition() {
        return this.listPartition;
    }

    public void setListPartition(ListPartitionOracle listPartitionOracle) {
        if (this.listPartition != listPartitionOracle) {
            this.listPartition = listPartitionOracle;
            this.table = null;
            this.snapshot = null;
            this.partition = null;
            if (listPartitionOracle != null) {
                this.setPAC_Element(listPartitionOracle.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    public SnapshotOracle getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotOracle snapshotOracle) {
        if (this.snapshot != snapshotOracle) {
            this.snapshot = snapshotOracle;
            this.table = null;
            this.partition = null;
            this.listPartition = null;
            if (snapshotOracle != null) {
                this.setPAC_Element(snapshotOracle);
            }
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle tableProxyOracle) {
        if (this.table != tableProxyOracle) {
            this.table = tableProxyOracle;
            this.snapshot = null;
            this.partition = null;
            this.listPartition = null;
            if (tableProxyOracle != null) {
                this.setPAC_Element(tableProxyOracle);
            }
            this.fireDataFieldChange();
        }
    }

    public String getLobSegmentName() {
        return this.lobSegmentName;
    }

    public void setLobSegmentName(String string) {
        if (string != null && string.equals(this.lobSegmentName)) {
            return;
        }
        this.lobSegmentName = string;
        this.fireDataFieldChange();
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public static String[] getStorageInRowChoices() {
        return STORAGE_IN_ROW;
    }

    protected boolean checkStorageInRow(String string) {
        if (storageInRowSet == null) {
            storageInRowSet = new HashSet();
            storageInRowSet.addAll(Arrays.asList(LobStorageOracle.getStorageInRowChoices()));
        }
        return storageInRowSet.contains(string);
    }

    public void setStorageInRow(String string) {
        if (this.checkStorageInRow(string)) {
            this.storageInRow = string;
            this.fireDataFieldChange();
        }
    }

    public String getStorageInRow() {
        return this.storageInRow;
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public static String[] getCacheChoices() {
        return CACHE;
    }

    protected boolean checkCache(String string) {
        if (cacheSet == null) {
            cacheSet = new HashSet();
            cacheSet.addAll(Arrays.asList(LobStorageOracle.getCacheChoices()));
        }
        return cacheSet.contains(string);
    }

    public void setCache(String string) {
        if (this.checkCache(string)) {
            this.cache = string;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public int getChunk() {
        return this.chunk;
    }

    public void setChunk(int n) {
        if (this.chunk != n) {
            this.chunk = n;
            this.fireDataFieldChange();
        }
    }

    public int getPCTVersion() {
        return this.pctVersion;
    }

    public void setPCTVersion(int n) {
        if (this.pctVersion != n) {
            this.pctVersion = n;
            this.fireDataFieldChange();
        }
    }

    public long getSCInitialExtent() {
        return this.scInitialExtent;
    }

    public void setSCInitialExtent(long l) {
        if (this.scInitialExtent != l) {
            this.scInitialExtent = l;
            this.fireDataFieldChange();
        }
    }

    public long getSCNextExtent() {
        return this.scNextExtent;
    }

    public void setSCNextExtent(long l) {
        if (this.scNextExtent != l) {
            this.scNextExtent = l;
            this.fireDataFieldChange();
        }
    }

    public int getSCMinExtents() {
        return this.scMinExtents;
    }

    public void setSCMinExtents(int n) {
        if (n >= 1) {
            this.scMinExtents = n;
            this.fireDataFieldChange();
        }
    }

    public String getSCMaxExtents() {
        return this.scMaxExtents;
    }

    public void setSCMaxExtents(String string) {
        try {
            this.scMaxExtents = Integer.parseInt(string) > 0 ? string : UNLIMITED;
        }
        catch (NumberFormatException numberFormatException) {
            this.scMaxExtents = UNLIMITED;
        }
        this.fireDataFieldChange();
    }

    public int getSCPctIncrease() {
        return this.scPctIncrease;
    }

    public void setSCPctIncrease(int n) {
        if (this.scPctIncrease != n) {
            this.scPctIncrease = n;
            this.fireDataFieldChange();
        }
    }

    public static String[] getSCBufferPoolValues() {
        return SC_BUFFER_POOL;
    }

    protected boolean checkSCBufferPoolValue(String string) {
        if (scBufferPoolSet == null) {
            scBufferPoolSet = new HashSet();
            scBufferPoolSet.addAll(Arrays.asList(LobStorageOracle.getSCBufferPoolValues()));
        }
        return scBufferPoolSet.contains(string);
    }

    public void setSCBufferPool(String string) {
        if (this.checkSCBufferPoolValue(string)) {
            this.scBufferPool = string;
            this.fireDataFieldChange();
        }
    }

    public String getSCBufferPool() {
        return this.scBufferPool;
    }

    public int getSCFreeLists() {
        return this.scFreeLists;
    }

    public void setSCFreeLists(int n) {
        if (n >= 1) {
            this.scFreeLists = n;
            this.fireDataFieldChange();
        }
    }

    public int getSCFreelistGroups() {
        return this.scFreelistGroups;
    }

    public void setSCFreelistGroups(int n) {
        if (n >= 1) {
            this.scFreelistGroups = n;
            this.fireDataFieldChange();
        }
    }

    public static String[] getOldVersionChoices() {
        return OLD_VERSIONS;
    }

    protected boolean checkOldVersion(String string) {
        if (oldVersionSet == null) {
            oldVersionSet = new HashSet();
            oldVersionSet.addAll(Arrays.asList(LobStorageOracle.getOldVersionChoices()));
        }
        return oldVersionSet.contains(string);
    }

    public String getOldVersions() {
        return this.oldVersions;
    }

    public void setOldVersions(String string) {
        if (this.checkOldVersion(string)) {
            this.oldVersions = string;
            this.fireDataFieldChange();
        }
    }

    public int getFreepools() {
        return this.freepools;
    }

    public void setFreepools(int n) {
        this.freepools = n;
    }

    public String getLobStorageType() {
        return "";
    }

    public void setLobStorageType(String string) {
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LobStoragePropertyDialogOracle lobStoragePropertyDialogOracle = new LobStoragePropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            lobStoragePropertyDialogOracle.show();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        LobStorageOracle lobStorageOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getLobStorageSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                lobStorageOracle = (LobStorageOracle)storageObject;
            }
        } else {
            lobStorageOracle = ((StorageDesignOracle)storageDesign).getLobStorageSet().createLobStorage();
        }
        if (lobStorageOracle != null) {
            lobStorageOracle.setName(this.getName());
            lobStorageOracle.setColumn(this.getColumn());
            lobStorageOracle.setLobSegmentName(this.getLobSegmentName());
            if (this.getTableSpace() != null) {
                TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)storageDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (tableSpaceOracle == null) {
                    TableSpaceOracle tableSpaceOracle2 = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                    tableSpaceOracle2.setName(this.getTableSpace().getName());
                    tableSpaceOracle2.setRawObject(true);
                    lobStorageOracle.setTableSpace(tableSpaceOracle2);
                } else {
                    lobStorageOracle.setTableSpace(tableSpaceOracle);
                }
            }
            lobStorageOracle.setStorageInRow(this.getStorageInRow());
            lobStorageOracle.setLogging(this.getLogging());
            lobStorageOracle.setCache(this.getCache());
            lobStorageOracle.setChunk(this.getChunk());
            lobStorageOracle.setOldVersions(this.getOldVersions());
            lobStorageOracle.setFreepools(this.getFreepools());
            lobStorageOracle.setPCTVersion(this.getPCTVersion());
            lobStorageOracle.setSCInitialExtent(this.getSCInitialExtent());
            lobStorageOracle.setSCNextExtent(this.getSCNextExtent());
            lobStorageOracle.setSCMinExtents(this.getSCMinExtents());
            lobStorageOracle.setSCMaxExtents(this.getSCMaxExtents());
            lobStorageOracle.setSCPctIncrease(this.getSCPctIncrease());
            lobStorageOracle.setSCBufferPool(this.getSCBufferPool());
            lobStorageOracle.setSCFreeLists(this.getSCFreeLists());
            lobStorageOracle.setSCFreelistGroups(this.getSCFreelistGroups());
            lobStorageOracle.setComment(this.getComment());
            lobStorageOracle.setRawObject(false);
            lobStorageOracle.setLobStorageType(this.getLobStorageType());
        }
    }
}

