/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ListPartitionOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener {
    protected PartitionListOracle partitionList;
    protected StorageObjectCollection lobs;
    private String valueList = "";
    private String dataSegmentCompression = "";
    private TableSpaceOracle tablespace;
    private String logging = "";
    private SegmentOracle segment;
    private int position = 0;
    public static final String TYPE_NAME = "ListPartition";

    public ListPartitionOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.lobs = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getLobStorageSet());
        this.lobs.setParent(this);
        this.lobs.setName(Messages.getString("ListPartitionOracle.LobStorages"));
        this.lobs.setClassForParent(ListPartitionOracle.class);
        this.lobs.setSetMethod("setListPartition");
        ((StorageDesignOracle)storageDesign).getLobStorageSet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LP";
    }

    public void setColumns(String string) {
        if (!this.valueList.equals(string)) {
            this.valueList = string;
            this.fireDataFieldChange();
        }
    }

    public String getColumns() {
        return this.valueList;
    }

    public String getDataSegmentCompression() {
        return this.dataSegmentCompression;
    }

    public void setDataSegmentCompression(String string) {
        if (!this.dataSegmentCompression.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.dataSegmentCompression = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        if (this.segment != segmentOracle) {
            this.segment = segmentOracle;
            this.fireDataFieldChange();
        }
    }

    public TableSpaceOracle getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceOracle tableSpaceOracle) {
        if (this.tablespace != tableSpaceOracle) {
            this.tablespace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        if (this.position != n) {
            this.position = n;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)objectChangeEvent.getAffected();
            if (lobStorageOracle.getListPartition() == this) {
                lobStorageOracle.setParent(this.lobs);
                this.lobs.add(lobStorageOracle);
            } else {
                this.lobs.remove(lobStorageOracle);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
                lobStorageOracle.addObjectListener(this);
                if (lobStorageOracle.getListPartition() == this) {
                    lobStorageOracle.setParent(this.lobs);
                    this.lobs.add(lobStorageOracle);
                } else {
                    this.lobs.remove(lobStorageOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof LobStorageOracle) {
            LobStorageOracle lobStorageOracle = (LobStorageOracle)modelObjectSetEvent.getAffected();
            this.lobs.remove(lobStorageOracle);
            lobStorageOracle.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.lobs;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.lobs) {
            return 0;
        }
        return -1;
    }

    @Override
    public void clearChildren() {
        this.lobs.removeAll();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public PartitionListOracle getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(PartitionListOracle partitionListOracle) {
        if (this.partitionList != partitionListOracle) {
            this.partitionList = partitionListOracle;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ListPartitionOracle listPartitionOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOracle)storageDesign).getListPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                listPartitionOracle = (ListPartitionOracle)storageObject;
            }
        } else {
            listPartitionOracle = ((StorageDesignOracle)storageDesign).getListPartitionSet().createListPartition();
        }
        if (listPartitionOracle != null) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            AbstractStorageObjectOracle abstractStorageObjectOracle2;
            Object object;
            listPartitionOracle.setName(this.getName());
            if (this.getPartitionList() != null) {
                object = (PartitionListOracle)((StorageDesignOracle)storageDesign).getPartitionListSet().getByName(this.getPartitionList().getName());
                if (object == null) {
                    abstractStorageObjectOracle2 = ((StorageDesignOracle)storageDesign).getPartitionListSet().createPartitionList();
                    abstractStorageObjectOracle2.setName(this.getPartitionList().getName());
                    abstractStorageObjectOracle2.setRawObject(true);
                    listPartitionOracle.setPartitionList((PartitionListOracle)abstractStorageObjectOracle2);
                } else {
                    listPartitionOracle.setPartitionList((PartitionListOracle)object);
                }
            }
            object = this.lobs.iterator();
            while (object.hasNext()) {
                abstractStorageObjectOracle2 = (LobStorageOracle)object.next();
                abstractStorageObjectOracle = (LobStorageOracle)((StorageDesignOracle)storageDesign).getLobStorageSet().getByName(abstractStorageObjectOracle2.getName());
                if (abstractStorageObjectOracle == null) {
                    LobStorageOracle lobStorageOracle = ((StorageDesignOracle)storageDesign).getLobStorageSet().createLobStorage();
                    lobStorageOracle.setName(abstractStorageObjectOracle2.getName());
                    lobStorageOracle.setRawObject(true);
                    lobStorageOracle.setListPartition(listPartitionOracle);
                    continue;
                }
                ((LobStorageOracle)abstractStorageObjectOracle).setListPartition(listPartitionOracle);
            }
            listPartitionOracle.setColumns(this.getColumns());
            listPartitionOracle.setDataSegmentCompression(this.getDataSegmentCompression());
            if (this.getTablespace() != null) {
                abstractStorageObjectOracle2 = (TableSpaceOracle)((StorageDesignOracle)storageDesign).getTableSpaceSet().getByName(this.getTablespace().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)abstractStorageObjectOracle).setName(this.getTablespace().getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    listPartitionOracle.setTablespace((TableSpaceOracle)abstractStorageObjectOracle);
                } else {
                    listPartitionOracle.setTablespace((TableSpaceOracle)abstractStorageObjectOracle2);
                }
            }
            listPartitionOracle.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                abstractStorageObjectOracle2 = (SegmentOracle)((StorageDesignOracle)storageDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (abstractStorageObjectOracle2 == null) {
                    abstractStorageObjectOracle = ((StorageDesignOracle)storageDesign).getSegmentSet().createSegment();
                    abstractStorageObjectOracle.setName(this.getSegment().getName());
                    abstractStorageObjectOracle.setRawObject(true);
                    listPartitionOracle.setSegment((SegmentOracle)abstractStorageObjectOracle);
                } else {
                    listPartitionOracle.setSegment((SegmentOracle)abstractStorageObjectOracle2);
                }
            }
            listPartitionOracle.setComment(this.getComment());
            listPartitionOracle.setRawObject(false);
        }
    }

    public StorageObjectCollection getLobStorages() {
        return this.lobs;
    }

    public LobStorageOracle createLobStorage() {
        if (this.lobs.getStorageObjectSet() != null) {
            return (LobStorageOracle)this.lobs.createElement(null);
        }
        return null;
    }

    public List getLocalIndexProperties() {
        ArrayList<LocalIndexProperties> arrayList = new ArrayList<LocalIndexProperties>();
        Iterator iterator = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().iterator();
        while (iterator.hasNext()) {
            LocalIndexProperties localIndexProperties = (LocalIndexProperties)iterator.next();
            if (localIndexProperties.getPartition() != this || localIndexProperties.getIndex() == null) continue;
            arrayList.add(localIndexProperties);
        }
        return arrayList;
    }

    public LocalIndexProperties createLocalIndexProperties() {
        LocalIndexProperties localIndexProperties = ((StorageDesignOracle)this.getStorageDesign()).getLocalIndexPropertiesSet().createLocalIndexProperties();
        localIndexProperties.setPartition(this);
        return localIndexProperties;
    }

    @Override
    public void setParent(Object object) {
        RepositoryObject repositoryObject;
        super.setParent(object);
        RepositoryObject repositoryObject2 = null;
        if (object instanceof StorageObjectCollection && (repositoryObject2 = (repositoryObject = (RepositoryObject)((StorageObjectCollection)object).getParent()).getPAC_Element()) == null) {
            repositoryObject2 = repositoryObject;
        }
        this.setPAC_Element(repositoryObject2);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16);
    }
}

