/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.LevelPropertyDialogOracle;

public class LevelOracle
extends AbstractStorageObjectOracle {
    private String columns = "";
    private InlineList columnSet = null;
    private DimensionOracle dimension;
    private TableProxy levelTable;
    private transient String newName = "";
    public static final String TYPE_NAME = "Level";

    public LevelOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            LevelPropertyDialogOracle levelPropertyDialogOracle = new LevelPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            levelPropertyDialogOracle.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "L";
    }

    public ArrayList getTables() {
        ArrayList<TableProxyOracle> arrayList = new ArrayList<TableProxyOracle>();
        ColumnProxySetOracle columnProxySetOracle = (ColumnProxySetOracle)this.getStorageDesign().getColumnProxySet();
        for (int i = 0; i < this.getColumnSet().size(); ++i) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxySetOracle.getProxy((String)this.getColumnSet().elementAt(i));
            if (columnProxyOracle == null || arrayList.contains(columnProxyOracle.getTableProxy())) continue;
            arrayList.add(columnProxyOracle.getTableProxy());
        }
        return arrayList;
    }

    private void addColumn(String string) {
        if (!this.getColumnSet().contains(string)) {
            this.getColumnSet().add(string);
        }
    }

    public void recreateColumnSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(string);
        } else {
            this.addColumn(string);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public InlineList getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new InlineList();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimensionOracle) {
        if (this.dimension != dimensionOracle) {
            this.dimension = dimensionOracle;
            this.setPAC_Element(dimensionOracle);
            this.fireDataFieldChange();
        }
    }

    public TableProxy getLevelTable() {
        if (this.levelTable == null && this.getColumnSet().size() > 0) {
            ColumnProxySetOracle columnProxySetOracle = (ColumnProxySetOracle)this.getStorageDesign().getColumnProxySet();
            for (int i = 0; i < this.getColumnSet().size(); ++i) {
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxySetOracle.getProxy((String)this.getColumnSet().elementAt(i));
                if (columnProxyOracle == null || columnProxyOracle.getTableProxy() == null) continue;
                this.levelTable = columnProxyOracle.getTableProxy();
                break;
            }
        }
        return this.levelTable;
    }

    public void setLevelTable(TableProxy tableProxy) {
        this.levelTable = tableProxy;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("LEVEL_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(",");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

