/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyOracle
extends IndexProxy
implements StorageObjectListener,
Constants,
ModelObjectSetListener,
PropertiesPropagator {
    public static final String[] PARTITIONED = new String[]{"NON_PARTITIONED", "LOCAL", "GLOBAL"};
    public static final String[] SORTED_ROWS = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set partitionedSet = null;
    private static Set sortedRowsSet = null;
    protected UserOracle user = null;
    protected boolean bitmapIndex = false;
    protected String partitioned = PARTITIONED[0];
    protected IndexGlobalPartitionsListOracle indexGlobalPartList = null;
    protected TableSpaceOracle tableSpace = null;
    protected String logging = "YES";
    protected SegmentOracle segment = null;
    protected int compress = 0;
    protected String parallel = "NO";
    private String degree = "";
    protected String sortedRows = "SORTED";
    protected String computeStatistics = "NO";
    protected String online = "NO";
    protected StorageObjectCollection partitions;
    protected String hashSubPartitionsTableSpaces = "";
    protected InlineList hashPartitionsTableSpacesSet = null;
    private List propertyWrapperList = null;
    private String indexType = "";
    private String indexDomainParameters = "";
    public static final String NAME_SUBSTITUTION_TYPE = "Index";

    public IndexProxyOracle(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    public IndexProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.initPartitions((StorageDesignOracle)storageDesign);
    }

    protected void initPartitions(StorageDesignOracle storageDesignOracle) {
        this.partitions = new StorageObjectCollection(storageDesignOracle.getIndexGlobalPartitionSet());
        this.partitions.setParent(this);
        this.partitions.setName(Messages.getString("IndexProxyOracle.GlobalPartitions"));
        this.partitions.setForbiddenCreateElement(true);
        this.partitions.setClassForParent(IndexGlobalPartitionsListOracle.class);
        this.partitions.setSetMethod("setIndexGlobalPartList");
        this.partitions.setIcon(GUIConfiguration.getInstance().getIcon("PARTITION_ICON", 16));
        storageDesignOracle.getIndexGlobalPartitionSet().addSetListener(this);
        this.addIGPFromDesign(storageDesignOracle.getIndexGlobalPartitionSet());
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)objectChangeEvent.getAffected();
            if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                indexGlobalPartitionOracle.setParent(this.partitions);
                this.partitions.add(indexGlobalPartitionOracle);
            } else {
                this.partitions.remove(indexGlobalPartitionOracle);
            }
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
            ((StorageDesignOracle)this.getStorageDesign()).getPKProxySet().remove(designObject);
            if (!this.isUniqueConstraint()) {
                this.getStorageDesign().getIndexProxySet().add(this);
            }
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getFKProxySet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().add(designObject);
            this.fireChangeNoDirty(objectChangeEvent);
        } else if (objectChangeEvent.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
            ((StorageDesignOracle)this.getStorageDesign()).getUniqueSet().remove(designObject);
            this.getStorageDesign().getIndexProxySet().add(this);
            this.fireChangeNoDirty(objectChangeEvent);
        }
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        if (this.user != userOracle) {
            this.user = userOracle;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public String getTableUser() {
        if (((TableProxyOracle)this.getTableProxy()).getUser() != null) {
            return ((TableProxyOracle)this.getTableProxy()).getUser().getName();
        }
        return "";
    }

    public void setBitmapIndex(boolean bl) {
        if (!this.isUnique()) {
            this.bitmapIndex = bl;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getTableProxy();
            if (tableProxyOracle != null && bl && tableProxyOracle.getPartitioned().equalsIgnoreCase("YES")) {
                this.setIndexPartitioned("LOCAL");
            }
            this.fireDataFieldChange();
        }
    }

    public boolean getBitmapIndex() {
        return this.bitmapIndex;
    }

    public static String[] getPartitionedChoices() {
        return PARTITIONED;
    }

    private boolean checkPartitionedChoices(String string) {
        if (partitionedSet == null) {
            partitionedSet = new HashSet();
            partitionedSet.addAll(Arrays.asList(IndexProxyOracle.getPartitionedChoices()));
        }
        return partitionedSet.contains(string);
    }

    public void setIndexPartitioned(String string) {
        if (this.checkPartitionedChoices(string)) {
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    public String getIndexPartitioned() {
        if (this.bitmapIndex && ((TableProxyOracle)this.getTableProxy()).getPartitioned().equalsIgnoreCase("YES")) {
            this.setIndexPartitioned("LOCAL");
        }
        return this.partitioned;
    }

    public IndexGlobalPartitionsListOracle getIndexGlobalPartitionsList() {
        return this.indexGlobalPartList;
    }

    public void setIndexGlobalPartitionsList(IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle) {
        if (this.indexGlobalPartList != null && this.indexGlobalPartList != indexGlobalPartitionsListOracle) {
            this.partitions.removeAll();
            this.partitions.setForbiddenCreateElement(true);
        }
        this.indexGlobalPartList = indexGlobalPartitionsListOracle;
        if (this.indexGlobalPartList != null) {
            this.partitions.setForbiddenCreateElement(false);
            this.partitions.setLogicalParent(indexGlobalPartitionsListOracle);
        }
        this.addIGPFromDesign(((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionSet());
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        if (this.tableSpace == null && this.segment != null) {
            this.tableSpace = this.segment.getTableSpace();
            this.fireDataFieldChange();
        }
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int n) {
        if (this.compress != n) {
            this.compress = n;
            this.fireDataFieldChange();
        }
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String string) {
        if (!"".equalsIgnoreCase(string)) {
            try {
                Integer.parseInt(string);
                this.degree = string;
            }
            catch (NumberFormatException numberFormatException) {
                this.degree = "";
            }
        } else {
            this.degree = "";
        }
        this.fireDataFieldChange();
    }

    public static String[] getSortedRowsChoices() {
        return SORTED_ROWS;
    }

    private boolean checkSortedRowsChoices(String string) {
        if (sortedRowsSet == null) {
            sortedRowsSet = new HashSet();
            sortedRowsSet.addAll(Arrays.asList(IndexProxyOracle.getSortedRowsChoices()));
        }
        return sortedRowsSet.contains(string);
    }

    public void setSortedRows(String string) {
        if (this.checkSortedRowsChoices(string)) {
            this.sortedRows = string;
            this.fireDataFieldChange();
        }
    }

    public String getSortedRows() {
        return this.sortedRows;
    }

    public void setComputeStatistics(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.computeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setOnline(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.online = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            if (!"".equals(this.getUser().getLongName())) {
                return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
            }
            return new StringBuffer(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            UserOracle userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                if (!"".equals(userOracle.getLongName())) {
                    return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
                }
                return new StringBuffer(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public String getUserNameAndName() {
        UserOracle userOracle = this.getUser();
        if (userOracle != null) {
            return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
        }
        Index index = this.getIndex();
        SchemaObject schemaObject = index.getSchemaObject();
        if (schemaObject != null) {
            userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        if ((userOracle = ((TableProxyOracle)this.getTableProxy()).getUser()) != null) {
            return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
        }
        if (index.getContainerObject() != null && (schemaObject = index.getContainerObject().getSchemaObject()) != null) {
            userOracle = ((StorageDesignOracle)this.getStorageDesign()).getUserSet().getUserBySchemaObject(schemaObject);
            if (userOracle != null) {
                return new StringBuffer(userOracle.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return this.getName();
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public boolean isUnique() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.partitions;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.partitions) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.partitions.removeAll();
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
                IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
                indexGlobalPartitionOracle.addObjectListener(this);
                if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList() && !this.partitions.contains(indexGlobalPartitionOracle)) {
                    indexGlobalPartitionOracle.setParent(this.partitions);
                    this.partitions.add(indexGlobalPartitionOracle);
                } else {
                    this.partitions.remove(indexGlobalPartitionOracle);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof IndexGlobalPartitionOracle) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)modelObjectSetEvent.getAffected();
            this.partitions.remove(indexGlobalPartitionOracle);
            indexGlobalPartitionOracle.removeObjectListener(this);
        }
    }

    protected void addIGPFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            IndexGlobalPartitionOracle indexGlobalPartitionOracle = (IndexGlobalPartitionOracle)iterator.next();
            indexGlobalPartitionOracle.addObjectListener(this);
            if (indexGlobalPartitionOracle.getIndexGlobalPartList() != null && indexGlobalPartitionOracle.getIndexGlobalPartList() == this.getIndexGlobalPartitionsList()) {
                indexGlobalPartitionOracle.setParent(this.partitions);
                this.partitions.add(indexGlobalPartitionOracle);
                continue;
            }
            this.partitions.remove(indexGlobalPartitionOracle);
        }
    }

    public void setHashSubPartitionsTableSpaces(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashSubPartitionsTSSet(string);
        } else {
            this.addHashSubPartitionsTS(string);
        }
        this.hashSubPartitionsTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.hashSubPartitionsTableSpaces;
    }

    public String getAllHashSubPartitionsTableSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.hashSubPartitionsTableSpaces, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            TableSpaceOracle tableSpaceOracle = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(string);
            if (tableSpaceOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(tableSpaceOracle.getName());
        }
        return stringBuffer.toString();
    }

    private void addHashSubPartitionsTS(String string) {
        if (!this.getHashPartitionsTableSpacesSet().contains(string)) {
            this.getHashPartitionsTableSpacesSet().add(string);
        }
    }

    protected void recreateHashSubPartitionsTSSet(String string) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getHashPartitionsTableSpacesSet().clear();
        this.hashSubPartitionsTableSpaces = "";
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("User", this, "getUser", "setUser", UserOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Bitmap Index", this, "getBitmapIndex", "setBitmapIndex", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Indextype", this, "getIndexType", "setIndexType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getIndexPartitioned", "setIndexPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Logging", this, "getLogging", "setLogging", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Storage", this, "getSegment", "setSegment", SegmentOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper("Compress", this, "getCompress", "setCompress", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Parallel", this, "getParallel", "setParallel", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Degree", this, "getDegree", "setDegree", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Sorted Rows", this, "getSortedRows", "setSortedRows", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Compute Statistics", this, "getComputeStatistics", "setComputeStatistics", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Online", this, "getOnline", "setOnline", String.class));
        }
        return this.propertyWrapperList;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String string) {
        if (!string.equals("null")) {
            this.indexType = string;
        }
    }

    public String getIndexDomainParameters() {
        return this.indexDomainParameters;
    }

    public void setIndexDomainParameters(String string) {
        if (!string.equals("null")) {
            this.indexDomainParameters = string;
        }
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            string = index.getFKAssociation().getName();
        }
        string = this.applyNameSubstitution(string);
        return string;
    }

    public StorageObjectCollection getGlobalPartitions() {
        return this.partitions;
    }

    public StorageObject createGlobalPartition() {
        if (this.partitions.getStorageObjectSet() != null) {
            return (StorageObject)this.partitions.createElement(null);
        }
        return null;
    }

    public IndexGlobalPartitionsListOracle createIndexGlobalPartitionsList() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = (IndexGlobalPartitionsListOracle)((StorageDesignOracle)this.getStorageDesign()).getIndexGlobalPartitionsListSet().createElement(null);
        indexGlobalPartitionsListOracle.setIndex(this);
        return indexGlobalPartitionsListOracle;
    }

    public void clearIndexGlobalPartitionsList() {
        IndexGlobalPartitionsListOracle indexGlobalPartitionsListOracle = this.indexGlobalPartList;
        if (indexGlobalPartitionsListOracle != null) {
            this.setIndexGlobalPartitionsList(null);
            indexGlobalPartitionsListOracle.remove();
        }
    }

    @Override
    public String getNameSubstitutionType() {
        return NAME_SUBSTITUTION_TYPE;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

