/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;

public abstract class IndexGlobalPartitionsListOracle
extends AbstractStorageObjectOracle {
    protected IndexProxy index = null;
    private String globalPartColumns = "";
    private InlineList columnsSet = null;
    public static final String TYPE_NAME = "IndexGlobalPartitionsList";

    @Override
    public String getIDPrefix() {
        return "IGPL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public String getGlobalPartColumns() {
        return this.globalPartColumns;
    }

    public String getAllGlobalPartColumns() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.globalPartColumns, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)this.getStorageDesignOracle().getColumnProxySet().getProxy(string);
            if (columnProxyOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnProxyOracle.getName());
        }
        return stringBuffer.toString();
    }

    public String columnNamesToColumnIDs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = Token.getName(stringTokenizer.nextToken());
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)this.getIndex().getTableProxy().getColumnProxyByName(string2);
            if (columnProxyOracle == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnProxyOracle.getObjectID());
        }
        return stringBuffer.toString();
    }

    public void setGlobalPartColumns(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnsSet(string);
        } else {
            this.addColumn(string);
        }
        this.globalPartColumns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addColumn(String string) {
        if (!this.getColumnSet().contains(string)) {
            this.getColumnSet().add(string);
        }
    }

    protected void recreateColumnsSet(String string) {
        this.getColumnSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getColumnSet().add(stringTokenizer.nextToken().trim());
        }
    }

    @Override
    public void showPropertyDialog() {
    }

    public InlineList getColumnSet() {
        if (this.columnsSet == null) {
            this.columnsSet = new InlineList();
        }
        return this.columnsSet;
    }

    public void clear() {
        this.getColumnSet().clear();
        this.globalPartColumns = "";
    }

    public IndexProxy getIndex() {
        return this.index;
    }

    public void setIndex(IndexProxy indexProxy) {
        if (this.index != indexProxy) {
            this.index = indexProxy;
            if (indexProxy != null) {
                this.setPAC_Element(indexProxy.getPAC_Element());
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

