/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.HierarchyPropertyDialogOracle;

public class HierarchyOracle
extends AbstractStorageObjectOracle {
    private DimensionOracle dimension;
    private String levels = "";
    private InlineList levelSet = null;
    private String joins = "";
    private InlineList joinSet = null;
    public static final String TYPE_NAME = "Hierarchy";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            HierarchyPropertyDialogOracle hierarchyPropertyDialogOracle = new HierarchyPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            hierarchyPropertyDialogOracle.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "H";
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimensionOracle) {
        if (this.dimension != dimensionOracle) {
            this.dimension = dimensionOracle;
            this.setPAC_Element(dimensionOracle);
            this.fireDataFieldChange();
        }
    }

    private void addLevel(String string) {
        if (!this.getLevelSet().contains(string)) {
            this.getLevelSet().add(string);
        }
    }

    public void recreateLevelSet(String string) {
        this.getLevelSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.getLevelSet().add(stringTokenizer.nextToken().trim());
        }
    }

    public void setLevels(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateLevelSet(string);
        } else {
            this.addLevel(string);
        }
        this.levels = this.getLevelSet().toString();
        this.fireDataFieldChange();
    }

    public String getLevels() {
        return this.levels;
    }

    public InlineList getLevelSet() {
        if (this.levelSet == null) {
            this.levelSet = new InlineList();
        }
        return this.levelSet;
    }

    public void clearLevels() {
        this.getLevelSet().removeAllElements();
        this.levels = "";
    }

    private void addJoin(String string) {
        if (!this.getJoinSet().contains(string)) {
            this.getJoinSet().add(string);
        }
    }

    public void recreateJoinSet(String string) {
        this.getJoinSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (string2.toUpperCase().indexOf("REFERENCES") > 0) {
                this.getJoinSet().add(stringBuffer.toString().trim());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            stringBuffer.append(",");
        }
    }

    public void setJoins(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateJoinSet(string);
        } else {
            this.addJoin(string);
        }
        this.joins = this.getJoinSet().toString();
        this.fireDataFieldChange();
    }

    public String getJoins() {
        return this.joins;
    }

    public InlineList getJoinSet() {
        if (this.joinSet == null) {
            this.joinSet = new InlineList();
        }
        return this.joinSet;
    }

    public void clearJoins() {
        this.getJoinSet().removeAllElements();
        this.joins = "";
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

