/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ExternalTableOracle
extends AbstractStorageObjectOracle {
    protected UserOracle owner;
    protected String accessDriverType = "oracle_loader";
    protected DirectoryOracle defaultDir;
    public static final String OPAQUE_FORMAT_SPEC = "Opaque Format Spec";
    public static final String CLOB_SUBQUERY = "CLOB Subquery";
    protected String accessParametersType = "Opaque Format Spec";
    private static final String[] accessParametersChoices = new String[]{"Opaque Format Spec", "CLOB Subquery", "NONE"};
    private static Set accessParametersSet = null;
    protected String opaqueFormatSpec = "";
    protected String clobSubquery = "";
    protected String location = "";
    protected String parallel = "NOPARALLEL";
    protected int parallelNum;
    protected String rejectLimit = "UNLIMITED";
    protected StorageObjectCollection cols;
    public static final String TYPE_NAME = "ExtTbl";
    public static final String OLD_TYPE_NAME = "ExternalTable";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return OLD_TYPE_NAME;
    }

    public static String[] getAccessParametersChoices() {
        return accessParametersChoices;
    }

    protected boolean checkAccessParameters(String string) {
        if (accessParametersSet == null) {
            accessParametersSet = new HashSet();
            accessParametersSet.addAll(Arrays.asList(ExternalTableOracle.getAccessParametersChoices()));
        }
        return accessParametersSet.contains(string);
    }

    public String getAccessDriverType() {
        return this.accessDriverType;
    }

    public void setAccessDriverType(String string) {
        this.accessDriverType = string;
        this.fireDataFieldChange();
    }

    public String getAccessParametersType() {
        return this.accessParametersType;
    }

    public void setAccessParametersType(String string) {
        if (this.checkAccessParameters(string)) {
            this.accessParametersType = string;
            this.fireDataFieldChange();
        }
    }

    public DirectoryOracle getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(DirectoryOracle directoryOracle) {
        this.defaultDir = directoryOracle;
        this.fireDataFieldChange();
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle userOracle) {
        this.owner = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !"".equals(this.getOwner().getLongName())) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getOwner() != null) {
            string = this.getOwner().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public String getClobSubquery() {
        return this.clobSubquery;
    }

    public void setClobSubquery(String string) {
        this.clobSubquery = string;
        this.fireDataFieldChange();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
        this.fireDataFieldChange();
    }

    public String getOpaqueFormatSpec() {
        return this.opaqueFormatSpec;
    }

    public void setOpaqueFormatSpec(String string) {
        this.opaqueFormatSpec = string;
        this.fireDataFieldChange();
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkParallel(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public int getParallelNum() {
        return this.parallelNum;
    }

    public void setParallelNum(int n) {
        this.parallelNum = n;
        this.fireDataFieldChange();
    }

    public String getRejectLimit() {
        return this.rejectLimit;
    }

    public void setRejectLimit(String string) {
        if (string != null) {
            this.rejectLimit = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("EXTERNAL_TABLE_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.cols != null) {
            this.cols.removeAll();
        }
    }
}

