/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ExternalTableColumnOracle
extends AbstractStorageObjectOracle {
    public static final String[] UNITS = new String[]{"", "BYTE", "CHAR"};
    protected ExternalTableOracle externalTable;
    protected String datatype = "UNKNOWN";
    protected int size = 0;
    protected int precision = 0;
    protected int scale = 0;
    protected String units = "";
    public static final String TYPE_NAME = "ExternalTableColumn";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ExternCol";
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String string) {
        if (!this.datatype.equals(string)) {
            this.datatype = string;
            if (!this.isSizeAllowed(string)) {
                this.size = 0;
            }
            if (!this.isUnitsAllowed(string)) {
                this.units = "";
            }
            if (!this.isPrecisionAllowed(string)) {
                this.precision = 0;
            }
            if (!this.isScaleAllowed(string)) {
                this.scale = 0;
            }
            this.fireDataFieldChange();
        }
    }

    public ExternalTableOracle getExternalTable() {
        return this.externalTable;
    }

    public void setExternalTable(ExternalTableOracle externalTableOracle) {
        this.externalTable = externalTableOracle;
        this.setPAC_Element(externalTableOracle);
        this.fireDataFieldChange();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public boolean isSizeAllowed(String string) {
        return string.contains("CHAR") || string.equals("RAW") || string.equals("UROWID");
    }

    public boolean isUnitsAllowed(String string) {
        return string.equals("CHAR") || string.equals("VARCHAR2");
    }

    public boolean isPrecisionAllowed(String string) {
        return string.startsWith("DEC") || string.equals("FLOAT") || string.startsWith("NUM") || string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL");
    }

    public boolean isScaleAllowed(String string) {
        return string.startsWith("DEC") || string.startsWith("NUM") || string.equals("INTERVAL DAY TO SECOND");
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("COLUMN_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

