/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.DataFilePropertyDialogOraclev9i;

public class DataFileOracle
extends AbstractStorageObjectOracle {
    private static final String[] SWITCH_STATES = new String[]{"UNDEFINED", "ON", "OFF"};
    protected String fileName = "";
    protected long size = 0L;
    protected String measureUnit = ConstantsOracle.UNITS_CHOICES[1];
    protected String reuse = "YES";
    protected static Set switchSet = null;
    protected String autoextend = SWITCH_STATES[0];
    protected int nextBlockSize = 1;
    protected String maxSize = "UNLIMITED";
    protected DataBaseOracle dataBase = null;
    protected TableSpaceOracle tableSpace = null;
    public static final String TYPE_NAME = "DataFile";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
        this.fireDataFieldChange();
    }

    public void setReuse(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.reuse = string;
            this.fireDataFieldChange();
        }
    }

    public String getReuse() {
        return this.reuse;
    }

    public static String[] getSwitchChoices() {
        return SWITCH_STATES;
    }

    protected boolean checkSwitch(String string) {
        if (switchSet == null) {
            switchSet = new HashSet();
            switchSet.addAll(Arrays.asList(DataFileOracle.getSwitchChoices()));
        }
        return switchSet.contains(string);
    }

    public void setMeasureUnit(String string) {
        if (ConstantsOracle.checkUnit(string)) {
            this.measureUnit = string;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public void setAutoextend(String string) {
        if (this.checkSwitch(string)) {
            this.autoextend = string;
            this.fireDataFieldChange();
        }
    }

    public String getAutoextend() {
        return this.autoextend;
    }

    public int getNextBlockSize() {
        return this.nextBlockSize;
    }

    public void setNextBlockSize(int n) {
        this.nextBlockSize = n;
        this.fireDataFieldChange();
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(String string) {
        int n = string.indexOf(46);
        if (n > -1) {
            string = string.substring(0, n);
        }
        try {
            this.maxSize = Long.parseLong(string) > 0L ? string : "UNLIMITED";
        }
        catch (Exception exception) {
            this.maxSize = "UNLIMITED";
        }
        this.fireDataFieldChange();
    }

    public static List getMeasureUnitValues() {
        return Arrays.asList(ConstantsOracle.UNITS_CHOICES);
    }

    public void setDataBase(DataBaseOracle dataBaseOracle) {
        this.dataBase = dataBaseOracle;
        if (dataBaseOracle != null) {
            this.setPAC_Element(dataBaseOracle);
            this.tableSpace = null;
        }
        this.fireDataFieldChange();
    }

    public DataBaseOracle getDataBase() {
        return this.dataBase;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        this.tableSpace = tableSpaceOracle;
        if (tableSpaceOracle != null) {
            this.setPAC_Element(tableSpaceOracle);
            this.dataBase = null;
        }
        this.fireDataFieldChange();
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataFilePropertyDialogOraclev9i dataFilePropertyDialogOraclev9i = new DataFilePropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dataFilePropertyDialogOraclev9i.show();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fireDataFieldChange();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

