/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ColumnPropertyDialogOraclev9i;

public class ColumnProxyOracle
extends ColumnProxy {
    private int position = 0;
    private String defaultValue = "";
    private String deferrable = "NO";
    public static final String IMMEDIATE = "IMMEDIATE";
    public static final String DEFERRED = "DEFERRED";
    private static final String[] INITIALLY = new String[]{"IMMEDIATE", "DEFERRED"};
    private static Set initiallySet = null;
    private String initially = INITIALLY[0];
    private String enable = "YES";
    private String validate = "YES";
    private TableProxyOracle exceptionsTable = null;
    private NotNullConstraintOracle notNullConstraintOracle = null;
    private String nncInitially = INITIALLY[0];
    private String nncDeferrable = "NO";
    private String nncEnable = "YES";
    private String nncValidate = "YES";
    private String nncRely = "NO";
    private TableProxyOracle nncExceptionsTable = null;
    private String nncName = "";
    protected String withRowId = "NO";
    protected UserOracle autoIncrementUser;
    private boolean notNullConstraintNameChanged = false;

    public ColumnProxyOracle(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyOracle(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public String getComments() {
        Column column = this.getColumn();
        return column.getComment();
    }

    public boolean getNullsAllowed() {
        Column column = this.getColumn();
        return column.getNullsAllowed();
    }

    public int getColno() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public String getCluster() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        TableProxyOracle tableProxyOracle = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
        StringTokenizer stringTokenizer = new StringTokenizer(tableProxyOracle.getClusterColumns(), ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            if (!stringTokenizer.nextToken().trim().equalsIgnoreCase(column.getObjectID())) continue;
            this.position = n;
            return tableProxyOracle.getCluster().getName();
        }
        this.position = 0;
        return "";
    }

    public TableProxyOracle getTableProxy() {
        Column column = this.getColumn();
        Table table = (Table)column.getContainer();
        return (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
    }

    public int getPositionInCluster() {
        return this.position;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        this.fireChangeNoDirty(objectChangeEvent);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogOraclev9i columnPropertyDialogOraclev9i = new ColumnPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnPropertyDialogOraclev9i.show();
        }
    }

    public void setDefaultValue(String string) {
        String string2 = this.getDefaultValue();
        if (string2 != null && !string2.equals(string)) {
            this.defaultValue = string;
            this.fireDataFieldChange();
        }
    }

    public String getDefaultValue() {
        if (this.defaultValue == null || "".equalsIgnoreCase(this.defaultValue)) {
            return this.getColumn().getDefaultValue();
        }
        return this.defaultValue;
    }

    public static String[] getInitiallyChoices() {
        return INITIALLY;
    }

    protected boolean checkInitially(String string) {
        if (initiallySet == null) {
            initiallySet = new HashSet();
            initiallySet.addAll(Arrays.asList(ColumnProxyOracle.getInitiallyChoices()));
        }
        return initiallySet.contains(string);
    }

    public void setInitially(String string) {
        if (this.checkInitially(string)) {
            this.initially = string;
            this.fireDataFieldChange();
        }
    }

    public String getInitially() {
        return this.initially;
    }

    public void setDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.deferrable = string;
            this.fireDataFieldChange();
        }
    }

    public String getDeferrable() {
        return this.deferrable;
    }

    public void setEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.enable = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnable() {
        return this.enable;
    }

    public void setValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.validate = string;
            this.fireDataFieldChange();
        }
    }

    public String getValidate() {
        return this.validate;
    }

    public TableProxyOracle getExceptionsTable() {
        return this.exceptionsTable;
    }

    public void setExceptionsTable(TableProxyOracle tableProxyOracle) {
        this.exceptionsTable = tableProxyOracle;
        this.fireDataFieldChange();
    }

    public String getWithRowId() {
        return this.withRowId;
    }

    public void setWithRowId(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.withRowId = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    public NotNullConstraintOracle getNotNullConstraintOracle() {
        return this.notNullConstraintOracle;
    }

    public void setNotNullConstraintOracle(NotNullConstraintOracle notNullConstraintOracle) {
        this.notNullConstraintOracle = notNullConstraintOracle;
        if (this.getTableProxyR() != null && notNullConstraintOracle != null) {
            this.getTableProxyR().addObject(notNullConstraintOracle);
        }
    }

    public String getNncDeferrable() {
        return this.nncDeferrable;
    }

    public void setNncDeferrable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.nncDeferrable = string;
        }
    }

    public String getNncEnable() {
        return this.nncEnable;
    }

    public void setNncEnable(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.nncEnable = string;
        }
    }

    public TableProxyOracle getNncExceptionsTable() {
        return this.nncExceptionsTable;
    }

    public void setNncExceptionsTable(TableProxyOracle tableProxyOracle) {
        this.nncExceptionsTable = tableProxyOracle;
    }

    public String getNncInitially() {
        return this.nncInitially;
    }

    public void setNncInitially(String string) {
        if (this.checkInitially(string)) {
            this.nncInitially = string;
        }
    }

    public String getNncRely() {
        return this.nncRely;
    }

    public void setNncRely(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.nncRely = string;
        }
    }

    public String getNncValidate() {
        return this.nncValidate;
    }

    public void setNncValidate(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.nncValidate = string;
        }
    }

    public String getNncName() {
        return this.nncName;
    }

    public void setNncName(String string) {
        this.nncName = string;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public UserOracle getAutoIncrementUser() {
        return this.autoIncrementUser;
    }

    public void setAutoIncrementUser(UserOracle userOracle) {
        this.autoIncrementUser = userOracle;
    }

    public boolean isNotNullConstraintNameChanged() {
        return this.notNullConstraintNameChanged;
    }

    public void setNotNullConstraintNameChanged(boolean bl) {
        this.notNullConstraintNameChanged = bl;
    }
}

