/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ClusterIndexPropertyDialogOraclev9i;

public abstract class ClusterIndexOracle
extends AbstractStorageObjectOracle {
    private UserOracle user = null;
    private ClusterOracle cluster = null;
    private TableSpaceOracle tableSpace = null;
    private String logging = "YES";
    private SegmentOracle segment = null;
    private int compress = 0;
    private String parallel = "NO";
    private String degree = "";
    private String reverse = "NO";
    private String computeStatistics = "NO";
    private String online = "NO";
    public static final String TYPE_NAME = "ClIndex";
    public static final String OLD_TYPE_NAME = "ClusterIndex";

    @Override
    public String getIDPrefix() {
        return "CI";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public UserOracle getUser() {
        return this.user;
    }

    public void setUser(UserOracle userOracle) {
        this.user = userOracle;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle clusterOracle) {
        this.cluster = clusterOracle;
        this.setPAC_Element(clusterOracle);
        this.fireDataFieldChange();
    }

    public String getClusterUser() {
        if (this.cluster != null && this.cluster.getUser() != null) {
            return this.cluster.getUser().getName();
        }
        return "";
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpaceOracle) {
        if (this.tableSpace != tableSpaceOracle) {
            this.tableSpace = tableSpaceOracle;
            this.fireDataFieldChange();
        }
    }

    public void setLogging(String string) {
        if (!this.logging.equals(string) && (ConstantsOracle.checkYesNo(string) || "".equals(string))) {
            this.logging = string;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segmentOracle) {
        this.segment = segmentOracle;
        this.fireDataFieldChange();
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int n) {
        this.compress = n;
    }

    public void setParallel(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.parallel = string;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setReverse(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.reverse = string;
            this.fireDataFieldChange();
        }
    }

    public String getReverse() {
        return this.reverse;
    }

    public void setComputeStatistics(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.computeStatistics = string;
            this.fireDataFieldChange();
        }
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setOnline(String string) {
        if (ConstantsOracle.checkYesNo(string)) {
            this.online = string;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ClusterIndexPropertyDialogOraclev9i clusterIndexPropertyDialogOraclev9i = new ClusterIndexPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            clusterIndexPropertyDialogOraclev9i.show();
        }
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String string, boolean bl) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet modelObjectSet = this.getObjectSet();
        if (modelObjectSet == null) {
            return true;
        }
        if (!bl && this.getUser() != null) {
            string = this.getUser().getLongName() + '.' + string;
        }
        return !modelObjectSet.containsLongName(this, string);
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String string) {
        if (!"".equalsIgnoreCase(string)) {
            try {
                Integer.parseInt(string);
                this.degree = string;
            }
            catch (NumberFormatException numberFormatException) {
                this.degree = "";
            }
        } else {
            this.degree = "";
        }
        this.fireDataFieldChange();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("INDEX_ICON", 16);
    }
}

