/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ClusterColumnPropertyDialogOracle;

public abstract class ClusterColumnOracle
extends AbstractStorageObjectOracle {
    private static final String[] DATA_TYPES = new String[]{"UNKNOWN", "BINARY_DOUBLE", "BINARY_FLOAT", "CHAR", "DATE", "DEC", "DECIMAL", "DOUBLE PRECISION", "FLOAT", "INT", "INTEGER", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "NCHAR", "NUMBER", "NUMERIC", "NVARCHAR2", "RAW", "REAL", "ROWID", "SMALLINT", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "UROWID", "VARCHAR", "VARCHAR2"};
    private static List dataTypesList = Arrays.asList(DATA_TYPES);
    private static Set dataTypesSet = null;
    private ClusterOracle cluster = null;
    private String dataType = DATA_TYPES[0];
    private String lengthPrecision = "";
    private int scale = 0;
    private int position = 1;
    public static final String TYPE_NAME = "ClColumn";
    public static final String OLD_TYPE_NAME = "ClusterColumn";

    @Override
    public String getIDPrefix() {
        return "CC";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle clusterOracle) {
        this.cluster = clusterOracle;
        this.setPAC_Element(clusterOracle);
        this.fireDataFieldChange();
    }

    public static String[] getDataTypesChoices() {
        return DATA_TYPES;
    }

    protected boolean checkDataType(String string) {
        if (dataTypesSet == null) {
            dataTypesSet = new HashSet();
            dataTypesSet.addAll(Arrays.asList(ClusterColumnOracle.getDataTypesChoices()));
        }
        return dataTypesSet.contains(string);
    }

    public void setDataType(String string) {
        if (!this.dataType.equals(string) && this.checkDataType(string)) {
            this.dataType = string;
            if (!this.isLengthPrecAllowed(this.dataType)) {
                this.lengthPrecision = "";
            }
            if (!this.isScaleAllowed(this.dataType)) {
                this.scale = 0;
            }
            this.fireDataFieldChange();
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getLengthPrecision() {
        return this.lengthPrecision;
    }

    public void setLengthPrecision(String string) {
        this.lengthPrecision = string;
        this.fireDataFieldChange();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public boolean isLengthPrecAllowed(String string) {
        return string.contains("CHAR") || string.equals("RAW") || string.equals("UROWID") || string.startsWith("DEC") || string.equals("FLOAT") || string.startsWith("NUM") || string.startsWith("TIMESTAMP") || string.startsWith("INTERVAL");
    }

    public boolean isScaleAllowed(String string) {
        return string.startsWith("DEC") || string.startsWith("NUM") || string.equals("INTERVAL DAY TO SECOND");
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public static List getDataTypesValues() {
        return dataTypesList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ClusterColumnPropertyDialogOracle clusterColumnPropertyDialogOracle = new ClusterColumnPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            clusterColumnPropertyDialogOracle.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("COLUMN_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

