/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;

public class TableProxySetDB2v80
extends TableProxySetDB2 {
    public TableProxySetDB2v80(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public RelationalObjectProxy createProxy(DesignObject designObject) {
        StorageObject storageObject;
        String string;
        TableProxyDB2v80 tableProxyDB2v80 = new TableProxyDB2v80((Table)designObject, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            string = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            storageObject = null;
            if (string != null) {
                storageObject = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(string);
            }
            if (storageObject != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpaceDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                tableProxyDB2v80.setTableSpace(tableSpaceDB2);
                tableSpaceDB2.setDataBase((DataBaseDB2)storageObject);
                String string2 = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
                String string3 = ApplyNamingStandards.createTableSpaceDB2_Name(designObject.getName(), string2, designObject.getDesignPart().getName());
                tableSpaceDB2.setName(string3);
                if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace() && tableSpaceDB2.getStorageTemplate() != null) {
                    tableSpaceDB2.synchronizeStorageTemplateName();
                }
            }
        }
        if (!((string = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(string.trim()) || "[Implicit]".equalsIgnoreCase(string.trim()) || "PUBLIC".equalsIgnoreCase(string.trim()))) {
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(string) == null) {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                storageObject.setName(string);
            } else {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(string);
            }
            tableProxyDB2v80.setOwner((Owner)storageObject);
        }
        return tableProxyDB2v80;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        StorageObject storageObject;
        String string3;
        TableProxyDB2v80 tableProxyDB2v80 = new TableProxyDB2v80(design, string, string2, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            string3 = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            storageObject = null;
            if (string3 != null) {
                storageObject = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(string3);
            }
            if (storageObject != null && this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) {
                TableSpaceDB2 tableSpaceDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                tableProxyDB2v80.setTableSpace(tableSpaceDB2);
                tableSpaceDB2.setDataBase((DataBaseDB2)storageObject);
            }
        }
        if ((string3 = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) != null && !"".equalsIgnoreCase(string3.trim()) && !"[Implicit]".equalsIgnoreCase(string3.trim())) {
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(string3) == null) {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                storageObject.setName(string3);
            } else {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(string3);
            }
            tableProxyDB2v80.setOwner((Owner)storageObject);
        }
        return tableProxyDB2v80;
    }

    @Override
    public void doAfterAdd(RelationalObjectProxy relationalObjectProxy) {
        TableProxyDB2v80 tableProxyDB2v80 = (TableProxyDB2v80)relationalObjectProxy;
        Table table = (Table)tableProxyDB2v80.getObject();
        if (!table.isBeingRecreated() && this.getDesign().getDLSettings().getClassificationTypeNameByID(table.getTypeID()).equals(ContainerObject.TYPE_SUMMARY)) {
            tableProxyDB2v80.setMaterializedQuery(TableProxyDB2v80.YES_NO_STATES[0]);
        }
    }
}

