/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.IndexProxyDB2v80;

public class IndexProxySetDB2v80
extends IndexProxySet
implements Constants {
    public IndexProxySetDB2v80(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        StorageObject storageObject;
        Object object;
        IndexProxyDB2v80 indexProxyDB2v80 = new IndexProxyDB2v80((Index)designObject, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading() && !this.getStorageDesign().getDesign().getAppView().isImporting()) {
            if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                object = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                indexProxyDB2v80.setStorageTemplate((StorageTemplateDB2)object);
                indexProxyDB2v80.synchronizeStorageTemplateName();
            } else if (this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() && (object = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) != null && !"".equalsIgnoreCase((String)object)) {
                storageObject = (StorageTemplateDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().getByName((String)object);
                if (storageObject == null) {
                    storageObject = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                    storageObject.setName((String)object);
                }
                if (storageObject != null) {
                    indexProxyDB2v80.setStorageTemplate((StorageTemplateDB2)storageObject);
                }
            }
        }
        if (!((object = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(((String)object).trim()) || "[Implicit]".equalsIgnoreCase(((String)object).trim()) || "PUBLIC".equalsIgnoreCase(((String)object).trim()))) {
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName((String)object) == null) {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                storageObject.setName((String)object);
            } else {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName((String)object);
            }
            indexProxyDB2v80.setOwner((Owner)storageObject);
        }
        return indexProxyDB2v80;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        StorageObject storageObject;
        Object object;
        IndexProxyDB2v80 indexProxyDB2v80 = new IndexProxyDB2v80(design, string, string2, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                object = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                indexProxyDB2v80.setStorageTemplate((StorageTemplateDB2)object);
                indexProxyDB2v80.synchronizeStorageTemplateName();
            } else if (this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() && (object = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) != null && !"".equalsIgnoreCase((String)object)) {
                storageObject = (StorageTemplateDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().getByName((String)object);
                if (storageObject == null) {
                    storageObject = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                    storageObject.setName((String)object);
                }
                if (storageObject != null) {
                    indexProxyDB2v80.setStorageTemplate((StorageTemplateDB2)storageObject);
                }
            }
        }
        if (!((object = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(((String)object).trim()) || "[Implicit]".equalsIgnoreCase(((String)object).trim()) || "PUBLIC".equalsIgnoreCase(((String)object).trim()))) {
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName((String)object) == null) {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                storageObject.setName((String)object);
            } else {
                storageObject = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName((String)object);
            }
            indexProxyDB2v80.setOwner((Owner)storageObject);
        }
        return indexProxyDB2v80;
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && !((KeyObject)designObject).isFK()) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            try {
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in IndexProxySetDB2v80.add");
            }
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (index.isFK()) continue;
            this.add(index);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (!index2.isFK()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }
}

