/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.IndexPropertyDialogDB2v80;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyDB2v80
extends IndexProxyDB2 {
    protected String clustered = YES_NO_STATES[1];
    protected String partitioned = YES_NO_STATES[1];
    protected String padded = YES_NO_STATES[1];
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public IndexProxyDB2v80(Index index, StorageDesign storageDesign) {
        super(index, storageDesign, false);
    }

    public IndexProxyDB2v80(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign, false);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogDB2v80 indexPropertyDialogDB2v80 = new IndexPropertyDialogDB2v80(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogDB2v80.show();
        }
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    public String getClusteredDB2() {
        return this.clustered;
    }

    public void setClusteredDB2(String string) {
        if (this.checkYesNo(string)) {
            this.clustered = string;
            this.fireDataFieldChange();
        }
    }

    public String getPadded() {
        return this.padded;
    }

    public void setPadded(String string) {
        if (this.checkYesNo(string)) {
            this.padded = string;
            this.fireDataFieldChange();
        }
    }

    public String getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(String string) {
        if (this.checkYesNo(string)) {
            this.partitioned = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("Where Not Null", this, "isWhereNotNull", "setWhereNotNull", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Clustered", this, "getClustered", "setClustered", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Piece Size", this, "getPieceSize", "setPieceSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Defer", this, "isDefer", "setDefer", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Copy", this, "isCopy", "setCopy", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Padded", this, "getPadded", "setPadded", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Index index = (Index)storageDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyDB2v80 indexProxyDB2v80 = null;
        RelationalObjectProxy relationalObjectProxy = ((StorageDesignDB2v80)storageDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (relationalObjectProxy != null && !this.isRawObject()) {
            indexProxyDB2v80 = (IndexProxyDB2v80)relationalObjectProxy;
        }
        if (indexProxyDB2v80 != null) {
            StorageObject storageObject;
            indexProxyDB2v80.setName(this.getName());
            for (int i = 0; i < this.getPartitions().length; ++i) {
                storageObject = this.getPartitions()[i];
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)((StorageDesignDB2v80)storageDesign).getIndexPartitionSet().getByName(storageObject.getName());
                if (indexPartitionDB2 == null) {
                    IndexPartitionDB2 indexPartitionDB22 = ((StorageDesignDB2v80)storageDesign).getIndexPartitionSet().createIndexPartition();
                    indexPartitionDB22.setName(storageObject.getName());
                    indexPartitionDB22.setRawObject(true);
                    indexPartitionDB22.setIndex(indexProxyDB2v80);
                    ((StorageDesignDB2v80)storageDesign).getIndexPartitionSet().add(indexPartitionDB22);
                    continue;
                }
                indexPartitionDB2.setIndex(indexProxyDB2v80);
                ((StorageDesignDB2v80)storageDesign).getIndexPartitionSet().add(indexPartitionDB2);
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v80)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    storageObject = (Owner)((StorageDesignDB2v80)storageDesign).getOwnerSet().createElement(null);
                    storageObject.setName(this.getOwner().getName());
                    storageObject.setRawObject(true);
                    indexProxyDB2v80.setOwner((Owner)storageObject);
                } else {
                    indexProxyDB2v80.setOwner(owner);
                }
            }
            indexProxyDB2v80.setWhereNotNull(this.isWhereNotNull());
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 storageTemplateDB2 = (StorageTemplateDB2)((StorageDesignDB2v80)storageDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (storageTemplateDB2 == null) {
                    storageObject = ((StorageDesignDB2v80)storageDesign).getStorageTemplateSet().createStorageTemplate();
                    storageObject.setName(this.getStorageTemplate().getName());
                    storageObject.setRawObject(true);
                    indexProxyDB2v80.setStorageTemplate((StorageTemplateDB2)storageObject);
                } else {
                    indexProxyDB2v80.setStorageTemplate(storageTemplateDB2);
                }
            }
            indexProxyDB2v80.setClusterType(this.getClusterType());
            indexProxyDB2v80.setPartitioned(this.isPartitioned());
            indexProxyDB2v80.setPieceSize(this.getPieceSize());
            if (this.getBufferPool() != null) {
                BufferPoolDB2 bufferPoolDB2 = (BufferPoolDB2)((StorageDesignDB2v80)storageDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (bufferPoolDB2 == null) {
                    storageObject = (BufferPoolDB2)((StorageDesignDB2v80)storageDesign).getBufferPoolSet().createElement(null);
                    storageObject.setName(this.getBufferPool().getName());
                    storageObject.setRawObject(true);
                    indexProxyDB2v80.setBufferPool((BufferPoolDB2)storageObject);
                } else {
                    indexProxyDB2v80.setBufferPool(bufferPoolDB2);
                }
            }
            indexProxyDB2v80.setClose(this.isClose());
            indexProxyDB2v80.setDefer(this.isDefer());
            indexProxyDB2v80.setCopy(this.isCopy());
            indexProxyDB2v80.setPadded(this.getPadded());
            indexProxyDB2v80.setComment(this.getComment());
            indexProxyDB2v80.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxyDB2v80.setRawObject(false);
        }
    }
}

