/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v80;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;

public class ColumnIdentityDB2v80
extends ColumnIdentityDB2 {
    private static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    protected String order = YES_NO_STATES[1];

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(string);
    }

    public String getOrder() {
        if (this.column != null && !((ColumnProxyDB2v80)this.column).isOrderChanged()) {
            boolean bl = this.column.getColumn().isAutoIncrementOrder();
            return bl ? YES_NO_STATES[0] : YES_NO_STATES[1];
        }
        return this.order;
    }

    public void setOrder(String string) {
        if (this.checkYesNo(string)) {
            this.order = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ColumnIdentityDB2v80 columnIdentityDB2v80 = null;
        StorageObject storageObject = (StorageObject)((StorageDesignDB2v80)storageDesign).getColumnIdentitySet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                columnIdentityDB2v80 = (ColumnIdentityDB2v80)storageObject;
            }
        } else {
            columnIdentityDB2v80 = (ColumnIdentityDB2v80)((StorageDesignDB2v80)storageDesign).getColumnIdentitySet().createColumnIdentity();
        }
        if (columnIdentityDB2v80 != null) {
            columnIdentityDB2v80.setName(this.getName());
            columnIdentityDB2v80.setGenerate(this.getGenerate());
            columnIdentityDB2v80.setStartWith(this.getStartWith());
            columnIdentityDB2v80.setIncrementBy(this.getIncrementBy());
            columnIdentityDB2v80.setCache(this.getCache());
            columnIdentityDB2v80.setCycle(this.isCycle());
            columnIdentityDB2v80.setMinValue(this.getMinValue());
            columnIdentityDB2v80.setMaxValue(this.getMaxValue());
            columnIdentityDB2v80.setOrder(this.getOrder());
            columnIdentityDB2v80.setRawObject(false);
        }
    }
}

