/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class VisibleTablesCollection
extends StorageObjectCollection
implements RelationalObjectProxySetListener,
StorageObjectListener,
ObjectListener {
    AbstractStorageDesignDB2 storageDesign = null;

    public VisibleTablesCollection(AbstractStorageDesignDB2 abstractStorageDesignDB2) {
        this.storageDesign = abstractStorageDesignDB2;
        this.registerToTableProxyFromDesign(abstractStorageDesignDB2.getTableProxySet());
        abstractStorageDesignDB2.getTableProxySet().addSetListener(this);
        this.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16));
    }

    public StorageObject[] getElements() {
        Object[] objectArray = this.getElementsList().toArray();
        StorageObject[] storageObjectArray = new StorageObject[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            storageObjectArray[i] = (StorageObject)objectArray[i];
        }
        return storageObjectArray;
    }

    private void registerToTableProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            tableProxyDB2.addObjectListener(this);
            Table table = (Table)tableProxyDB2.getObject();
            table.addObjectListener(this);
            if (table.getTypeSubstitution() != null) continue;
            tableProxyDB2.setParent(this);
            this.add(tableProxyDB2);
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        TableProxyDB2 tableProxyDB2;
        Table table;
        if (modelObjectSetEvent.isType(1)) {
            TableProxyDB2 tableProxyDB22;
            Table table2;
            if (modelObjectSetEvent.getAffected() instanceof TableProxy && (table2 = (Table)(tableProxyDB22 = (TableProxyDB2)modelObjectSetEvent.getAffected()).getObject()).getTypeSubstitution() == null) {
                tableProxyDB22.addObjectListener(this);
                tableProxyDB22.setParent(this);
                this.add(tableProxyDB22);
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof TableProxy && (table = (Table)(tableProxyDB2 = (TableProxyDB2)modelObjectSetEvent.getAffected()).getObject()).getTypeSubstitution() == null) {
            tableProxyDB2.removeObjectListener(this);
            this.remove(tableProxyDB2);
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        TableProxyDB2 tableProxyDB2;
        Table table;
        if (objectChangeEvent.getAffected() instanceof TableProxy && (table = (Table)(tableProxyDB2 = (TableProxyDB2)objectChangeEvent.getAffected()).getObject()).getTypeSubstitution() == null) {
            tableProxyDB2.setParent(this);
            this.add(tableProxyDB2);
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.isType(ObjectChangeEvent.ROOT_CHANGED) && designObject instanceof Table && this.storageDesign.getProxy(designObject) != null) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)this.storageDesign.getProxy(designObject);
            if (((Table)designObject).getTypeSubstitution() == null) {
                tableProxyDB2.addObjectListener(this);
                this.add(tableProxyDB2);
            } else {
                tableProxyDB2.removeObjectListener(this);
                this.remove(tableProxyDB2);
            }
        }
    }
}

