/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.VCatPropertyDialogDB2;

public class VCatDB2
extends AbstractStorageObjectDB2
implements ModelObjectSetListener,
StorageObjectListener {
    private StorageObjectCollection storageGroups;
    public static final String TYPE_NAME = "VCat";

    public VCatDB2(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.storageGroups = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet());
        this.storageGroups.setParent(this);
        this.storageGroups.setName(Messages.getString("VCatDB2.StorageGroups"));
        this.storageGroups.setClassForParent(VCatDB2.class);
        this.storageGroups.setSetMethod("setVCat");
        this.storageGroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().addSetListener(this);
        this.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet());
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof StorageGroupDB2) {
            StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)objectChangeEvent.getAffected();
            if (storageGroupDB2.getVCat() != null && storageGroupDB2.getVCat() == this) {
                storageGroupDB2.setParent(this.storageGroups);
                this.storageGroups.add(storageGroupDB2);
            } else {
                this.storageGroups.remove(storageGroupDB2);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof StorageGroupDB2) {
                StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)modelObjectSetEvent.getAffected();
                storageGroupDB2.addObjectListener(this);
                if (storageGroupDB2.getVCat() != null && storageGroupDB2.getVCat() == this) {
                    storageGroupDB2.setParent(this.storageGroups);
                    this.storageGroups.add(storageGroupDB2);
                } else {
                    this.storageGroups.remove(storageGroupDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof StorageGroupDB2) {
            StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)modelObjectSetEvent.getAffected();
            this.storageGroups.remove(storageGroupDB2);
            storageGroupDB2.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.storageGroups;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.storageGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.storageGroups) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.storageGroups.removeAll();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "VCAT";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            VCatPropertyDialogDB2 vCatPropertyDialogDB2 = new VCatPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            vCatPropertyDialogDB2.show();
        }
    }

    private void addStorageGroupsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)iterator.next();
            if (storageGroupDB2.getVCat() != null && storageGroupDB2.getVCat() == this) {
                storageGroupDB2.setParent(this.storageGroups);
                this.storageGroups.add(storageGroupDB2);
                continue;
            }
            this.storageGroups.remove(storageGroupDB2);
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        VCatDB2 vCatDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getVCatSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                vCatDB2 = (VCatDB2)storageObject;
            }
        } else {
            vCatDB2 = ((AbstractStorageDesignDB2)storageDesign).getVCatSet().createVCat();
        }
        if (vCatDB2 != null) {
            vCatDB2.setName(this.getName());
            Iterator iterator = this.storageGroups.iterator();
            while (iterator.hasNext()) {
                StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)iterator.next();
                StorageGroupDB2 storageGroupDB22 = (StorageGroupDB2)((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().getByName(storageGroupDB2.getName());
                if (storageGroupDB22 == null) {
                    StorageGroupDB2 storageGroupDB23 = ((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().createStorageGroup();
                    storageGroupDB23.setName(storageGroupDB2.getName());
                    storageGroupDB23.setVCat(vCatDB2);
                    storageGroupDB23.setRawObject(true);
                    vCatDB2.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet());
                    continue;
                }
                storageGroupDB22.setVCat(vCatDB2);
                vCatDB2.addStorageGroupsFromDesign(((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet());
            }
            vCatDB2.setComment(this.getComment());
            vCatDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CATALOG_ICON", 16);
    }
}

