/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.TablePropertyDialogDB2;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxyDB2
extends TableProxy
implements OwnedObject,
ModelObjectSetListener,
PropertiesPropagator {
    protected static final String[] CCSID = new String[]{"", "ASCII", "EBCDIC", "UNICODE"};
    protected static final String[] AUDIT_CHOICES = new String[]{"NONE", "CHANGES", "ALL"};
    protected static final String[] DATA_CAPTURE_VALUES = new String[]{"NONE", "CHANGES"};
    public static final StorageEvent PRIMARY_QTY_CHANGED = new StorageEvent("Primary quantity changed");
    protected OwnedObjectImpl ownedObjectImpl;
    protected String label = "";
    protected long initialRowNumber = 0L;
    protected long maxRowNumber = 0L;
    protected boolean initialRowNumberChanged = false;
    protected boolean maxRowNumberChanged = false;
    protected boolean freepageExcluded = false;
    protected float annualUpdateRateInsert = 0.0f;
    protected float annualUpdateRateDelete = 0.0f;
    protected float annualUpdateRateNetGrowth = 0.0f;
    protected float activeGroupInsert = 0.0f;
    protected float activeGroupDelete = 0.0f;
    protected float activeGroupData = 0.0f;
    protected int growthHorizon = 0;
    protected static String[] growthMethodChoices = new String[]{"Random", "Refresh", "Resume"};
    protected String growthMethod = growthMethodChoices[0];
    protected long numberOfRows = -1L;
    protected int recordLength = -1;
    protected int numberOfPages = -1;
    protected int percentageOfPages = -1;
    protected int primaryQuantity;
    protected int secondaryQuantity;
    protected boolean calculatePrimaryQuantity = true;
    protected boolean calculateSecondaryQuantity = true;
    protected String audit = AUDIT_CHOICES[0];
    protected boolean dataCapture = false;
    protected boolean dropRestrict = false;
    protected String createdBy = "";
    protected int obid = 0;
    protected boolean excludeFreepage = false;
    protected String editProc = "";
    protected String validProc = "";
    protected String ccsid = CCSID[0];
    protected TableSpaceDB2 tableSpace = null;
    public static final String IMINSERT = "SQL Insert";
    public static final String IMLOAD = "Load/Reorg";
    protected static String[] insertMethodChoices = new String[]{"SQL Insert", "Load/Reorg"};
    protected String insertMethod = "SQL Insert";
    protected int pctFilling = 66;
    protected boolean usePCTFilling = false;
    private List propertyWrapperList = null;
    protected StorageObjectCollection tablePartitions;
    protected static Logger LOGGER = new Logger(TableProxyDB2.class);
    protected StorageObjectCollection triggers;
    protected StorageObjectCollection synonyms;
    protected StorageObjectCollection instDescriptorCols;
    int numbChildren = 4;

    public TableProxyDB2(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        if (table.getTypeSubstitution() == null) {
            this.addColumnsFromSuccessor(table);
        }
        this.triggers = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        this.triggers.setClassForParent(TableProxyDB2.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableProxyDB2.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.instDescriptorCols = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet());
        ((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
    }

    public TableProxyDB2(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        Table table = (Table)this.getObject();
        if (table.getTypeSubstitution() == null) {
            this.addColumnsFromSuccessor(table);
        }
        this.triggers = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        this.triggers.setClassForParent(TableProxyDB2.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((AbstractStorageDesignDB2)storageDesign).getTriggerSet());
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("TableViewProxyDB2.Synonyms"));
        this.synonyms.setClassForParent(TableProxyDB2.class);
        this.synonyms.setSetMethod("setTable");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storageDesign).getSynonymSet());
        this.instDescriptorCols = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet());
        ((AbstractStorageDesignDB2)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
    }

    private void addColumnsFromSuccessor(Table table) {
        for (Column column : table.getAllNestedElements()) {
            ColumnProxy columnProxy;
            if (!column.isAtomic() || (columnProxy = (ColumnProxy)this.getStorageDesign().getProxy(column)) == null) continue;
            columnProxy.setParent(this.columns);
            this.columns.add(columnProxy);
            columnProxy.setName(column.getName());
        }
    }

    @Override
    public int getNumberOfChildren() {
        return this.numbChildren;
    }

    @Override
    public ModelObject getChild(int n) {
        if (n == this.numbChildren - 1) {
            return this.triggers;
        }
        if (n == this.numbChildren - 2) {
            return this.synonyms;
        }
        return super.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.triggers) {
            return this.numbChildren - 1;
        }
        if (modelObject == this.synonyms) {
            return this.numbChildren - 2;
        }
        return super.getIndexForChild(modelObject);
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.triggers) {
            return this.numbChildren - 1;
        }
        if (object == this.synonyms) {
            return this.numbChildren - 2;
        }
        return super.getIndexForChild(object);
    }

    protected void addTriggersFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            TriggerDB2 triggerDB2 = (TriggerDB2)iterator.next();
            triggerDB2.addObjectListener(this);
            if (triggerDB2.getTable() != null && triggerDB2.getTable() == this) {
                triggerDB2.setParent(this.triggers);
                this.triggers.add(triggerDB2);
                continue;
            }
            this.triggers.remove(triggerDB2);
        }
    }

    private void addSynonymsFromDesign(StorageObjectSet storageObjectSet) {
        Iterator iterator = storageObjectSet.iterator();
        while (iterator.hasNext()) {
            SynonymDB2 synonymDB2 = (SynonymDB2)iterator.next();
            if (synonymDB2.getTable() != null && synonymDB2.getTable() == this) {
                synonymDB2.setParent(this.synonyms);
                this.synonyms.add(synonymDB2);
                continue;
            }
            this.synonyms.remove(synonymDB2);
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.synchronizeTableSpaceName();
        }
    }

    public void synchronizeTableSpaceName() {
        TableSpaceDB2 tableSpaceDB2;
        if (this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable() && (tableSpaceDB2 = this.getTableSpace()) != null && !tableSpaceDB2.isUsedInOtherDefinitions(this)) {
            String string = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
            String string2 = ApplyNamingStandards.createTableSpaceDB2_Name(this.getObject().getName(), string, this.getObject().getDesignPart().getName());
            tableSpaceDB2.setName(string2);
            tableSpaceDB2.synchronizeStorageTemplateName();
        }
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)modelObjectSetEvent.getAffected();
                if (((Table)this.getObject()).getTypeSubstitution() == null && ((Table)this.getObject()).getAllNestedElements().contains(columnProxy.getObject())) {
                    columnProxy.setParent(this.columns);
                    this.columns.add(modelObjectSetEvent.getAffected());
                    columnProxy.setPAC_Element(this);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                if (this.getObject() == ((Index)indexProxy.getObject()).getContainerWithKeyObject()) {
                    indexProxy.addObjectListener(this);
                    if (!this.indexes.contains(indexProxy)) {
                        this.addIndexProxyWithoutCheck(indexProxy);
                    }
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)modelObjectSetEvent.getAffected()).getObject().getObjectID());
            } else if (modelObjectSetEvent.getAffected() instanceof IndexProxy) {
                IndexProxy indexProxy = (IndexProxy)modelObjectSetEvent.getAffected();
                indexProxy.removeObjectListener(this);
                if (this.indexes.contains(indexProxy)) {
                    this.indexes.remove(modelObjectSetEvent.getAffected());
                }
                if (this.integrityIndexes.contains(indexProxy)) {
                    this.integrityIndexes.remove(modelObjectSetEvent.getAffected());
                }
            }
        }
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof TriggerDB2) {
            TriggerDB2 triggerDB2 = (TriggerDB2)objectChangeEvent.getAffected();
            if (triggerDB2.getTable() != null && triggerDB2.getTable() == this) {
                triggerDB2.setParent(this.triggers);
                this.triggers.add(triggerDB2);
            } else {
                this.triggers.remove(triggerDB2);
            }
        } else if (objectChangeEvent.getAffected() instanceof SynonymDB2) {
            SynonymDB2 synonymDB2 = (SynonymDB2)objectChangeEvent.getAffected();
            if (synonymDB2.getTable() != null && synonymDB2.getTable() == this) {
                synonymDB2.setParent(this.synonyms);
                synonymDB2.setPAC_Element(this);
                this.synonyms.add(synonymDB2);
            } else {
                this.synonyms.remove(synonymDB2);
            }
        } else if (objectChangeEvent.getAffected() instanceof InstanceDescriptorColumnDB2) {
            InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)objectChangeEvent.getAffected();
            if (instanceDescriptorColumnDB2.getTable() != null && instanceDescriptorColumnDB2.getTable() == this) {
                instanceDescriptorColumnDB2.setParent(this.instDescriptorCols);
                instanceDescriptorColumnDB2.setPAC_Element(this);
                this.instDescriptorCols.add(instanceDescriptorColumnDB2);
            } else {
                this.instDescriptorCols.remove(instanceDescriptorColumnDB2);
            }
        } else if (objectChangeEvent.getAffected() instanceof IndexProxyDB2) {
            IndexProxyDB2 indexProxyDB2 = (IndexProxyDB2)objectChangeEvent.getAffected();
            if (this.getObject() == ((Index)indexProxyDB2.getObject()).getContainerWithKeyObject() && indexProxyDB2.getOldStatusGroup() != indexProxyDB2.getStatusGroup()) {
                int n = indexProxyDB2.getOldStatusGroup();
                if (1 == n) {
                    this.integrityIndexes.justRemove(indexProxyDB2);
                } else {
                    this.indexes.justRemove(indexProxyDB2);
                }
                this.addIndexProxyWithoutCheck(indexProxyDB2);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        if (modelObjectSetEvent.isType(1)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerDB2) {
                TriggerDB2 triggerDB2 = (TriggerDB2)modelObjectSetEvent.getAffected();
                triggerDB2.addObjectListener(this);
                if (triggerDB2.getTable() != null && triggerDB2.getTable() == this) {
                    triggerDB2.setParent(this.triggers);
                    this.triggers.add(triggerDB2);
                } else {
                    this.triggers.remove(triggerDB2);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                synonymDB2.addObjectListener(this);
                if (synonymDB2.getTable() != null && synonymDB2.getTable() == this) {
                    synonymDB2.setParent(this.synonyms);
                    synonymDB2.setPAC_Element(this);
                    this.synonyms.add(synonymDB2);
                } else {
                    this.synonyms.remove(synonymDB2);
                }
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)modelObjectSetEvent.getAffected();
                instanceDescriptorColumnDB2.addObjectListener(this);
                if (instanceDescriptorColumnDB2.getTable() != null && instanceDescriptorColumnDB2.getTable() == this) {
                    instanceDescriptorColumnDB2.setParent(this.instDescriptorCols);
                    instanceDescriptorColumnDB2.setPAC_Element(this);
                    this.instDescriptorCols.add(instanceDescriptorColumnDB2);
                } else {
                    this.instDescriptorCols.remove(instanceDescriptorColumnDB2);
                }
            }
        } else if (modelObjectSetEvent.isType(0)) {
            if (modelObjectSetEvent.getAffected() instanceof TriggerDB2) {
                TriggerDB2 triggerDB2 = (TriggerDB2)modelObjectSetEvent.getAffected();
                this.triggers.remove(triggerDB2);
                triggerDB2.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof SynonymDB2) {
                SynonymDB2 synonymDB2 = (SynonymDB2)modelObjectSetEvent.getAffected();
                this.synonyms.remove(synonymDB2);
                synonymDB2.removeObjectListener(this);
            } else if (modelObjectSetEvent.getAffected() instanceof InstanceDescriptorColumnDB2) {
                InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)modelObjectSetEvent.getAffected();
                this.instDescriptorCols.remove(instanceDescriptorColumnDB2);
                instanceDescriptorColumnDB2.removeObjectListener(this);
            }
        }
    }

    public void setPrimaryQuantity(int n) {
        this.primaryQuantity = n;
        this.fireUpdate();
        PRIMARY_QTY_CHANGED.setAffected(this);
        this.fireChange(PRIMARY_QTY_CHANGED);
    }

    public int getPrimaryQuantity() {
        return this.primaryQuantity;
    }

    public void setSecondaryQuantity(int n) {
        this.secondaryQuantity = n;
        this.fireDataFieldChange();
    }

    public int getSecondaryQuantity() {
        return this.secondaryQuantity;
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    public void setLabel(String string) {
        this.label = string;
        this.fireDataFieldChange();
    }

    public String getLabel() {
        return this.label;
    }

    public boolean checkMaxRowNumber(long l) {
        return l >= 1L && l <= 0xFFFFFFFEL;
    }

    public void setMaxRowNumber(long l) {
        if (this.checkMaxRowNumber(l)) {
            this.maxRowNumber = l;
            this.maxRowNumberChanged = true;
            this.fireDataFieldChange();
        }
    }

    public long getMaxRowNumber() {
        if (!this.getMaxRowNumberChanged()) {
            return Long.parseLong(((Table)this.getObject()).getMaxVolumes());
        }
        return this.maxRowNumber;
    }

    public int getPctfree() {
        return (int)(1L - this.getInitialRowNumber() / this.getMaxRowNumber() * 100L);
    }

    public void setFreepageExcluded(boolean bl) {
        this.freepageExcluded = bl;
        this.fireDataFieldChange();
    }

    public boolean getFreepageExcluded() {
        return this.freepageExcluded;
    }

    public boolean checkAnnualUpdateRateGroup(float f) {
        return f >= 0.0f && f <= 10000.0f;
    }

    public void setAnnualUpdateRateInsert(float f) {
        if (this.checkAnnualUpdateRateGroup(f)) {
            this.annualUpdateRateInsert = f;
            this.setAnnualUpdateRateNetGrowth();
            this.fireDataFieldChange();
        }
    }

    public float getAnnualUpdateRateInsert() {
        return this.annualUpdateRateInsert;
    }

    public void setAnnualUpdateRateDelete(float f) {
        if (this.checkAnnualUpdateRateGroup(f)) {
            this.annualUpdateRateDelete = f;
            this.setAnnualUpdateRateNetGrowth();
            this.fireDataFieldChange();
        }
    }

    public float getAnnualUpdateRateDelete() {
        return this.annualUpdateRateDelete;
    }

    private void setAnnualUpdateRateNetGrowth() {
        this.annualUpdateRateNetGrowth = this.getAnnualUpdateRateInsert() - this.getAnnualUpdateRateDelete();
        this.fireDataFieldChange();
    }

    public float getAnnualUpdateRateNetGrowth() {
        return this.annualUpdateRateNetGrowth;
    }

    public boolean checkActiveGroup(float f) {
        return f >= 0.0f && f <= 100.0f;
    }

    public void setActiveGroupInsert(float f) {
        if (this.checkActiveGroup(f)) {
            this.activeGroupInsert = f;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupInsert() {
        return this.activeGroupInsert;
    }

    public void setActiveGroupDelete(float f) {
        if (this.checkActiveGroup(f)) {
            this.activeGroupDelete = f;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupDelete() {
        return this.activeGroupDelete;
    }

    public void setActiveGroupData(float f) {
        if (this.checkActiveGroup(f)) {
            this.activeGroupData = f;
            this.fireDataFieldChange();
        }
    }

    public float getActiveGroupData() {
        return this.activeGroupData;
    }

    public boolean checkGrowthHorizon(int n) {
        return n >= 0 && n <= 999999;
    }

    public void setGrowthHorizon(int n) {
        if (this.checkGrowthHorizon(n)) {
            this.growthHorizon = n;
            this.fireDataFieldChange();
        }
    }

    public int getGrowthHorizon() {
        return this.growthHorizon;
    }

    public void setGrowthMethod(String string) {
        this.growthMethod = string;
        this.fireDataFieldChange();
    }

    public String getGrowthMethod() {
        return this.growthMethod;
    }

    public void setNumberOfRows(long l) {
        this.numberOfRows = l;
        this.fireDataFieldChange();
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public boolean checkInitialRowNumber(long l) {
        return l >= 1L && l <= 0xFFFFFFFEL;
    }

    public void setInitialRowNumber(long l) {
        if (this.getMaxRowNumber() < l) {
            this.setMaxRowNumber(l);
        }
        if (this.checkInitialRowNumber(l)) {
            this.initialRowNumber = l;
            this.initialRowNumberChanged = true;
            this.fireDataFieldChange();
        }
    }

    public long getInitialRowNumber() {
        if (!this.getInitialRowNumberChanged()) {
            return Long.parseLong(((Table)this.getObject()).getMinVolumes());
        }
        return this.initialRowNumber;
    }

    public boolean getInitialRowNumberChanged() {
        return this.initialRowNumberChanged;
    }

    public void setInitialRowNumberChanged(boolean bl) {
        this.initialRowNumberChanged = bl;
    }

    public boolean getMaxRowNumberChanged() {
        return this.maxRowNumberChanged;
    }

    public void setMaxRowNumberChanged(boolean bl) {
        this.maxRowNumberChanged = bl;
    }

    public void setRecordLength(int n) {
        this.recordLength = n >= 0 ? n : 0;
        this.fireDataFieldChange();
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setNumberOfPages(int n) {
        this.numberOfPages = n >= 0 ? n : 0;
        this.fireDataFieldChange();
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setPercentageOfPages(int n) {
        this.percentageOfPages = n >= 0 ? n : 0;
        this.fireDataFieldChange();
    }

    public int getPercentageOfPages() {
        return this.percentageOfPages;
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.calculatePrimaryQuantity;
    }

    public void setCalculatePrimaryQuantity(boolean bl) {
        this.calculatePrimaryQuantity = bl;
        this.fireDataFieldChange();
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.calculateSecondaryQuantity;
    }

    public void setCalculateSecondaryQuantity(boolean bl) {
        this.calculateSecondaryQuantity = bl;
        this.fireDataFieldChange();
    }

    public void setAudit(String string) {
        this.audit = string;
        this.fireDataFieldChange();
    }

    public String getAudit() {
        return this.audit;
    }

    public void setDataCapture(boolean bl) {
        this.dataCapture = bl;
        this.fireDataFieldChange();
    }

    public boolean getDataCapture() {
        return this.dataCapture;
    }

    public void setDropRestrict(boolean bl) {
        this.dropRestrict = bl;
        this.fireDataFieldChange();
    }

    public boolean getDropRestrict() {
        return this.dropRestrict;
    }

    public void setClusterType(boolean bl) {
        this.setDropRestrict(bl);
    }

    public boolean getClusterType() {
        return this.getDropRestrict();
    }

    @Override
    public void setCreatedBy(String string) {
        this.createdBy = string;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setObid(int n) {
        this.obid = n;
        this.fireDataFieldChange();
    }

    public int getObid() {
        return this.obid;
    }

    public void setExcludeFreepage(boolean bl) {
        this.excludeFreepage = bl;
        this.fireDataFieldChange();
    }

    public boolean getExcludeFreepage() {
        return this.excludeFreepage;
    }

    public static String[] getGrowthMethodChoices() {
        return growthMethodChoices;
    }

    public static String[] getAuditChoices() {
        return AUDIT_CHOICES;
    }

    public String getEditProc() {
        return this.editProc;
    }

    public void setEditProc(String string) {
        this.editProc = string;
        this.fireDataFieldChange();
    }

    public String getValidProc() {
        return this.validProc;
    }

    public void setValidProc(String string) {
        this.validProc = string;
        this.fireDataFieldChange();
    }

    public String getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(String string) {
        this.ccsid = string;
        this.fireDataFieldChange();
    }

    public static String[] getCcsidValues() {
        return CCSID;
    }

    public static String[] getDataCaptureValues() {
        return DATA_CAPTURE_VALUES;
    }

    public TableSpaceDB2 getTableSpace() {
        return this.tableSpace;
    }

    public DataBaseDB2 getDataBase() {
        if (this.tableSpace == null) {
            return null;
        }
        return this.tableSpace.getDataBase();
    }

    private IndexProxyDB2 getPartIndex() {
        IndexProxy[] indexProxyArray = this.getIndexProxies();
        for (int i = 0; i < indexProxyArray.length; ++i) {
            IndexProxy indexProxy = indexProxyArray[i];
            if (!(indexProxy instanceof IndexProxyDB2) || !((IndexProxyDB2)indexProxy).isPartitioned()) continue;
            return (IndexProxyDB2)indexProxy;
        }
        return null;
    }

    public void setTableSpace(TableSpaceDB2 tableSpaceDB2) {
        if (this.tableSpace != tableSpaceDB2) {
            IndexProxyDB2 indexProxyDB2 = this.getPartIndex();
            if (this.tableSpace != null && this.tableSpace.getPartIndex() == indexProxyDB2) {
                this.tableSpace.setPartIndex(null);
                this.tableSpace.setMaxPartitionCount(0);
            }
            this.tableSpace = tableSpaceDB2;
            if (indexProxyDB2 != null) {
                this.tableSpace.setPartIndex(indexProxyDB2);
            }
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogDB2 tablePropertyDialogDB2 = new TablePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            tablePropertyDialogDB2.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageRecordLength() {
        int n = 8;
        Table table = (Table)this.getObject();
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("varchar") || columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("vargraphic")) {
                if (this.isUsePCTFilling()) {
                    n += columnArray[i].getDataType(this.getRDBMSType().toString()).getByteSize() * this.pctFilling / 100;
                    try {
                        n += columnArray[i].getDataType(this.getRDBMSType().toString()).getByteSize() * this.pctFilling / 100;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in TableProxyDB2.getAverageRecordLength() - unsuported data type" + columnArray[i].getDataType(this.getRDBMSType().toString()).getName());
                    }
                    finally {
                        n += 0;
                    }
                } else {
                    n = (int)((float)n + this.getColumnProxy(columnArray[i]).getAverageLength());
                }
            } else {
                try {
                    n += columnArray[i].getDataType(this.getRDBMSType().toString()).getByteSize();
                }
                catch (Exception exception) {
                    LOGGER.error("Error in TableProxyDB2.getAverageRecordLength() - unsuported data type" + columnArray[i].getDataType(this.getRDBMSType().toString()).getName());
                }
                finally {
                    n += 0;
                }
            }
            if (columnArray[i].getNullsAllowed()) {
                ++n;
            }
            if (!columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("blob") && !columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("clob") && !columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("dbclob")) continue;
            n += 17;
        }
        return n > 32 ? (long)n : 32L;
    }

    public ColumnProxyDB2 getColumnProxy(Column column) {
        AbstractStorageDesignDB2 abstractStorageDesignDB2 = (AbstractStorageDesignDB2)this.getStorageDesign();
        return (ColumnProxyDB2)abstractStorageDesignDB2.getColumnProxySet().getProxy(column.getObjectID());
    }

    public boolean hasLongColumn() {
        Table table = (Table)this.getObject();
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("longvarchar") && !columnArray[i].getDataType(this.getRDBMSType().toString()).getName().equalsIgnoreCase("longvargraphic")) continue;
            return true;
        }
        return false;
    }

    public int getUsablePageSize() {
        int n = this.getTableSpace() != null && this.getTableSpace().getBufferPool() != null ? this.getTableSpace().getBufferPool().usablePageSize() : 4056;
        if (this.getEditProc().equalsIgnoreCase("")) {
            n -= 10;
        }
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod())) {
            n = this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null ? n * (100 - this.getTableSpace().getStorageTemplate().getPctFree()) / 100 : n * 95 / 100;
        }
        return n;
    }

    public int getPageSize() {
        int n = this.getTableSpace() != null && this.getTableSpace().getBufferPool() != null ? this.getTableSpace().getBufferPool().pageSize() : 4096;
        return n;
    }

    public static String[] getInsertMethodChoices() {
        return insertMethodChoices;
    }

    public String getInsertMethod() {
        return this.insertMethod;
    }

    public void setInsertMethod(String string) {
        this.insertMethod = string;
        this.fireDataFieldChange();
    }

    public int getNumberRecordsPerPage() {
        int n;
        int n2 = 255;
        if (this.getTableSpace() != null) {
            n2 = this.getTableSpace().getMaxRows();
        }
        if ((n = Math.min(n2, (int)Math.ceil((float)this.getUsablePageSize() / (float)this.getAverageRecordLength()))) <= 255 && n <= n2) {
            return n;
        }
        return n2 > 255 ? 255 : n2;
    }

    public int getInitialNumberUsedPages() {
        int n;
        int n2 = Math.max(3, (int)Math.ceil((float)this.getInitialRowNumber() / (float)this.getNumberRecordsPerPage()));
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod()) && this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null && (n = this.getTableSpace().getStorageTemplate().getFreePage()) > 0) {
            n2 = (int)Math.ceil((double)n2 * ((double)(1 + n) / (double)n));
        }
        if (this.getTableSpace() != null && this.getTableSpace().isCompress()) {
            n2 = n2 * (100 - this.getTableSpace().getCompressionRatio()) / 100;
        }
        return n2;
    }

    public int getMaxNumberUsedPages() {
        int n;
        int n2 = Math.max(3, (int)Math.ceil((float)this.getMaxRowNumber() / (float)this.getNumberRecordsPerPage()));
        if (IMLOAD.equalsIgnoreCase(this.getInsertMethod()) && this.getTableSpace() != null && this.getTableSpace().getStorageTemplate() != null && (n = this.getTableSpace().getStorageTemplate().getFreePage()) > 0) {
            n2 = (int)Math.ceil((double)n2 * ((double)(1 + n) / (double)n));
        }
        if (this.getTableSpace() != null && this.getTableSpace().isCompress()) {
            n2 = n2 * (100 - this.getTableSpace().getCompressionRatio()) / 100;
        }
        return n2;
    }

    public int getMaxStorageKB() {
        return this.getPageSize() / 1024 * this.getMaxNumberUsedPages();
    }

    public int getInitialStorageKB() {
        return this.getPageSize() / 1024 * this.getInitialNumberUsedPages();
    }

    public int getPctFilling() {
        return this.pctFilling;
    }

    public void setPctFilling(int n) {
        this.pctFilling = n;
        this.fireDataFieldChange();
    }

    public boolean isUsePCTFilling() {
        return this.usePCTFilling;
    }

    public void setUsePCTFilling(boolean bl) {
        this.usePCTFilling = bl;
        this.fireDataFieldChange();
    }

    public ColumnProxyDB2 getColumn(String string) {
        for (int i = 0; i < this.getColumnProxies().length; ++i) {
            if (!string.equalsIgnoreCase(this.getColumnProxies()[i].getName())) continue;
            return (ColumnProxyDB2)this.getColumnProxies()[i];
        }
        return null;
    }

    @Override
    protected void addIndexProxyWithoutCheck(IndexProxy indexProxy) {
        int n = ((IndexProxyDB2)indexProxy).getStatusGroup();
        if (1 == n) {
            indexProxy.setParent(this.integrityIndexes);
            this.integrityIndexes.add(indexProxy);
            indexProxy.setPAC_Element(this);
        } else {
            super.addIndexProxyWithoutCheck(indexProxy);
        }
    }

    public List getIntegrityIndexes() {
        ArrayList arrayList = new ArrayList();
        this.integrityIndexes.addAllElementsTo(arrayList);
        return arrayList;
    }

    public StorageObjectCollection getIntIndexes() {
        return this.integrityIndexes;
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getOwner();
    }

    public StorageObjectCollection getInstDescriptorCols() {
        return this.instDescriptorCols;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            if (this.getDataBase() != null) {
                return this.getDataBase().isDropEnabled() || this.getDataBase().shouldBeDroppedIndirectly();
            }
            if (this.getTableSpace() != null) {
                return this.getTableSpace().isDropEnabled() || this.getTableSpace().shouldBeDroppedIndirectly();
            }
        }
        return false;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("TableSpace", this, "getTableSpace", "setTableSpace", TableSpaceDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Edit Proc", this, "getEditProc", "setEditProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Valid Proc", this, "getValidProc", "setValidProc", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Audit", this, "getAudit", "setAudit", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Data Capture", this, "getDataCapture", "setDataCapture", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Drop Restrict", this, "getDropRestrict", "setDropRestrict", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("CCSID", this, "getCcsid", "setCcsid", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void remove() {
        Object[] objectArray = this.triggers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TriggerDB2 triggerDB2 = (TriggerDB2)objectArray[i];
            triggerDB2.remove();
            triggerDB2.setTable(null);
            this.triggers.remove(triggerDB2);
        }
        super.remove();
    }

    @Override
    public void clearMergableStructure(Map map) {
        if (map != null) {
            ArrayList arrayList = new ArrayList();
            this.triggers.addAllElementsTo(arrayList);
            this.synonyms.addAllElementsTo(arrayList);
            for (StorageObject storageObject : arrayList) {
                if (map.get(storageObject.getObjectID()) != null) continue;
                storageObject.remove(true);
            }
        }
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.tablePartitions != null) {
            this.tablePartitions.removeAll();
        }
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 synonymDB2 = (SynonymDB2)this.synonyms.createElement(null);
        synonymDB2.setTable(this);
        synonymDB2.setPAC_Element(this);
        return synonymDB2;
    }

    public InstanceDescriptorColumnDB2 createInstanceDescriptorColumn() {
        InstanceDescriptorColumnDB2 instanceDescriptorColumnDB2 = (InstanceDescriptorColumnDB2)this.instDescriptorCols.createElement(null);
        instanceDescriptorColumnDB2.setTable(this);
        instanceDescriptorColumnDB2.setPAC_Element(this);
        return instanceDescriptorColumnDB2;
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance()) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        Table table = (Table)this.getObject();
        SchemaObject schemaObject = table.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getBySchemaObject(schemaObject);
            if (storageObject != null && !storageObject.isNullInstance()) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }
}

