/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.SynonymPropertyDialogDB2;

public class SynonymDB2
extends AbstractStorageObjectDB2 {
    private OwnedObjectImpl owner;
    private TableProxyDB2 table;
    private TableViewProxyDB2 view;
    private AliasDB2 alias;
    public static final String TYPE_NAME = "Synonym";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "SYN";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SynonymPropertyDialogDB2 synonymPropertyDialogDB2 = new SynonymPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            synonymPropertyDialogDB2.show();
        }
    }

    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.owner == null) {
            this.owner = new OwnedObjectImpl();
            this.owner.setOwnerSet(this.getStorageDesignDB2().getOwnerSet());
        }
        return this.owner;
    }

    public AliasDB2 getAlias() {
        return this.alias;
    }

    public void setAlias(AliasDB2 aliasDB2) {
        if (aliasDB2 != null) {
            this.table = null;
            this.view = null;
            this.alias = aliasDB2;
            this.setPAC_Element(aliasDB2);
            this.fireDataFieldChange();
        }
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 tableProxyDB2) {
        if (tableProxyDB2 != null) {
            this.table = tableProxyDB2;
            this.setPAC_Element(tableProxyDB2);
            this.view = null;
            this.alias = null;
            this.fireDataFieldChange();
        }
    }

    public TableViewProxyDB2 getView() {
        return this.view;
    }

    public void setView(TableViewProxyDB2 tableViewProxyDB2) {
        if (tableViewProxyDB2 != null) {
            this.view = tableViewProxyDB2;
            this.setPAC_Element(tableViewProxyDB2);
            this.table = null;
            this.alias = null;
            this.fireDataFieldChange();
        }
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            if (this.getTable() != null) {
                return this.getTable().isDropEnabled() || this.getTable().shouldBeDroppedIndirectly();
            }
            if (this.getView() != null) {
                return this.getView().isDropEnabled() || this.getView().shouldBeDroppedIndirectly();
            }
        }
        return false;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        SynonymDB2 synonymDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getSynonymSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                synonymDB2 = (SynonymDB2)storageObject;
            }
        } else {
            synonymDB2 = ((AbstractStorageDesignDB2)storageDesign).getSynonymSet().createSynonym();
        }
        if (synonymDB2 != null) {
            synonymDB2.setName(this.getName());
            if (this.getOwner() != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner owner2 = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
                    owner2.setName(this.getOwner().getName());
                    owner2.setRawObject(true);
                    synonymDB2.setOwner(owner2);
                } else {
                    synonymDB2.setOwner(owner);
                }
            }
            synonymDB2.setComment(this.getComment());
            synonymDB2.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SYNONYM_ICON", 16);
    }
}

