/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.StorageTemplatePropertyDialogDB2;

public class StorageTemplateDB2
extends AbstractStorageObjectDB2 {
    public static final String[] GBCACHE = new String[]{"", "CHANGED", "ALL", "SYSTEM", "NONE"};
    private VCatDB2 vcat = null;
    private StorageGroupDB2 storageGroup = null;
    private int sgPriqty = 0;
    private int sgSeqty = 0;
    private boolean sgErase = false;
    private int freePage = 0;
    private int pctFree = 5;
    private String gbCache = GBCACHE[0];
    private boolean trackMode = true;
    private boolean define = true;
    StorageObjectCollection tablespaces;
    StorageObjectCollection partitions;
    StorageObjectCollection indexes;
    StorageObjectCollection atindexes;
    public static final String TYPE_NAME = "Template";
    public static final String OLD_TYPE_NAME = "StorageTemplate";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ST";
    }

    public void setVCat(VCatDB2 vCatDB2) {
        this.vcat = vCatDB2;
        if (vCatDB2 != null) {
            this.storageGroup = null;
        }
        this.fireDataFieldChange();
    }

    public VCatDB2 getVCat() {
        return this.vcat;
    }

    public void setStorageGroup(StorageGroupDB2 storageGroupDB2) {
        this.storageGroup = storageGroupDB2;
        if (storageGroupDB2 != null) {
            this.vcat = null;
        }
        this.fireDataFieldChange();
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public int getSgPriqty() {
        return this.sgPriqty;
    }

    public void setSgPriqty(int n) {
        this.sgPriqty = n;
        this.fireDataFieldChange();
    }

    public int getSgSeqty() {
        return this.sgSeqty;
    }

    public void setSgSeqty(int n) {
        this.sgSeqty = n;
        this.fireDataFieldChange();
    }

    public boolean isSgErase() {
        return this.sgErase;
    }

    public void setSgErase(boolean bl) {
        this.sgErase = bl;
        this.fireDataFieldChange();
    }

    public int getFreePage() {
        return this.freePage;
    }

    public void setFreePage(int n) {
        this.freePage = n;
        this.fireDataFieldChange();
    }

    public int getPctFree() {
        return this.pctFree;
    }

    public void setPctFree(int n) {
        this.pctFree = n;
        this.fireDataFieldChange();
    }

    public String getGbCache() {
        return this.gbCache;
    }

    public void setGbCache(String string) {
        this.gbCache = string;
        this.fireDataFieldChange();
    }

    public boolean isTrackMode() {
        return this.trackMode;
    }

    public void setTrackMode(boolean bl) {
        this.trackMode = bl;
        this.fireDataFieldChange();
    }

    public boolean isDefine() {
        return this.define;
    }

    public void setDefine(boolean bl) {
        this.define = bl;
        this.fireDataFieldChange();
    }

    public static final String[] getGBCacheValues() {
        return GBCACHE;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorageTemplatePropertyDialogDB2 storageTemplatePropertyDialogDB2 = new StorageTemplatePropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            storageTemplatePropertyDialogDB2.show();
        }
    }

    public boolean equalsToST(Object object) {
        if (object instanceof StorageTemplateDB2) {
            StorageTemplateDB2 storageTemplateDB2 = (StorageTemplateDB2)object;
            if (this.getStorageGroup() != storageTemplateDB2.getStorageGroup()) {
                return false;
            }
            if (this.getVCat() != storageTemplateDB2.getVCat()) {
                return false;
            }
            if (this.getFreePage() != storageTemplateDB2.getFreePage()) {
                return false;
            }
            if (this.getPctFree() != storageTemplateDB2.getPctFree()) {
                return false;
            }
            if (this.getSgPriqty() != storageTemplateDB2.getSgPriqty()) {
                return false;
            }
            if (this.getSgSeqty() != storageTemplateDB2.getSgSeqty()) {
                return false;
            }
            if (this.isDefine() != storageTemplateDB2.isDefine()) {
                return false;
            }
            if (this.isSgErase() != storageTemplateDB2.isSgErase()) {
                return false;
            }
            if (this.isTrackMode() != storageTemplateDB2.isTrackMode()) {
                return false;
            }
            return this.getGbCache().equalsIgnoreCase(storageTemplateDB2.getGbCache());
        }
        return false;
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        StorageTemplateDB2 storageTemplateDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getStorageTemplateSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                storageTemplateDB2 = (StorageTemplateDB2)storageObject;
            }
        } else {
            storageTemplateDB2 = ((AbstractStorageDesignDB2)storageDesign).getStorageTemplateSet().createStorageTemplate();
        }
        if (storageTemplateDB2 != null) {
            AbstractStorageObjectDB2 abstractStorageObjectDB2;
            AbstractStorageObjectDB2 abstractStorageObjectDB22;
            storageTemplateDB2.setName(this.getName());
            if (this.getVCat() != null) {
                abstractStorageObjectDB22 = (VCatDB2)((AbstractStorageDesignDB2)storageDesign).getVCatSet().getByName(this.getVCat().getName());
                if (abstractStorageObjectDB22 == null) {
                    abstractStorageObjectDB2 = ((AbstractStorageDesignDB2)storageDesign).getVCatSet().createVCat();
                    abstractStorageObjectDB2.setName(this.getVCat().getName());
                    abstractStorageObjectDB2.setRawObject(true);
                    storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB2);
                } else {
                    storageTemplateDB2.setVCat((VCatDB2)abstractStorageObjectDB22);
                }
            }
            if (this.getStorageGroup() != null) {
                abstractStorageObjectDB22 = (StorageGroupDB2)((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().getByName(this.getStorageGroup().getName());
                if (abstractStorageObjectDB22 == null) {
                    abstractStorageObjectDB2 = ((AbstractStorageDesignDB2)storageDesign).getStorageGroupSet().createStorageGroup();
                    abstractStorageObjectDB2.setName(this.getStorageGroup().getName());
                    abstractStorageObjectDB2.setRawObject(true);
                    storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB2);
                } else {
                    storageTemplateDB2.setStorageGroup((StorageGroupDB2)abstractStorageObjectDB22);
                }
            }
            storageTemplateDB2.setSgPriqty(this.getSgPriqty());
            storageTemplateDB2.setSgSeqty(this.getSgSeqty());
            storageTemplateDB2.setSgErase(this.isSgErase());
            storageTemplateDB2.setFreePage(this.getFreePage());
            storageTemplateDB2.setPctFree(this.getPctFree());
            storageTemplateDB2.setGbCache(this.getGbCache());
            storageTemplateDB2.setTrackMode(this.isTrackMode());
            storageTemplateDB2.setDefine(this.isDefine());
            storageTemplateDB2.setComment(this.getComment());
            storageTemplateDB2.setRawObject(false);
        }
    }

    public boolean isUsedInOtherDefinitions(StorageObject storageObject) {
        StorageObject storageObject2;
        Iterator iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getTableSpaceSet().iterator();
        while (iterator.hasNext()) {
            storageObject2 = (TableSpaceDB2)iterator.next();
            if (storageObject2.getStorageTemplate() == null || storageObject2 == storageObject || storageObject2.getStorageTemplate() != this) continue;
            return true;
        }
        iterator = this.getStorageDesign().getIndexProxySet().iterator();
        while (iterator.hasNext()) {
            IndexProxyDB2 indexProxyDB2;
            storageObject2 = iterator.next();
            if (!(storageObject2 instanceof IndexProxyDB2) || (indexProxyDB2 = (IndexProxyDB2)storageObject2).getStorageTemplate() == null || indexProxyDB2 == storageObject || indexProxyDB2.getStorageTemplate() != this) continue;
            return true;
        }
        iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPartitionSet().iterator();
        while (iterator.hasNext()) {
            storageObject2 = (PartitionDB2)iterator.next();
            if (((PartitionDB2)storageObject2).getStorageTemplate() == null || storageObject2 == storageObject || ((PartitionDB2)storageObject2).getStorageTemplate() != this) continue;
            return true;
        }
        iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getAUXTableIndexSet().iterator();
        while (iterator.hasNext()) {
            storageObject2 = (AUXTableIndexDB2)iterator.next();
            if (((AUXTableIndexDB2)storageObject2).getStorageTemplate() == null || storageObject2 == storageObject || ((AUXTableIndexDB2)storageObject2).getStorageTemplate() != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TEMPLATE_ICON", 16);
    }
}

