/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.OwnerPropertyDialogDB2;

public class Owner
extends StorageObject {
    private String systemPrivileges = "";
    private PrivilegesSet systemPrivilegesSet = null;
    private static final String[] PRIVILEGES = new String[]{"ARCHIVE", "BINDADD", "BINDAGENT", "BSDS", "CREATEALIAS", "CREATEDBA", "CREATEDBC", "CREATESG", "CREATEMTAB", "DISPLAY", "MONITOR1", "MONITOR2", "RECOVER", "STOPALL", "STOSPACE", "SYSADMIN", "SYSCTRL", "SYSOPR", "TRACE"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    public static final String TYPE_NAME = "Owner";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    private void addSystemPrivileges(String string) {
        if (!this.getSystemPrivilegesSet().contains(string)) {
            this.getSystemPrivilegesSet().add(string);
        }
    }

    private void recreateSystemPrivilegesSet(String string) {
        this.getSystemPrivilegesSet().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.systemPrivilegesSet = new PrivilegesSet();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (!this.checkPrivileges(string2)) continue;
            this.getSystemPrivilegesSet().add(string2);
        }
    }

    public void setSystemPrivileges(String string) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(string);
        } else if (this.checkPrivileges(string)) {
            this.addSystemPrivileges(string);
        }
        this.systemPrivileges = this.getSystemPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public String getSystemPrivileges() {
        return this.systemPrivileges;
    }

    public PrivilegesSet getSystemPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new PrivilegesSet();
        }
        return this.systemPrivilegesSet;
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    protected boolean checkPrivileges(String string) {
        return PRIVILEGESLIST.contains(string);
    }

    public void clear() {
        this.getSystemPrivilegesSet().removeAllElements();
        this.systemPrivileges = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(Owner.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String string) {
        if (string != null && string.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(string)) {
            this.grantOption = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            OwnerPropertyDialogDB2 ownerPropertyDialogDB2 = new OwnerPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            ownerPropertyDialogDB2.show();
        }
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        Owner owner = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                owner = (Owner)storageObject;
            }
        } else {
            owner = (Owner)((AbstractStorageDesignDB2)storageDesign).getOwnerSet().createElement(null);
        }
        if (owner != null) {
            owner.setName(this.getName());
            owner.recreateSystemPrivilegesSet(this.getSystemPrivilegesSet().toString());
            owner.setGrantOption(this.getGrantOption());
            owner.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("USER_ICON", 16);
    }

    private List getPermissions() {
        ArrayList<PermissionsDB2> arrayList = new ArrayList<PermissionsDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsDB2 permissionsDB2 = (PermissionsDB2)iterator.next();
            if (permissionsDB2.getUser() != this) continue;
            arrayList.add(permissionsDB2);
        }
        return arrayList;
    }

    public List getSortedByIDPermisions() {
        List list = this.getPermissions();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    private List getDBPrivileges() {
        ArrayList<PrivilegesDB2> arrayList = new ArrayList<PrivilegesDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            PrivilegesDB2 privilegesDB2 = (PrivilegesDB2)iterator.next();
            if (privilegesDB2.getUser() != this) continue;
            arrayList.add(privilegesDB2);
        }
        return arrayList;
    }

    public List getSortedByID_DBPrivileges() {
        List list = this.getDBPrivileges();
        Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return list;
    }

    public PermissionsDB2 createPermission() {
        PermissionsDB2 permissionsDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permissionsDB2.setUser(this);
        return permissionsDB2;
    }

    public PrivilegesDB2 createDBPrivilege() {
        PrivilegesDB2 privilegesDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getPrivilegesSet().createPriv();
        privilegesDB2.setUser(this);
        return privilegesDB2;
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return String.valueOf(object).compareTo(String.valueOf(object2));
        }
    }

    public class PrivilegesSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

