/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyDB2
extends IndexProxy
implements ModelObjectSetListener,
OwnedObject,
StorageObjectListener,
Constants,
PropertiesPropagator {
    private static final String[] INDEX_STATES = new String[]{"Unique Constraint", "Primary Constraint", "Unique Plain Index"};
    private static Set indexUniqueSet = null;
    public static final String[] CLUSTER_TYPES = new String[]{"NONE", "CLUSTERED", "CLUSTERED_PARTITIONED"};
    public static final String[] PIECE_SIZES = new String[]{" ", "254 K", "512 K", "1024 K", "2048 K", "4096 K", "8192 K", "16384 K", "32768 K", "65536 K", "131072 K", "262144 K", "524288 K", "1048576 K", "2097152 K", "4194304 K", "8388608 K", "16777216 K", "33554432 K", "67108864 K"};
    protected OwnedObjectImpl ownedObjectImpl = null;
    protected boolean whereNotNull = false;
    protected StorageTemplateDB2 storageTemplate = null;
    protected StorageGroupDB2 storageGroup = null;
    protected String clusterType = CLUSTER_TYPES[0];
    protected String pieceSize = PIECE_SIZES[0];
    protected BufferPoolDB2 bufferPool = null;
    protected boolean close = true;
    protected boolean defer = false;
    protected boolean copy = false;
    private boolean hasAssignedIntgrityIndex = false;
    protected int isobid = 0;
    protected String createdBy = "";
    protected int firstKeyCard = 0;
    protected int fullKeyCard = 0;
    protected int numberLeaf = 0;
    protected int numberLevels = 0;
    protected int catalogSpace = 0;
    protected int clusterRatio = 0;
    protected IndexSpaceDB2 indexSpace;
    protected long initial = 0L;
    protected long frequencyCount = 0L;
    protected float frequencyPercent = 0.0f;
    protected float updateRatePercent = 0.0f;
    protected TableSpaceDB2 tablespace;
    StorageObjectCollection indparts;
    protected final State UNIQUE = new Unique();
    protected final State NONUNIQUE;
    protected State state = this.NONUNIQUE = new NonUnique();
    protected static final int PRIQTY = 1;
    protected static final int SECQTY = 2;
    protected static final int INITIALROWS = 1;
    protected static final int MAXROWS = 2;
    protected int rowsForCalculation = 1;
    protected StringBuffer proposedQTYRemarks = new StringBuffer();
    private int statusGroup;
    private int oldStatusGroup;
    public static final int STATUSGROUP_CONSTRAINT = 1;
    public static final int STATUSGROUP_INDEX = 2;
    public static final String INTEGRITY_INDEX_PREFIX = "I";
    private boolean processedInDDLImport = false;
    private boolean allowIntegrityIndexNR = true;
    private List propertyWrapperList = null;
    private boolean noIntegrity = false;
    private static int maxQTY = 0x400000;

    public IndexProxyDB2(Index index, StorageDesign storageDesign) {
        this(index, storageDesign, true);
    }

    public IndexProxyDB2(Index index, StorageDesign storageDesign, boolean bl) {
        super(index, storageDesign);
        this.oldStatusGroup = this.statusGroup = this.getStatusGroup(index);
        if (bl) {
            this.indparts = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet());
            this.indparts.setParent(this);
            this.indparts.setName(Messages.getString("IndexProxyDB2.Partitions"));
            this.indparts.setSetMethod("setIndex");
            this.indparts.setClassForParent(IndexProxyDB2.class);
            ((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet().addSetListener(this);
            this.indparts.addSetListener(this);
        }
    }

    public IndexProxyDB2(Design design, String string, String string2, StorageDesign storageDesign) {
        this(design, string, string2, storageDesign, true);
    }

    public IndexProxyDB2(Design design, String string, String string2, StorageDesign storageDesign, boolean bl) {
        super(design, string, string2, storageDesign);
        this.oldStatusGroup = this.statusGroup = this.getStatusGroup((Index)this.getObject());
        if (bl) {
            this.indparts = new StorageObjectCollection(((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet());
            this.indparts.setParent(this);
            this.indparts.setName(Messages.getString("IndexProxyDB2.Partitions"));
            this.indparts.setSetMethod("setIndex");
            this.indparts.setClassForParent(IndexProxyDB2.class);
            ((AbstractStorageDesignDB2)storageDesign).getIndexPartitionSet().addSetListener(this);
            this.indparts.addSetListener(this);
        }
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.ownedObjectImpl == null) {
            this.ownedObjectImpl = new OwnedObjectImpl();
            this.ownedObjectImpl.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.ownedObjectImpl;
    }

    public boolean isWhereNotNull() {
        return this.whereNotNull;
    }

    public void setWhereNotNull(boolean bl) {
        this.whereNotNull = bl;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplateDB2) {
        this.storageTemplate = storageTemplateDB2;
        this.fireDataFieldChange();
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String string) {
        if (string != null && string.equals(this.clusterType)) {
            return;
        }
        try {
            this.clusterType = string;
            if (!this.isPartitioned()) {
                this.removePartitions();
                this.indparts.setForbiddenCreateElement(true);
            } else {
                this.indparts.setForbiddenCreateElement(false);
            }
            TableSpaceDB2 tableSpaceDB2 = ((TableProxyDB2)this.getTableProxy()).getTableSpace();
            if (tableSpaceDB2 != null) {
                if (this.isPartitioned() && tableSpaceDB2.getPartIndex() != this) {
                    tableSpaceDB2.setPartIndex(this);
                } else if (!this.isPartitioned() && tableSpaceDB2.getPartIndex() == this) {
                    tableSpaceDB2.setPartIndex(null);
                }
            }
            this.fireDataFieldChange();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPieceSize() {
        return this.pieceSize;
    }

    public int getPieceSizeKB() {
        String string = this.getPieceSize();
        if (string.length() > 2) {
            try {
                String string2 = string.substring(0, string.length() - 1).trim();
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return 0x200000;
            }
        }
        return 0;
    }

    public void setPieceSize(String string) {
        this.pieceSize = string;
        this.fireDataFieldChange();
    }

    public BufferPoolDB2 getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(BufferPoolDB2 bufferPoolDB2) {
        this.bufferPool = bufferPoolDB2;
        this.fireDataFieldChange();
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean bl) {
        this.close = bl;
        this.fireDataFieldChange();
    }

    public boolean isDefer() {
        return this.defer;
    }

    public void setDefer(boolean bl) {
        this.defer = bl;
        this.fireDataFieldChange();
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean bl) {
        this.copy = bl;
        this.fireDataFieldChange();
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent.getAffected() instanceof IndexPartitionDB2) {
            IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)objectChangeEvent.getAffected();
            if (indexPartitionDB2.getIndex() != null && indexPartitionDB2.getIndex() == this && !this.indparts.contains(indexPartitionDB2)) {
                indexPartitionDB2.setParent(this.indparts);
                this.indparts.add(indexPartitionDB2);
                indexPartitionDB2.setPAC_Element(this);
                if (!this.getStorageDesign().isLoading()) {
                    indexPartitionDB2.removeObjectListener(this);
                    indexPartitionDB2.setPartNumber(this.indparts.size());
                    indexPartitionDB2.addObjectListener(this);
                }
                this.synchronizeTablespacePartNum();
            } else if ((indexPartitionDB2.getIndex() == null || indexPartitionDB2.getIndex() != null && indexPartitionDB2.getIndex() != this) && this.indparts.contains(indexPartitionDB2)) {
                this.indparts.remove(indexPartitionDB2);
                this.synchronizeTablespacePartNum();
            }
        }
    }

    private void synchronizeTablespacePartNum() {
        TableProxyDB2 tableProxyDB2;
        if (this.getTableProxy() != null && (tableProxyDB2 = (TableProxyDB2)this.getTableProxy()).getTableSpace() != null) {
            tableProxyDB2.getTableSpace().setMaxPartitionCount(this.getNumParts());
        }
    }

    protected boolean checkUniqueness(String string) {
        if (indexUniqueSet == null) {
            indexUniqueSet = new HashSet();
            indexUniqueSet.addAll(Arrays.asList(INDEX_STATES));
        }
        return indexUniqueSet.contains(string);
    }

    @Override
    public boolean isUnique() {
        return this.checkUniqueness(this.getIndex().getIndexState());
    }

    public boolean isUniquePlainIndex() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public int getNumParts() {
        if (this.indparts != null) {
            return this.indparts.size();
        }
        return 0;
    }

    public IndexPartitionDB2[] getPartitions() {
        IndexPartitionSetDB2 indexPartitionSetDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getIndexPartitionSet();
        return indexPartitionSetDB2.getPartitionsFor(this);
    }

    public static String[] getClusterTypeValues() {
        return CLUSTER_TYPES;
    }

    public static String[] getPieceSizesValues() {
        return PIECE_SIZES;
    }

    public void setIsobid(int n) {
        this.isobid = n;
        this.fireDataFieldChange();
    }

    public int getIsobid() {
        return this.isobid;
    }

    @Override
    public void setCreatedBy(String string) {
        this.createdBy = string;
        this.fireDataFieldChange();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setFirstKeyCard(int n) {
        this.firstKeyCard = n;
        this.fireDataFieldChange();
    }

    public int getFirstKeyCard() {
        return this.firstKeyCard;
    }

    public void setFullKeyCard(int n) {
        this.fullKeyCard = n;
        this.fireDataFieldChange();
    }

    public int getFullKeyCard() {
        return this.fullKeyCard;
    }

    public void setNumberLeaf(int n) {
        this.numberLeaf = n;
        this.fireDataFieldChange();
    }

    public int getNumberLeaf() {
        return this.numberLeaf;
    }

    public void setNumberLevels(int n) {
        this.numberLevels = n;
        this.fireDataFieldChange();
    }

    public int getNumberLevels() {
        return this.numberLevels;
    }

    public void setCatalogSpace(int n) {
        this.catalogSpace = n;
        this.fireDataFieldChange();
    }

    public int getCatalogSpace() {
        return this.catalogSpace;
    }

    public void setClusterRatio(int n) {
        this.clusterRatio = n;
        this.fireDataFieldChange();
    }

    public int getClusterRatio() {
        return this.clusterRatio;
    }

    public void setMaintenanceInterval(int n) {
        this.getIndexSpace().setMaintenanceInterval(n);
        this.fireDataFieldChange();
    }

    public int getMaintenanceInterval() {
        return this.getIndexSpace().getMaintenanceInterval();
    }

    public void setSpaceAllocationInterval(int n) {
        this.getIndexSpace().setSpaceAllocationInterval(n);
    }

    public int getSpaceAllocationInterval() {
        return this.getIndexSpace().getSpaceAllocationInterval();
    }

    public boolean checkInitial(long l) {
        return l <= 0xFFFFFFFEL && l >= 0L;
    }

    public void setInitial(long l) {
        if (this.checkInitial(l)) {
            this.initial = l;
            this.fireDataFieldChange();
        }
    }

    public long getInitial() {
        return this.initial;
    }

    public boolean checkFrequencyCount(long l) {
        return l <= 0xFFFFFFFEL && l >= 0L && l <= this.getInitial();
    }

    public void setFrequencyCount(long l) {
        if (this.checkFrequencyCount(l)) {
            this.frequencyCount = l;
            this.fireDataFieldChange();
        }
    }

    public long getFrequencyCount() {
        return this.frequencyCount;
    }

    public boolean checkFrequencyPercent(float f) {
        return f <= 100.0f && f >= 0.0f;
    }

    public void setFrequencyPercent(float f) {
        if (this.checkFrequencyPercent(f)) {
            this.frequencyPercent = f;
            this.fireDataFieldChange();
        }
    }

    public float getFrequencyPercent() {
        return this.frequencyPercent;
    }

    public boolean checkUpdateRatePercent(float f) {
        return f < 10000.0f && f >= 0.0f;
    }

    public void setUpdateRatePercent(float f) {
        if (this.checkUpdateRatePercent(f)) {
            this.updateRatePercent = f;
            this.fireDataFieldChange();
        }
    }

    public float getUpdateRatePercent() {
        return this.updateRatePercent;
    }

    public IndexSpaceDB2 getIndexSpace() {
        if (this.indexSpace == null) {
            this.indexSpace = new IndexSpaceDB2();
            this.indexSpace.setDesign(this.getDesign());
            this.indexSpace.setStorageDesign(this.getStorageDesign());
            this.indexSpace.setObjectID(this.getObjectID() + "SPACE");
            this.indexSpace.addObjectListener(this);
        }
        return this.indexSpace;
    }

    public int getNumberOfDuplicates() {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)this.getTableProxy();
        if (this.getInitial() != 0L) {
            return (int)(tableProxyDB2.getInitialRowNumber() / this.getInitial());
        }
        return 1;
    }

    public void setCalculatePrimaryQuantity(boolean bl) {
        this.getIndexSpace().setCalculatePrimaryQuantity(bl);
    }

    public boolean getCalculatePrimaryQuantity() {
        return this.getIndexSpace().getCalculatePrimaryQuantity();
    }

    public void setCalculateSecondaryQuantity(boolean bl) {
        this.getIndexSpace().setCalculateSecondaryQuantity(bl);
    }

    public boolean getCalculateSecondaryQuantity() {
        return this.getIndexSpace().getCalculateSecondaryQuantity();
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.indparts;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.indparts) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.indparts) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected String applyNameRules(String string) {
        return string;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        Index index = (Index)designObject;
        this.setStatusGroup(this.getStatusGroup(index));
        if (this.getOldStatusGroup() != this.getStatusGroup()) {
            this.fireDataFieldChange();
        }
        if (objectChangeEvent.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.synchronizeStorageTemplateName();
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        block8: {
            block9: {
                block7: {
                    IndexPartitionDB2 indexPartitionDB2;
                    if (modelObjectSet != this.indparts) break block7;
                    if (modelObjectSetEvent.isType(1) && modelObjectSetEvent.getAffected() instanceof IndexPartitionDB2 && (indexPartitionDB2 = (IndexPartitionDB2)modelObjectSetEvent.getAffected()).getIndex() == null) {
                        indexPartitionDB2.setParent(null);
                        this.indparts.remove(indexPartitionDB2);
                        if (!this.getStorageDesign().isLoading()) {
                            indexPartitionDB2.removeObjectListener(this);
                            indexPartitionDB2.setPartNumber(this.indparts.size());
                            indexPartitionDB2.addObjectListener(this);
                        }
                        indexPartitionDB2.setIndex(this);
                    }
                    break block8;
                }
                if (!modelObjectSetEvent.isType(1)) break block9;
                if (!(modelObjectSetEvent.getAffected() instanceof IndexPartitionDB2)) break block8;
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)modelObjectSetEvent.getAffected();
                indexPartitionDB2.addObjectListener(this);
                if (indexPartitionDB2.getIndex() == null || indexPartitionDB2.getIndex() != this) break block8;
                indexPartitionDB2.setParent(this.indparts);
                if (!this.getStorageDesign().isLoading()) {
                    indexPartitionDB2.removeObjectListener(this);
                    indexPartitionDB2.setPartNumber(this.indparts.size());
                    indexPartitionDB2.addObjectListener(this);
                }
                this.indparts.add(indexPartitionDB2);
                indexPartitionDB2.setPAC_Element(this);
                break block8;
            }
            if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof IndexPartitionDB2) {
                IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)modelObjectSetEvent.getAffected();
                indexPartitionDB2.removeObjectListener(this);
                if (this.indparts.contains(indexPartitionDB2)) {
                    this.indparts.remove(indexPartitionDB2);
                    if (!this.getStorageDesign().isLoading()) {
                        for (int i = 0; i < this.indparts.size(); ++i) {
                            ((IndexPartitionDB2)this.indparts.getElement(i)).removeObjectListener(this);
                            ((IndexPartitionDB2)this.indparts.getElement(i)).setPartNumber(i + 1);
                            ((IndexPartitionDB2)this.indparts.getElement(i)).removeObjectListener(this);
                        }
                    }
                }
            }
        }
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogDB2 indexPropertyDialogDB2 = new IndexPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            indexPropertyDialogDB2.show();
        }
    }

    @Override
    public boolean isPartitioned() {
        return this.clusterType.equalsIgnoreCase(CLUSTER_TYPES[2]);
    }

    protected void checkState() {
        this.state = this.isUnique() ? this.UNIQUE : this.NONUNIQUE;
    }

    private int getSpacePerKeyL() {
        this.checkState();
        return this.state.getSpacePerKeyL();
    }

    private int getSpacePerKeyNL() {
        this.checkState();
        return this.state.getSpacePerKeyNL();
    }

    private int getIndexByteSize() {
        return this.getByteSize() + this.getIndex().getNumberOfNullsAllowingElements();
    }

    private int getByteSize() {
        int n = 0;
        Index index = this.getIndex();
        Column[] columnArray = (Column[])index.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            n += columnArray[i].getDataType(this.getRDBMSType().toString()).getByteSize();
        }
        return n;
    }

    boolean isLargeTSforTable() {
        if (((TableProxyDB2)this.getTableProxy()).getTableSpace().getType().equalsIgnoreCase("LOB")) {
            return true;
        }
        String string = ((TableProxyDB2)this.getTableProxy()).getTableSpace().getDsSize();
        string = string.replace('M', ' ');
        try {
            int n = Integer.parseInt(string);
            if (n >= 4) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getRIDSize() {
        if (this.getTablespace() != null && this.isLargeTSforTable()) {
            return 5;
        }
        return 4;
    }

    private int getMaxUsableSpacePerPageL() {
        return (int)Math.floor((float)((100 - this.getPercentageFree()) * 4038) / 100.0f);
    }

    private int getMaxUsableSpacePerPageNL() {
        float f = Math.max(90, 100 - this.getPercentageFree());
        return (int)Math.floor(f * 4046.0f / 100.0f);
    }

    private int getEntriesPerPageL() {
        this.checkState();
        return this.state.getEntriesPerPageL();
    }

    private int getEntriesPerPageNL() {
        return (int)Math.floor(this.getMaxUsableSpacePerPageNL() / this.getSpacePerKeyNL());
    }

    private int getPercentageFree() {
        if (this.getStorageTemplate() != null && ((TableProxyDB2)this.getTableProxy()).getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
            return this.getStorageTemplate().getPctFree();
        }
        return 0;
    }

    private int getFreePage() {
        if (this.getStorageTemplate() != null && ((TableProxyDB2)this.getTableProxy()).getInsertMethod().equalsIgnoreCase("Load/Reorg")) {
            return this.getStorageTemplate().getFreePage();
        }
        return 0;
    }

    private int getAverageNumberDuplicatesPerKey() {
        return this.getNumberOfDuplicates();
    }

    private int getKeyEntriesPerPageL() {
        return (int)Math.floor((float)(this.getAverageNumberDuplicatesPerKey() * this.getMaxUsableSpacePerPageL()) / (float)this.getSpacePerKeyL());
    }

    private int getRemainingSpacePerPageL() {
        return (int)Math.floor((float)this.getMaxUsableSpacePerPageL() - (float)(this.getKeyEntriesPerPageL() * this.getSpacePerKeyL()) / (float)this.getAverageNumberDuplicatesPerKey());
    }

    private int getDataRecordsPerPartialEntryL() {
        return (int)Math.floor((float)(this.getRemainingSpacePerPageL() - (this.getIndexByteSize() + 4)) / 5.0f);
    }

    private int getPartialEntriesPerPageL() {
        if (this.getDataRecordsPerPartialEntryL() < 1) {
            return 0;
        }
        float f = (float)this.getAverageNumberDuplicatesPerKey() / (float)this.getDataRecordsPerPartialEntryL();
        return this.getAverageNumberDuplicatesPerKey() / (int)Math.ceil(f);
    }

    private long getRowNumberOfTableProxy() {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)this.getTableProxy();
        return this.rowsForCalculation == 1 ? tableProxyDB2.getInitialRowNumber() : tableProxyDB2.getMaxRowNumber();
    }

    private long getNumberLeafPages() {
        return (long)Math.ceil((float)this.getRowNumberOfTableProxy() / (float)this.getEntriesPerPageL());
    }

    private int getMinNumberChildPages() {
        return Math.max(2, this.getEntriesPerPageNL() + 1);
    }

    private long getLevel2Pages() {
        return (long)Math.ceil((float)this.getNumberLeafPages() / (float)this.getMinNumberChildPages());
    }

    private long getLevelXPages(float f) {
        return (long)Math.ceil(f / (float)this.getMinNumberChildPages());
    }

    private long getNumberNonleafPages() {
        long l = this.getLevel2Pages();
        long l2 = this.getLevel2Pages();
        while (l2 > 1L) {
            l2 = this.getLevelXPages(l2);
            l += l2;
        }
        return l;
    }

    private long getFreePages() {
        if (this.getFreePage() != 0) {
            return (long)Math.floor((float)this.getNumberLeafPages() / (float)this.getFreePage());
        }
        return 0L;
    }

    private long getTreePages() {
        return Math.max(2L, this.getNumberLeafPages() + this.getNumberNonleafPages());
    }

    private long getSpaceMapPages() {
        return (long)Math.ceil((float)(this.getFreePages() + this.getTreePages()) / 8131.0f);
    }

    private int getNumberIndexPages() {
        return (int)Math.max(4L, 1L + this.getSpaceMapPages() + this.getTreePages() + this.getFreePages());
    }

    private int getRequiredSpacePages() {
        return this.getNumberIndexPages() + 2;
    }

    public int getInitialNumberUsedPages() {
        this.rowsForCalculation = 1;
        return this.getRequiredSpacePages();
    }

    public int getMaxNumberUsedPages() {
        this.rowsForCalculation = 2;
        return this.getRequiredSpacePages();
    }

    public long getInitialNumberUsedKB() {
        return 4 * this.getInitialNumberUsedPages();
    }

    public long getMaxNumberUsedKB() {
        return 4 * this.getMaxNumberUsedPages();
    }

    private int getNumberOfPieces() {
        if (((TableProxyDB2)this.getTableProxy()).getTableSpace() != null) {
            String string = ((TableProxyDB2)this.getTableProxy()).getTableSpace().getDsSize();
            int n = 0;
            if (string.length() > 2) {
                try {
                    n = Integer.parseInt(string.substring(0, string.length() - 2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n >= 4 || ((TableProxyDB2)this.getTableProxy()).getTableSpace().getType().equalsIgnoreCase("LOB")) {
                return 254;
            }
        }
        return 32;
    }

    public int transformPSizeToLong(String string) {
        String string2 = string.substring(0, string.length() - 2);
        return Integer.parseInt(string2);
    }

    int chooseProperPieceSize(int n) {
        for (int i = 1; i < PIECE_SIZES.length; ++i) {
            int n2 = this.transformPSizeToLong(PIECE_SIZES[i]);
            if (n >= n2) continue;
            return this.transformPSizeToLong(PIECE_SIZES[i]);
        }
        return this.transformPSizeToLong(PIECE_SIZES[PIECE_SIZES.length]);
    }

    public int getProposedPRIQTY() {
        return this.getProposedQTY(1);
    }

    public int getProposedQTY(int n) {
        this.proposedQTYRemarks.setLength(0);
        int n2 = 4;
        int n3 = (int)Math.ceil((float)this.getPieceSizeKB() / 4.0f);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n5 = this.getMaxNumberUsedPages();
        n4 = this.getInitialNumberUsedPages();
        n4 = Math.max(3, n4);
        n5 = Math.max(3, n5);
        if (this.getNumParts() == 0) {
            int n8 = this.getNumberOfPieces();
            int n9 = n8 * n3;
            if (n9 < n5) {
                this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.CurrentPIECESIZENotSufficient"));
                int n10 = n5 / n8;
                n10 = this.chooseProperPieceSize(n10 * 4);
                this.proposedQTYRemarks.append(MessageFormat.format(Messages.getString("IndexProxyDB2.PIECESIZEProposed"), Integer.toString(n10)));
                n3 = n10 / 4;
            }
            if ((n6 = n4) >= n3) {
                n6 = n3;
                n7 = n6 / 10;
            } else {
                long l;
                n7 = Math.max(3, n6 / 10);
                if ((long)(n6 + 118 * n7) < (l = (long)Math.min(n3, n5))) {
                    n7 = n6 = (int)Math.ceil((float)l / 119.0f);
                    this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.SizeAdjusted"));
                }
            }
        } else {
            n6 = n4;
            n7 = Math.max(3, n6 / 10);
            if (n6 + 118 * n7 < n5) {
                n7 = n6 = (int)Math.ceil((float)n5 / 119.0f);
                this.proposedQTYRemarks.append(Messages.getString("IndexProxyDB2.SizeAdjusted"));
            }
        }
        n6 *= n2;
        n7 *= n2;
        if (n4 == n5) {
            n7 = 0;
        }
        n6 = Math.min(n6, maxQTY);
        n7 = Math.min(n7, maxQTY);
        return n == 1 ? n6 : n7;
    }

    public int getProposedSECQTY() {
        return this.getProposedQTY(2);
    }

    public String getProposedQTYRemarks() {
        return this.proposedQTYRemarks.toString();
    }

    public int getStatusGroup(Index index) {
        if (index.isPK() || index.isUnique()) {
            return 1;
        }
        return 2;
    }

    private void setStatusGroup(int n) {
        this.oldStatusGroup = this.statusGroup;
        this.statusGroup = n;
    }

    public int getStatusGroup() {
        return this.statusGroup;
    }

    public int getOldStatusGroup() {
        return this.oldStatusGroup;
    }

    private void removePartitions() {
        int n;
        if (this.indparts != null && (n = this.indparts.size()) > 0) {
            IndexPartitionDB2[] indexPartitionDB2Array = new IndexPartitionDB2[n];
            Iterator iterator = this.indparts.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                indexPartitionDB2Array[n2] = (IndexPartitionDB2)iterator.next();
                ++n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                indexPartitionDB2Array[n2].remove();
            }
        }
    }

    public TableSpaceDB2 getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(TableSpaceDB2 tableSpaceDB2) {
        if (tableSpaceDB2 != null) {
            this.tablespace = tableSpaceDB2;
            this.fireDataFieldChange();
        }
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(StorageGroupDB2 storageGroupDB2) {
        this.storageGroup = storageGroupDB2;
        this.fireDataFieldChange();
    }

    public boolean isProcessedInDDLImport() {
        return this.processedInDDLImport;
    }

    public void setProcessedInDDLImport(boolean bl) {
        this.processedInDDLImport = bl;
    }

    public boolean isAllowIntegrityIndexNR() {
        return this.allowIntegrityIndexNR;
    }

    public void setAllowIntegrityIndexNR(boolean bl) {
        this.allowIntegrityIndexNR = bl;
    }

    public StorageObjectCollection getIndexPartitions() {
        return this.indparts;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getOwner", "setOwner", Owner.class));
            this.propertyWrapperList.add(new PropertyWrapper("Where Not Null", this, "isWhereNotNull", "setWhereNotNull", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Storage Template", this, "getStorageTemplate", "setStorageTemplate", StorageTemplateDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster Type", this, "getClusterType", "setClusterType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Piece Size", this, "getPieceSize", "setPieceSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolDB2.class));
            this.propertyWrapperList.add(new PropertyWrapper("Close", this, "isClose", "setClose", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Defer", this, "isDefer", "setDefer", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Copy", this, "isCopy", "setCopy", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    public boolean isHasAssignedIntgrityIndex() {
        return this.hasAssignedIntgrityIndex;
    }

    public void setHasAssignedIntgrityIndex(boolean bl) {
        this.hasAssignedIntgrityIndex = bl;
    }

    public void synchronizeStorageTemplateName() {
        StorageTemplateDB2 storageTemplateDB2;
        if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex() && (storageTemplateDB2 = this.getStorageTemplate()) != null && !storageTemplateDB2.isUsedInOtherDefinitions(this)) {
            String string = this.getDesign().getAppView().getSettings().getNamingRuleStIndexDB2();
            String string2 = ApplyNamingStandards.createIndexStorageTemplateDB2_Name(this.getName(), string, this.getStorageDesign().getPhysicalDesign().getName());
            storageTemplateDB2.setName(string2);
        }
    }

    public boolean isNoIntegrity() {
        return this.noIntegrity;
    }

    public void setNoIntegrity(boolean bl) {
        this.noIntegrity = bl;
    }

    @Override
    public void clearNoneMergableStructure() {
        if (this.indparts != null) {
            this.indparts.removeAll();
        }
    }

    @Override
    public String getLongName() {
        if (this.getOwner() != null && !this.getOwner().isNullInstance()) {
            return new StringBuffer(this.getOwner().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject containerObject = (ContainerObject)this.getObject();
        SchemaObject schemaObject = containerObject.getSchemaObject();
        if (schemaObject != null) {
            StorageObject storageObject = ((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getBySchemaObject(schemaObject);
            if (storageObject != null && !storageObject.isNullInstance()) {
                return new StringBuffer(storageObject.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(schemaObject.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            string = index.getFKAssociation().getName();
        }
        string = this.applyNameSubstitution(string);
        return string;
    }

    public IndexPartitionDB2 createIndexPartition() {
        IndexPartitionDB2 indexPartitionDB2 = (IndexPartitionDB2)this.indparts.createElement(null);
        indexPartitionDB2.setIndex(this);
        indexPartitionDB2.setPAC_Element(this);
        return indexPartitionDB2;
    }

    class NonUnique
    extends State {
        NonUnique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return IndexProxyDB2.this.getIndexByteSize() + 4 + IndexProxyDB2.this.getAverageNumberDuplicatesPerKey() * (IndexProxyDB2.this.getRIDSize() + 1);
        }

        @Override
        public int getSpacePerKeyNL() {
            return IndexProxyDB2.this.getIndexByteSize() + IndexProxyDB2.this.getRIDSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return Math.max(1, IndexProxyDB2.this.getKeyEntriesPerPageL() + IndexProxyDB2.this.getPartialEntriesPerPageL());
        }
    }

    class Unique
    extends State {
        Unique() {
        }

        @Override
        public int getSpacePerKeyL() {
            return IndexProxyDB2.this.getIndexByteSize() + IndexProxyDB2.this.getRIDSize() + 3;
        }

        @Override
        public int getSpacePerKeyNL() {
            return IndexProxyDB2.this.getIndexByteSize() + 7;
        }

        @Override
        public int getEntriesPerPageL() {
            return (int)Math.floor(IndexProxyDB2.this.getMaxUsableSpacePerPageL() / this.getSpacePerKeyL());
        }
    }

    abstract class State {
        State() {
        }

        public abstract int getSpacePerKeyL();

        public abstract int getSpacePerKeyNL();

        public abstract int getEntriesPerPageL();
    }
}

