/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;

public class FKProxySetDB2
extends IndexProxySet {
    public FKProxySetDB2(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public RelationalObjectProxy createProxy(DesignObject designObject) {
        return new FKProxyDB2((Index)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new FKProxyDB2(design, string, string2, this.getStorageDesign());
    }

    @Override
    protected void add(Index[] indexArray) {
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            if (!index.isFK()) continue;
            this.add(index);
        }
    }

    @Override
    public void changed(ModelObjectSet modelObjectSet, ModelObjectSetEvent modelObjectSetEvent) {
        Index index;
        if (modelObjectSetEvent.isAdded()) {
            Index index2 = (Index)modelObjectSetEvent.getAffected();
            if (index2.isFK()) {
                this.add(index2);
                this.fireUpdate();
            }
        } else if (modelObjectSetEvent.isRemoved() && this.containsId((index = (Index)modelObjectSetEvent.getAffected()).getObjectID())) {
            this.remove((Index)modelObjectSetEvent.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    public void add(DesignObject designObject) {
        String string = designObject.getObjectID();
        if (this.containsId(string)) {
            if (!this.getProxy(string).isLoaded()) {
                this.getProxy(string).loadDesignObject();
            }
        } else if (designObject instanceof KeyObject && ((KeyObject)designObject).isFK()) {
            RelationalObjectProxy relationalObjectProxy = this.createProxy(designObject);
            try {
                this.add(relationalObjectProxy);
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error in FKProxySetDB2.add");
            }
            this.fireUpdate();
        }
    }
}

