/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;

public class FKProxyDB2
extends IndexProxy
implements StorageObjectListener {
    protected String deleteRule = DELETE_RULE_STATES[0];
    protected String enforced = YES_NO_STATES[0];
    public static final String[] DELETE_RULE_STATES = new String[]{"RESTRICT", "NO ACTION", "CASCADE", "SET NULL"};
    private static Set deleteRuleSet = null;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;

    public FKProxyDB2(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public FKProxyDB2(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
        this.fireChange(objectChangeEvent);
    }

    public String getColumns() {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(columnProxyArray[i].getName());
        }
        return stringBuffer.toString();
    }

    public String getReferenceColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        Column[] columnArray = (Column[])index.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < columnArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(columnArray[i].getName());
        }
        return stringBuffer.toString();
    }

    public Column[] getRefColumns() {
        Index index = this.getIndex().getFKAssociation().getRemoteIndex();
        return (Column[])index.getElements();
    }

    public Table getRemoteTable() {
        return this.getIndex().getFKAssociation().getRemoteTable();
    }

    public String getReferenceTable() {
        TableProxyDB2 tableProxyDB2 = (TableProxyDB2)this.getStorageDesign().getTableProxySet().getProxy(this.getRemoteTable().getObjectID());
        return tableProxyDB2.getLongName();
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public KeyObject getKey() {
        return this.getIndex().getFKAssociation().getKeyObject();
    }

    @Override
    public String getObjectTypeName() {
        return "ForeignKey";
    }

    public static String[] getDeleteRuleChoices() {
        return DELETE_RULE_STATES;
    }

    protected boolean checkDeleteRule(String string) {
        if (deleteRuleSet == null) {
            deleteRuleSet = new HashSet();
            deleteRuleSet.addAll(Arrays.asList(FKProxyDB2.getDeleteRuleChoices()));
        }
        return deleteRuleSet.contains(string);
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String string) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(FKProxyDB2.getYesNoChoices()));
        }
        return yesNoSet.contains(string);
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(String string) {
        if (this.checkDeleteRule(string)) {
            this.deleteRule = string;
            this.fireDataFieldChange();
        }
    }

    public String getEnforced() {
        return this.enforced;
    }

    public void setEnforced(String string) {
        if (this.checkYesNo(string)) {
            this.enforced = string;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String string = index.isFK() && index.getFKAssociation() != null ? index.getFKAssociation().getName() : index.getName();
        string = this.applyNameSubstitution(string);
        return string;
    }
}

