/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.editor.storage.db2.ColumnPropertyDialogDB2;

public class ColumnProxyDB2
extends ColumnProxy {
    private static String[] bitDataChoices = new String[]{"", "SBCS", "BIT", "MIXED"};
    private static Set bitDataChoicesSet = null;
    private String bitData = bitDataChoices[0];
    private boolean containDefault = false;
    private static String[] defaultValueChoices = new String[]{"", "constant", "USER", "CURRENT SQLID", "CAST FUNCTION"};
    private String defaultValue = defaultValueChoices[0];
    private String defaultConstant = "";
    private String label = "";
    private String program = "";
    private String constant = "";
    private float updatRatePercent = 0.0f;
    private float averageLength = -1.0f;
    private float growthPercent = 0.0f;
    private long initial = 1L;
    private long frequencyCount = 1L;
    private float frequencyPercent = 0.0f;
    protected ColumnIdentityDB2 identity = null;
    private boolean useIdentity = true;

    public ColumnProxyDB2(Column column, StorageDesign storageDesign) {
        super(column, storageDesign);
    }

    public ColumnProxyDB2(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
    }

    public int getColno() {
        Column column = (Column)this.getObject();
        Table table = (Table)column.getContainer();
        return table.getIndexOf(column) + 1;
    }

    public int getKeyseq() {
        Column column = (Column)this.getObject();
        ContainerWithKeyObject containerWithKeyObject = column.getContainerWithKeyObject();
        KeyObject keyObject = containerWithKeyObject.getPK();
        if (keyObject != null && keyObject.getIndexOf(column) != -1) {
            return keyObject.getIndexOf(column) + 1;
        }
        return 0;
    }

    public static String[] getBitDataChoices() {
        return bitDataChoices;
    }

    protected boolean checkBitData(String string) {
        if (bitDataChoicesSet == null) {
            bitDataChoicesSet = new HashSet();
            bitDataChoicesSet.addAll(Arrays.asList(ColumnProxyDB2.getBitDataChoices()));
        }
        return bitDataChoicesSet.contains(string);
    }

    public void setBitData(String string) {
        if (this.checkBitData(string)) {
            this.bitData = string;
            this.fireDataFieldChange();
        }
    }

    public String getBitData() {
        return this.bitData;
    }

    public void setDefault(boolean bl) {
        this.containDefault = bl;
        this.fireDataFieldChange();
    }

    public boolean getDefault() {
        return this.containDefault;
    }

    public static String[] getDefaultValueChoices() {
        return defaultValueChoices;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
        this.fireDataFieldChange();
    }

    public void setDefaultValueConstant(String string) {
        this.defaultConstant = string;
        this.fireDataFieldChange();
    }

    public String getDefaultValueConstant() {
        if ((this.defaultConstant == null || "".equalsIgnoreCase(this.defaultConstant)) && this.isLoaded()) {
            this.defaultConstant = this.getColumn().getDefaultValue();
            this.fireDataFieldChange();
        }
        return this.defaultConstant;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setLabel(String string) {
        this.label = string;
        this.fireDataFieldChange();
    }

    public String getLabel() {
        return this.label;
    }

    public void setProgram(String string) {
        this.program = string;
        this.fireDataFieldChange();
    }

    public String getProgram() {
        return this.program;
    }

    public void setConstant(String string) {
        this.constant = string;
        this.fireDataFieldChange();
    }

    public String getConstant() {
        return this.constant;
    }

    public boolean checkUpdateRatePercent(float f) {
        return f >= 0.0f && f < 10000.0f;
    }

    public void setUpdateRatePercent(float f) {
        if (this.checkUpdateRatePercent(f)) {
            this.updatRatePercent = f;
            this.fireDataFieldChange();
        }
    }

    public float getUpdateRatePercent() {
        return this.updatRatePercent;
    }

    public boolean checkAverageLength(float f) {
        return f >= -1.0f && f <= 32704.0f;
    }

    public void setAverageLength(float f) {
        if (this.checkAverageLength(f)) {
            this.averageLength = f;
            this.fireDataFieldChange();
        }
    }

    public float getAverageLength() {
        return this.averageLength;
    }

    public boolean checkGrowthPercent(float f) {
        return f >= 0.0f && f <= 100.0f;
    }

    public void setGrowthPercent(float f) {
        if (this.checkGrowthPercent(f)) {
            this.growthPercent = f;
            this.fireDataFieldChange();
        }
    }

    public float getGrowthPercent() {
        return this.growthPercent;
    }

    public boolean checkInitial(long l) {
        return l >= 1L && l <= 0xFFFFFFFEL;
    }

    public void setInitial(long l) {
        if (this.checkInitial(l)) {
            this.initial = l;
            this.fireDataFieldChange();
        }
    }

    public long getInitial() {
        return this.initial;
    }

    public boolean checkFrequencyCount(long l) {
        return l >= 1L && l <= 0xFFFFFFFEL;
    }

    public void setFrequencyCount(long l) {
        if (this.checkFrequencyCount(l)) {
            this.frequencyCount = l;
            this.fireDataFieldChange();
        }
    }

    public long getFrequencyCount() {
        return this.frequencyCount;
    }

    public boolean checkFrequencyPercent(float f) {
        return f >= 0.0f && f <= 100.0f;
    }

    public void setFrequencyPercent(float f) {
        if (this.checkFrequencyPercent(f)) {
            this.frequencyPercent = f;
            this.fireDataFieldChange();
        }
    }

    public float getFrequencyPercent() {
        return this.frequencyPercent;
    }

    public ColumnIdentityDB2 getColumnIdentity() {
        return this.identity;
    }

    public void setColumnIdentity(ColumnIdentityDB2 columnIdentityDB2) {
        if (!(columnIdentityDB2 == null && this.getStorageDesign().isLoading() || this.identity == columnIdentityDB2)) {
            this.identity = columnIdentityDB2;
            if (columnIdentityDB2 != null) {
                columnIdentityDB2.setColumn(this);
            }
            this.fireDataFieldChange();
        }
    }

    public boolean isUseIdentity() {
        return this.useIdentity;
    }

    public void setUseIdentity(boolean bl) {
        this.useIdentity = bl;
    }

    public DistinctTypeDB2 getDistinctType() {
        if (this.getColumn().getUse() == 0) {
            Domain domain = this.getColumn().getDomain();
            DistinctTypeSetDB2 distinctTypeSetDB2 = ((AbstractStorageDesignDB2)this.getStorageDesign()).getDistinctTypeSet();
            return distinctTypeSetDB2.getDistinctType(domain);
        }
        return null;
    }

    @Override
    public String getDatatypeString() {
        Column column = this.getColumn();
        if (column.isOid() || column.isReference()) {
            return "DECIMAL(31 , 0)";
        }
        return this.getDataType().toString();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ColumnPropertyDialogDB2 columnPropertyDialogDB2 = new ColumnPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            columnPropertyDialogDB2.show();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        super.changed(designObject, objectChangeEvent);
        if (objectChangeEvent.isType(ObjectChangeEvent.USE_DEFAULT_CHANGED) && designObject == this.getColumn()) {
            this.setDefault(this.getColumn().getUsesDefaultValue());
        }
    }

    public ColumnIdentityDB2 createColumnIdentity() {
        if (this.identity == null) {
            this.identity = ((StorageDesignDB2v70)this.getStorageDesign()).getColumnIdentitySet().createColumnIdentity();
        }
        return this.identity;
    }

    public void removeColumnIdentity() {
        if (this.identity != null) {
            this.identity.remove(true);
        }
        this.identity = null;
    }
}

