/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;

public class ColumnIdentityDB2
extends AbstractStorageObjectDB2 {
    protected static final String[] GENERATE = new String[]{"ALWAYS", "BY DEFAULT"};
    protected ColumnProxyDB2 column = null;
    protected String generate = GENERATE[0];
    protected String startWith = "1";
    protected int incrementBy = 1;
    protected String maxValue = "";
    protected String minValue = "";
    protected boolean cycle = false;
    protected int cache = 20;
    public static final String TYPE_NAME = "ColumnIdentity";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "CI";
    }

    public ColumnProxyDB2 getColumn() {
        return this.column;
    }

    public void setColumn(ColumnProxyDB2 columnProxyDB2) {
        this.column = columnProxyDB2;
        this.fireDataFieldChange();
    }

    public String getGenerate() {
        if (this.column != null && !this.column.isGenerateAlwaysChanged()) {
            boolean bl = this.column.getColumn().isAutoIncrementGenerateAlways();
            return bl ? GENERATE[0] : GENERATE[1];
        }
        return this.generate;
    }

    public void setGenerate(String string) {
        this.generate = string;
        this.fireDataFieldChange();
    }

    public String getStartWith() {
        if (this.column != null && !this.column.isStartWithChanged()) {
            return this.column.getColumn().getAutoIncrementStartWith();
        }
        return this.startWith;
    }

    public void setStartWith(String string) {
        this.startWith = string;
        this.fireDataFieldChange();
    }

    public int getIncrementBy() {
        if (this.column != null && !this.column.isIncrementByChanged()) {
            return this.column.getColumn().getAutoIncrementIncrementBy();
        }
        return this.incrementBy;
    }

    public void setIncrementBy(int n) {
        this.incrementBy = n;
        this.fireDataFieldChange();
    }

    public String getMaxValue() {
        if (this.column != null && !this.column.isMaxValueChanged()) {
            String string = this.column.getColumn().getAutoIncrementMaxValue();
            return string == null ? "" : string;
        }
        return this.maxValue;
    }

    public void setMaxValue(String string) {
        this.maxValue = string;
        this.fireDataFieldChange();
    }

    public String getMinValue() {
        if (this.column != null && !this.column.isMinValueChanged()) {
            String string = this.column.getColumn().getAutoIncrementMinValue();
            return string == null ? "" : string;
        }
        return this.minValue;
    }

    public void setMinValue(String string) {
        this.minValue = string;
        this.fireDataFieldChange();
    }

    public boolean isCycle() {
        if (this.column != null && !this.column.isCycleChanged()) {
            return this.column.getColumn().isAutoIncrementCycle();
        }
        return this.cycle;
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
        this.fireDataFieldChange();
    }

    public int getCache() {
        if (this.column != null && !this.column.isCacheChanged()) {
            Column column = this.column.getColumn();
            if (column.isAutoIncrementDisableCache()) {
                return 0;
            }
            Integer n = column.getAutoIncrementCache();
            return n == null ? 0 : n;
        }
        return this.cache;
    }

    public void setCache(int n) {
        this.cache = n;
        this.fireDataFieldChange();
    }

    public static String[] getGenerateValues() {
        return GENERATE;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public void copy(StorageDesign storageDesign) {
        ColumnIdentityDB2 columnIdentityDB2 = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)storageDesign).getColumnIdentitySet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                columnIdentityDB2 = (ColumnIdentityDB2)storageObject;
            }
        } else {
            columnIdentityDB2 = ((AbstractStorageDesignDB2)storageDesign).getColumnIdentitySet().createColumnIdentity();
        }
        if (columnIdentityDB2 != null) {
            columnIdentityDB2.setName(this.getName());
            columnIdentityDB2.setGenerate(this.getGenerate());
            columnIdentityDB2.setStartWith(this.getStartWith());
            columnIdentityDB2.setIncrementBy(this.getIncrementBy());
            columnIdentityDB2.setCache(this.getCache());
            columnIdentityDB2.setCycle(this.isCycle());
            columnIdentityDB2.setMinValue(this.getMinValue());
            columnIdentityDB2.setMaxValue(this.getMaxValue());
            columnIdentityDB2.setRawObject(false);
        }
    }
}

