/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class TableProxySet
extends ProxyDesignObjectSet {
    public TableProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getTableSet();
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject designObject) {
        return new TableProxy((Table)designObject, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String string, String string2) {
        return new TableProxy(design, string, string2, this.getStorageDesign());
    }

    public TableProxy getByUserSchemaAndName(String string, String string2) {
        Iterator iterator = this.getElements().iterator();
        TableProxy tableProxy = null;
        while (iterator.hasNext()) {
            tableProxy = (TableProxy)iterator.next();
            if (tableProxy.getUserSchema() != null && tableProxy.getUserSchema().getName().equalsIgnoreCase(string) && string2.equalsIgnoreCase(tableProxy.getName())) {
                return tableProxy;
            }
            Table table = (Table)tableProxy.getObject();
            if (!table.getSchema().equalsIgnoreCase(string) || !string2.equalsIgnoreCase(tableProxy.getName())) continue;
            return tableProxy;
        }
        return null;
    }

    public TableProxy getBySchemaRelAndName(String string, String string2) {
        Iterator iterator = this.getElements().iterator();
        TableProxy tableProxy = null;
        while (iterator.hasNext()) {
            tableProxy = (TableProxy)iterator.next();
            Table table = (Table)tableProxy.getObject();
            if (!table.getSchema().equalsIgnoreCase(string) || !string2.equalsIgnoreCase(tableProxy.getName())) continue;
            return tableProxy;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON", 16);
    }
}

