/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.RelationalObjectProxySetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalContainerProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class TableProxy
extends RelationalContainerProxy
implements RelationalObjectProxySetListener,
StorageObjectListener {
    public static final ObjectChangeEvent TABLESPACE_CHANGED = new ObjectChangeEvent("Tablespace changed");
    private boolean generatePK = true;
    private String pkName = null;
    private boolean commentChanged = false;
    private boolean commentInRDBMSChanged = false;
    protected StorageObjectCollection columns;
    protected StorageObjectCollection indexes;
    protected StorageObjectCollection integrityIndexes;
    public static String NONE = "None";
    public static String BACKUP_RENAME = "Rename";
    public static String BACKUP_UNLOAD = "Unload";
    public static String BACKUP_UNLOAD_PARTITION = "Unload per partition";
    public static String RESTORE = "Restore";
    private String restoreOption = RESTORE;
    private String backupOption = BACKUP_RENAME;

    public TableProxy(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        this.integrityIndexes = new StorageObjectCollection();
        this.integrityIndexes.setParent(this);
        this.integrityIndexes.setName(Messages.getString("TableProxy.IntegrityIndexes"));
        this.columns = new StorageObjectCollection();
        this.columns.setParent(this);
        this.columns.setName(Messages.getString("TableProxy.Columns"));
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.indexes = new StorageObjectCollection();
        this.indexes.setParent(this);
        this.indexes.setName(Messages.getString("TableProxy.Indexes"));
        this.indexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addColumnProxyFromDesign(storageDesign.getColumnProxySet());
        this.addIndexProxyFromDesign(storageDesign.getIndexProxySet());
        storageDesign.getIndexProxySet().addSetListener(this);
    }

    public TableProxy(Design design, String string, String string2, StorageDesign storageDesign) {
        super(design, string, string2, storageDesign);
        this.integrityIndexes = new StorageObjectCollection();
        this.integrityIndexes.setParent(this);
        this.integrityIndexes.setName("Integrity Indexes");
        this.columns = new StorageObjectCollection();
        this.columns.setParent(this);
        this.columns.setName("Columns");
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.indexes = new StorageObjectCollection();
        this.indexes.setParent(this);
        this.indexes.setName("Indexes");
        this.indexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addColumnProxyFromDesign(storageDesign.getColumnProxySet());
        this.addIndexProxyFromDesign(storageDesign.getIndexProxySet());
        storageDesign.getIndexProxySet().addSetListener(this);
    }

    @Override
    public String getObjectTypeName() {
        return "Table";
    }

    @Override
    public boolean isTable() {
        return true;
    }

    public String getPKName() {
        String string = null;
        if (this.pkName != null) {
            string = this.pkName;
        } else if (this.getObject() != null) {
            string = this.pkName = ((Table)this.getObject()).getPKName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setPKName(String string) {
        this.pkName = string;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public IndexProxy[] getIndexProxies() {
        KeyObject[] keyObjectArray = ((Table)this.getObject()).getKeys();
        ArrayList<IndexProxy> arrayList = new ArrayList<IndexProxy>();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            IndexProxy indexProxy = (IndexProxy)this.getStorageDesign().getIndexProxySet().getProxy(keyObjectArray[i].getObjectID());
            if (indexProxy == null) continue;
            arrayList.add(indexProxy);
        }
        return arrayList.toArray(new IndexProxy[0]);
    }

    @Override
    public ColumnProxy[] getColumnProxies() {
        return super.getColumnProxies();
    }

    @Override
    public ColumnProxy getColumnProxy(String string) {
        return super.getColumnProxy(string);
    }

    public void setGeneratePK(boolean bl) {
        this.generatePK = bl;
    }

    public boolean getGeneratePK() {
        return this.generatePK;
    }

    @Override
    public void changed(RelationalObjectProxySet relationalObjectProxySet, ModelObjectSetEvent modelObjectSetEvent) {
        IndexProxy indexProxy;
        if (modelObjectSetEvent.isType(1)) {
            IndexProxy indexProxy2;
            if (modelObjectSetEvent.getAffected() instanceof IndexProxy && !((Index)(indexProxy2 = (IndexProxy)modelObjectSetEvent.getAffected()).getObject()).isFK() && this.getObject() == ((Index)indexProxy2.getObject()).getContainerWithKeyObject()) {
                indexProxy2.setParent(this.indexes);
                this.indexes.add(indexProxy2);
            }
        } else if (modelObjectSetEvent.isType(0) && modelObjectSetEvent.getAffected() instanceof IndexProxy && this.indexes.contains(indexProxy = (IndexProxy)modelObjectSetEvent.getAffected())) {
            this.indexes.remove(modelObjectSetEvent.getAffected());
        }
    }

    protected void addColumnProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Table table = (Table)this.getObject();
        for (Column column : table.getElementsCollection()) {
            StorageObject storageObject = relationalObjectProxySet.getStorageDesign().getStorageObject(column.getObjectID());
            if (storageObject != null && storageObject instanceof ColumnProxy) {
                ColumnProxy columnProxy = (ColumnProxy)storageObject;
                columnProxy.setParent(this.columns);
                this.columns.addWithoutCheck(columnProxy);
                if (columnProxy.getTableProxyR() != null) continue;
                columnProxy.setTableProxyW(this);
                continue;
            }
            int n = 1;
            ++n;
        }
    }

    ColumnProxy getAndRemoveColumnProxy(List list, Column column) {
        for (int i = list.size() - 1; i > -1; --i) {
            ColumnProxy columnProxy = (ColumnProxy)list.get(i);
            if (columnProxy.getObject() != column) continue;
            list.remove(i);
            return columnProxy;
        }
        return null;
    }

    protected void addIndexProxyFromDesign(RelationalObjectProxySet relationalObjectProxySet) {
        Iterator iterator = relationalObjectProxySet.iterator();
        while (iterator.hasNext()) {
            IndexProxy indexProxy = (IndexProxy)iterator.next();
            Index index = (Index)indexProxy.getObject();
            Table table = (Table)this.getObject();
            if (index.isFK() || table != index.getContainerWithKeyObject()) continue;
            indexProxy.addObjectListener(this);
            indexProxy.setParent(this.indexes);
            this.indexes.addWithoutCheck(indexProxy);
        }
    }

    protected void addIndexProxyWithoutCheck(IndexProxy indexProxy) {
        indexProxy.setParent(this.indexes);
        this.indexes.addWithoutCheck(indexProxy);
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.columns;
            }
            case 1: {
                return this.indexes;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.columns) {
            return 0;
        }
        if (modelObject == this.indexes) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if (object == this.columns) {
            return 0;
        }
        if (object == this.indexes) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(StorageObject storageObject, ObjectChangeEvent objectChangeEvent) {
    }

    @Override
    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    @Override
    public void setCommentChanged(boolean bl) {
        this.commentChanged = bl;
    }

    @Override
    public boolean isCommentInRDBMSChanged() {
        return this.commentInRDBMSChanged;
    }

    @Override
    public void setCommentInRDBMSChanged(boolean bl) {
        this.commentInRDBMSChanged = bl;
    }

    public ColumnProxy getColumnProxyByName(String string) {
        ColumnProxy[] columnProxyArray = this.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (!string.equalsIgnoreCase(columnProxy.getName())) continue;
            return columnProxy;
        }
        return null;
    }

    public StorageObject getUserSchema() {
        return null;
    }

    public void setUserSchema(String string) {
    }

    public StorageObjectCollection getIndexes() {
        return this.indexes;
    }

    public boolean isUnload() {
        return false;
    }

    public boolean isUnloadPerPartition() {
        return false;
    }

    public String getRestoreOption() {
        return this.restoreOption;
    }

    public void setRestoreOption(String string) {
        this.restoreOption = string;
    }

    public String getBackupOption() {
        return this.backupOption;
    }

    public void setBackupOption(String string) {
        this.backupOption = string;
    }

    public void addObject(StorageObject storageObject) {
        if (storageObject instanceof ColumnProxy) {
            ColumnProxy columnProxy = (ColumnProxy)storageObject;
            if (this.getObject() == ((Column)columnProxy.getObject()).getContainerWithKeyObject()) {
                columnProxy.setParent(this.columns);
                this.columns.add(storageObject);
            }
        }
    }

    public void removeObject(StorageObject storageObject) {
        if (storageObject instanceof ColumnProxy) {
            this.columns.remove(storageObject);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLE_ICON", 16);
    }

    public List getSAC_StorageObjects() {
        return Collections.EMPTY_LIST;
    }

    public List getColumnsSortedByID() {
        if (this.columns.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        this.columns.addAllElementsTo(arrayList);
        Collections.sort(arrayList, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
        return arrayList;
    }

    public StorageObjectCollection getColumns() {
        return this.columns;
    }

    public StorageObjectCollection getTriggers() {
        return null;
    }

    public String getSchemaImplementationName() {
        if (this.getStorageDesign().isOpen()) {
            SchemaObject schemaObject;
            StorageObject storageObject = this.getUserSchema();
            if (storageObject != null) {
                return storageObject.getName();
            }
            ContainerObject containerObject = (ContainerObject)this.getObject();
            if (containerObject != null && (schemaObject = containerObject.getSchemaObject()) != null) {
                return this.getStorageDesign().getSchemaImplementationNane(schemaObject);
            }
        } else {
            SchemaObject schemaObject;
            ContainerObject containerObject = (ContainerObject)this.getObject();
            if (containerObject != null && (schemaObject = containerObject.getSchemaObject()) != null) {
                return schemaObject.getName();
            }
        }
        return "";
    }

    public static void clearEvents() {
        TABLESPACE_CHANGED.setAffected(null);
    }
}

